/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.navigator.voice;

import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.eclipse.actf.ai.navigator.util.MessageFormatter;
import org.eclipse.actf.ai.tts.ITTSEngine;
import org.eclipse.actf.ai.voice.IVoice;
import org.eclipse.actf.ai.voice.IVoiceEventListener;
import org.eclipse.actf.ai.voice.VoiceUtil;

public class VoiceManager
implements IVoice {
    private static SingletonVoice sv;
    private static final MessageFormatter messageFormatter;
    private IVoiceEventListener eventListener;
    private int currentIndex = 0;

    static {
        messageFormatter = new MessageFormatter("org.eclipse.actf.ai.navigator.message.Speech");
    }

    private SingletonVoice getSV() {
        return sv;
    }

    private IVoice getVoice() {
        return this.getSV().voice;
    }

    private void manageCallback() {
        this.getSV().manageCallback();
    }

    private void addEventQueue() {
        this.getSV().addEventQueue(this);
    }

    public MessageFormatter getMessageFormatter() {
        return messageFormatter;
    }

    private String speakString(String str, boolean maleVoice) {
        return str;
    }

    public void speak(String str, boolean flush, boolean maleVoice) {
        if (flush) {
            this.manageCallback();
        }
        this.getVoice().speak(this.speakString(str, maleVoice), flush);
    }

    public void speakWithFormat(String str, boolean flush, boolean maleVoice) {
        this.speak(this.getMessageFormatter().mes(str), flush, maleVoice);
    }

    public int getSpeed() {
        return this.getVoice().getSpeed();
    }

    public void setSpeed(int speed) {
        this.getVoice().setSpeed(speed);
    }

    public void speakWithCallback(String str, boolean flush, boolean maleVoice) {
        if (flush) {
            this.manageCallback();
        }
        if (str.length() > 0) {
            this.addEventQueue();
            this.getVoice().speak(this.speakString(str, maleVoice), flush, this.currentIndex);
        } else if (this.eventListener != null) {
            this.eventListener.indexReceived(-1);
        }
    }

    public void stop() {
        this.manageCallback();
        this.getVoice().stop();
    }

    public VoiceManager(IVoiceEventListener listener) {
        if (sv == null) {
            sv = new SingletonVoice();
        }
        this.eventListener = listener;
    }

    public ITTSEngine getTTSEngine() {
        return this.getVoice().getTTSEngine();
    }

    public void setEventListener(IVoiceEventListener eventListener) {
        this.eventListener = eventListener;
    }

    public void speak(String text, boolean flush) {
        this.speak(text, flush, true);
    }

    public void speak(String text, boolean flush, int index) {
        this.currentIndex = index;
        this.speakWithCallback(text, flush, true);
    }

    private static class SingletonVoice
    implements IVoiceEventListener {
        final IVoice voice;
        final LinkedList<VoiceManager> callbackQueue = new LinkedList();
        VoiceManager lastVoiceManager;

        public void indexReceived(int index) {
            VoiceManager vm;
            try {
                vm = index < 0 ? this.callbackQueue.removeFirst() : this.callbackQueue.getFirst();
            }
            catch (NoSuchElementException noSuchElementException) {
                return;
            }
            if (vm != null && vm.eventListener != null) {
                vm.eventListener.indexReceived(index);
            }
        }

        void manageCallback() {
            for (VoiceManager vm : this.callbackQueue) {
                if (vm.eventListener == null) continue;
                vm.eventListener.indexReceived(-1);
            }
            this.callbackQueue.clear();
        }

        void addEventQueue(VoiceManager vm) {
            this.callbackQueue.add(vm);
            this.lastVoiceManager = vm;
        }

        SingletonVoice() {
            this.voice = VoiceUtil.getVoice();
            this.voice.setEventListener((IVoiceEventListener)this);
        }
    }
}

