/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.navigator.userinfo.impl;

import java.util.Iterator;
import org.eclipse.actf.ai.fennec.treemanager.ITreeItem;
import org.eclipse.actf.ai.navigator.userinfo.IMetaDataModifier;
import org.eclipse.actf.ai.navigator.userinfo.IUserInfoConstants;
import org.eclipse.actf.ai.navigator.userinfo.IUserInfoGenerator;
import org.eclipse.actf.ai.xmlstore.IXMLEditableInfo;
import org.eclipse.actf.ai.xmlstore.IXMLInfo;
import org.eclipse.actf.ai.xmlstore.IXMLSelector;
import org.eclipse.actf.ai.xmlstore.IXMLStore;
import org.eclipse.actf.ai.xmlstore.IXMLStoreService;
import org.eclipse.actf.ai.xmlstore.XMLStoreException;
import org.eclipse.actf.ai.xmlstore.XMLStoreServiceUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MetaDataModifier
implements IUserInfoConstants,
IMetaDataModifier {
    private IUserInfoGenerator generator;
    private ITreeItem item;
    private String text;
    private String site;
    private String pageTitle;

    public String toString(IUserInfoGenerator.Result result) {
        return this.generator.toString(result);
    }

    public IUserInfoGenerator.Result commit(boolean save) throws XMLStoreException {
        IXMLEditableInfo info = this.getUserInfo();
        info.setPageTitle(this.pageTitle);
        IUserInfoGenerator.Result result = IUserInfoGenerator.Result.NOTHING;
        if (this.generator != null) {
            if (this.item == null) {
                return IUserInfoGenerator.Result.ERROR;
            }
            Document infoDocument = info.getRootNode().getOwnerDocument();
            Node parent = infoDocument.getElementsByTagNameNS("http://www.ibm.com/xmlns/prod/aiBrowser/fennec", "attach").item(0);
            Node node = this.item.serializeQuery(parent);
            if (node == null) {
                return IUserInfoGenerator.Result.ERROR;
            }
            result = this.generator.addUserInfo(node, this.text);
            if (!node.hasChildNodes()) {
                parent.removeChild(node);
            }
        }
        if (save) {
            info.save();
        }
        return result;
    }

    private IXMLEditableInfo getUserInfo() throws XMLStoreException {
        IXMLStoreService service = XMLStoreServiceUtil.getXMLStoreService();
        IXMLEditableInfo info = this.getStoredUserInfo(service);
        if (info != null) {
            return info;
        }
        return this.createNewUserInfo(service);
    }

    private IXMLEditableInfo getStoredUserInfo(IXMLStoreService service) {
        IXMLSelector sel1;
        IXMLStore store0 = service.getRootStore();
        IXMLStore store1 = store0.specify(sel1 = service.getSelectorWithDocElem("fennec", "http://www.ibm.com/xmlns/prod/aiBrowser/fennec"));
        if (store1 == null) {
            return null;
        }
        IXMLSelector sel2 = service.getSelectorWithURI(this.site);
        IXMLStore store2 = store1.specify(sel2);
        if (store2 == null) {
            return null;
        }
        Iterator i = store2.getInfoIterator();
        while (i.hasNext()) {
            IXMLInfo info = (IXMLInfo)i.next();
            if (!info.isUserEntry() || !(info instanceof IXMLEditableInfo)) continue;
            return (IXMLEditableInfo)info;
        }
        return null;
    }

    private IXMLEditableInfo createNewUserInfo(IXMLStoreService service) throws XMLStoreException {
        IXMLEditableInfo info = service.newUserXML("http://www.ibm.com/xmlns/prod/aiBrowser/fennec", "fennec", this.site);
        info.setPageTitle(this.pageTitle);
        Node root = info.getRootNode();
        Document doc = root.getOwnerDocument();
        Element node = doc.createElementNS("http://www.ibm.com/xmlns/prod/aiBrowser/fennec", "attach");
        node.setAttributeNS("http://www.ibm.com/xmlns/prod/aiBrowser/fennec/xml-query", "loc:path", ".");
        root.appendChild(node);
        return info;
    }

    public boolean remove() throws XMLStoreException {
        IXMLStoreService service = XMLStoreServiceUtil.getXMLStoreService();
        IXMLEditableInfo info = this.getStoredUserInfo(service);
        if (info == null) {
            return false;
        }
        info.remove();
        return true;
    }

    public String getSite() {
        return this.site;
    }

    public void setSite(String targetSite) {
        this.site = targetSite;
    }

    public ITreeItem getItem() {
        return this.item;
    }

    public void setItem(ITreeItem item) {
        this.item = item;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public IUserInfoGenerator getGenerator() {
        return this.generator;
    }

    public void setGenerator(IUserInfoGenerator generator) {
        this.generator = generator;
    }

    public void setPageTitle(String pageTitle) {
        this.pageTitle = pageTitle;
    }
}

