/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.navigator.extension;

import java.util.ArrayList;
import org.eclipse.actf.ai.navigator.IScreenReaderControl;
import org.eclipse.actf.model.ui.editor.browser.IWebBrowserACTF;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;

public class ScreenReaderExtension {
    private static final String TAG_CONTROLLER = "controller";
    private static final String ATTR_CLASS = "class";
    private static ScreenReaderExtension[] cachedExtensions;
    private final IConfigurationElement configElement;
    private IScreenReaderControl controller;

    public static ScreenReaderExtension[] getExtensions() {
        if (cachedExtensions != null) {
            return cachedExtensions;
        }
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.actf.ai.navigator", "ScreenReaderController").getExtensions();
        ArrayList<ScreenReaderExtension> l = new ArrayList<ScreenReaderExtension>();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                ScreenReaderExtension ex = ScreenReaderExtension.parseExtension(configElements[j], l.size());
                if (ex != null) {
                    l.add(ex);
                }
                ++j;
            }
            ++i;
        }
        cachedExtensions = l.toArray(new ScreenReaderExtension[l.size()]);
        return cachedExtensions;
    }

    private static ScreenReaderExtension parseExtension(IConfigurationElement configElement, int idx) {
        if (!configElement.getName().equals(TAG_CONTROLLER)) {
            return null;
        }
        try {
            return new ScreenReaderExtension(configElement);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void disposeExtensions() {
        if (cachedExtensions == null) {
            return;
        }
        int i = 0;
        while (i < cachedExtensions.length) {
            cachedExtensions[i].dispose();
            ++i;
        }
        cachedExtensions = null;
    }

    public static void screenReaderOn() {
        ScreenReaderExtension[] exs = ScreenReaderExtension.getExtensions();
        if (exs == null) {
            return;
        }
        int i = 0;
        while (i < exs.length) {
            exs[i].getScreenReaderControl().screenReaderOn();
            ++i;
        }
    }

    public static void screenReaderOff() {
        ScreenReaderExtension[] exs = ScreenReaderExtension.getExtensions();
        if (exs == null) {
            return;
        }
        int i = 0;
        while (i < exs.length) {
            exs[i].getScreenReaderControl().screenReaderOff();
            ++i;
        }
    }

    public static boolean isAvailable() {
        ScreenReaderExtension[] exs = ScreenReaderExtension.getExtensions();
        if (exs == null) {
            return false;
        }
        boolean result = false;
        int i = 0;
        while (i < exs.length) {
            result |= exs[i].getScreenReaderControl().isAvailable();
            ++i;
        }
        return result;
    }

    public static void takeBackControl(IWebBrowserACTF browser) {
        ScreenReaderExtension[] exs = ScreenReaderExtension.getExtensions();
        if (exs == null) {
            return;
        }
        int i = 0;
        while (i < exs.length) {
            exs[i].getScreenReaderControl().takeBackControl();
            ++i;
        }
    }

    private ScreenReaderExtension(IConfigurationElement configElement) {
        this.configElement = configElement;
    }

    private IScreenReaderControl getScreenReaderControl() {
        if (this.controller != null) {
            return this.controller;
        }
        try {
            this.controller = (IScreenReaderControl)this.configElement.createExecutableExtension(ATTR_CLASS);
        }
        catch (Exception exception) {}
        return this.controller;
    }

    private void dispose() {
        if (this.controller == null) {
            return;
        }
        this.controller = null;
    }
}

