/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.xmlstore.nvdl.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URISyntaxException;
import org.xml.sax.InputSource;

public class IRIUtil {
    public static final String fileSchema = "file:";

    public static InputSource newInputSourceFromFilename(String fileName) throws FileNotFoundException {
        InputSource is = new InputSource(new FileInputStream(fileName));
        is.setSystemId(fileSchema + fileName);
        return is;
    }

    public static String IRIToFilename(String iri) {
        if (iri.startsWith(fileSchema)) {
            URI uri;
            iri = iri.substring(fileSchema.length());
            try {
                uri = new URI(iri);
            }
            catch (URISyntaxException uRISyntaxException) {
                return iri;
            }
            return uri.getPath().replace('/', File.separatorChar);
        }
        return iri;
    }
}

