/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.xmlstore.nvdl.model;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLElement;

public class NVDLTriggerManager {
    List<Trigger> triggers = new ArrayList<Trigger>(0);

    public void addTrigger(String ns, String[] localNames) {
        Trigger t = new Trigger(ns, localNames);
        this.triggers.add(t);
    }

    public String toString() {
        StringBuffer r = new StringBuffer("Triggers:");
        for (Trigger trigger : this.triggers) {
            r.append(trigger);
            r.append(";");
        }
        return r.toString();
    }

    public boolean match(String ns, String localName, LinkedList elemStack) {
        if (elemStack.isEmpty()) {
            return false;
        }
        NVDLElement parent = (NVDLElement)elemStack.getLast();
        int i = 0;
        while (i < this.triggers.size()) {
            Trigger t = this.triggers.get(i);
            if (t.match(ns, localName) && !t.match(parent.ns, parent.localName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean match(NVDLElement e, NVDLElement parent) {
        int i = 0;
        while (i < this.triggers.size()) {
            Trigger t = this.triggers.get(i);
            if (t.match(e.ns, e.localName) && !t.match(parent.ns, parent.localName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static class Trigger {
        final String ns;
        final String[] localNames;

        public String toString() {
            return "{" + this.ns + "}" + this.localNames;
        }

        public boolean match(String ns, String localName) {
            if (this.ns.equals(ns)) {
                int i = 0;
                while (i < this.localNames.length) {
                    if (this.localNames[i].equals(localName)) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }

        Trigger(String ns, String[] localNames) {
            this.ns = ns;
            this.localNames = localNames;
        }
    }
}

