/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.xmlstore.nvdl.fm;

import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLAction;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLElement;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLMode;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLNoResultAction;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLResultAction;

public abstract class Interpretation {
    private NVDLElement element;
    private Object slot;
    private String prefix;
    private final NVDLAction action;
    private final NVDLMode mode;
    private final boolean attach;
    private final boolean unwrap;
    private final boolean attachPlaceHolder;
    private String id;

    public void setSlot(Object slot) {
        this.slot = slot;
    }

    public Object getSlot() {
        return this.slot;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean isSectionHead() {
        return this.action != null;
    }

    public boolean isDispatch() {
        return this.action instanceof NVDLNoResultAction;
    }

    public boolean isAttach() {
        return this.attach;
    }

    public boolean isUnwrap() {
        return this.unwrap;
    }

    public boolean isAttachPlaceHolder() {
        return this.attachPlaceHolder;
    }

    public NVDLMode getMode() {
        return this.mode;
    }

    public NVDLAction getAction() {
        return this.action;
    }

    public NVDLElement getElement() {
        return this.element;
    }

    public abstract Interpretation getParent();

    public String getID() {
        if (this.id == null) {
            this.id = this.generateID();
        }
        return this.id;
    }

    public String getPrevID() {
        Interpretation ip = this.getParent();
        while (ip != null) {
            if (ip.isSectionHead()) {
                return ip.getID();
            }
            ip = ip.getParent();
        }
        return "";
    }

    private String generateID() {
        StringBuffer buf = new StringBuffer();
        Interpretation ip = this;
        while (ip != null) {
            if (ip.isSectionHead()) {
                if (buf.length() > 0) {
                    buf.insert(0, " ");
                }
                String name = ip.action.getName();
                buf.insert(0, name);
            }
            ip = ip.getParent();
        }
        return buf.toString();
    }

    public Interpretation getSectionHeadInterpretation() {
        Interpretation ip = this;
        while (true) {
            if (ip == null) {
                return null;
            }
            if (ip.isSectionHead()) break;
            ip = ip.getParent();
        }
        return ip;
    }

    public Interpretation getEffectiveInterpretation() {
        Interpretation ip = this.getSectionHeadInterpretation();
        if (ip == null) {
            return null;
        }
        if (ip.isUnwrap()) {
            return null;
        }
        if (ip.isDispatch()) {
            return ip;
        }
        ip = ip.getParent();
        while (ip != null) {
            if (ip.isDispatch()) {
                return ip;
            }
            if (ip.isAttachPlaceHolder()) {
                return null;
            }
            ip = ip.getParent();
        }
        return null;
    }

    Interpretation(NVDLMode mode, NVDLAction action, NVDLElement element) {
        this.mode = mode;
        this.action = action;
        this.element = element;
        if (action instanceof NVDLResultAction) {
            NVDLResultAction a = (NVDLResultAction)action;
            switch (a.type) {
                case 3: {
                    this.attach = false;
                    this.unwrap = true;
                    this.attachPlaceHolder = false;
                    break;
                }
                case 2: {
                    this.attach = false;
                    this.attachPlaceHolder = true;
                    this.unwrap = false;
                    break;
                }
                case 1: {
                    this.attach = true;
                    this.unwrap = false;
                    this.attachPlaceHolder = false;
                    break;
                }
                default: {
                    this.attach = false;
                    this.unwrap = false;
                    this.attachPlaceHolder = false;
                    break;
                }
            }
        } else {
            this.attach = false;
            this.unwrap = false;
            this.attachPlaceHolder = false;
        }
    }
}

