/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.ui.editors.ie;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import org.eclipse.actf.model.dom.dombycom.DomByCom;
import org.eclipse.actf.model.dom.html.HTMLParserFactory;
import org.eclipse.actf.model.dom.html.IHTMLParser;
import org.eclipse.actf.model.internal.ui.editors.ie.BrowserIE_Plugin;
import org.eclipse.actf.model.internal.ui.editors.ie.WebBrowserIEComposite;
import org.eclipse.actf.model.internal.ui.editors.ie.WebBrowserIEScrollManager;
import org.eclipse.actf.model.internal.ui.editors.ie.WebBrowserStyleInfoImpl;
import org.eclipse.actf.model.internal.ui.editors.ie.WebBrowserToolbar;
import org.eclipse.actf.model.internal.ui.editors.ie.events.BeforeNavigate2Parameters;
import org.eclipse.actf.model.internal.ui.editors.ie.events.BrowserEventListener;
import org.eclipse.actf.model.internal.ui.editors.ie.events.DocumentCompleteParameters;
import org.eclipse.actf.model.internal.ui.editors.ie.events.INewWiondow2EventListener;
import org.eclipse.actf.model.internal.ui.editors.ie.events.IWindowClosedEventListener;
import org.eclipse.actf.model.internal.ui.editors.ie.events.NavigateComplete2Parameters;
import org.eclipse.actf.model.internal.ui.editors.ie.events.NavigateErrorParameters;
import org.eclipse.actf.model.internal.ui.editors.ie.events.NewWindow2Parameters;
import org.eclipse.actf.model.internal.ui.editors.ie.events.ProgressChangeParameters;
import org.eclipse.actf.model.internal.ui.editors.ie.events.StatusTextChangeParameters;
import org.eclipse.actf.model.internal.ui.editors.ie.events.TitleChangeParameters;
import org.eclipse.actf.model.internal.ui.editors.ie.events.WindowClosingParameters;
import org.eclipse.actf.model.internal.ui.editors.ie.win32.RegistryUtilIE;
import org.eclipse.actf.model.ui.IModelServiceHolder;
import org.eclipse.actf.model.ui.IModelServiceScrollManager;
import org.eclipse.actf.model.ui.ImagePositionInfo;
import org.eclipse.actf.model.ui.ModelServiceSizeInfo;
import org.eclipse.actf.model.ui.editor.browser.IWebBrowserACTF;
import org.eclipse.actf.model.ui.editor.browser.IWebBrowserStyleInfo;
import org.eclipse.actf.model.ui.editor.browser.WebBrowserEventUtil;
import org.eclipse.actf.model.ui.util.ScrollBarSizeUtil;
import org.eclipse.actf.util.logging.DebugPrintUtil;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class WebBrowserIEImpl
implements IWebBrowserACTF,
BrowserEventListener {
    private WebBrowserToolbar toolbar;
    private WebBrowserIEComposite browserComposite;
    private boolean _inNavigation = false;
    private boolean _inReload = false;
    private boolean _inStop = false;
    private boolean _inJavascript = false;
    private boolean _urlExist;
    private int _navigateErrorCode;
    private IModelServiceHolder _holder = null;
    private boolean onloadPopupBlock = true;
    private IModelServiceScrollManager scrollManager;
    private DomByCom domByCom;
    private INewWiondow2EventListener newWindow2EventListener = null;
    private IWindowClosedEventListener windowClosedEventListener = null;
    private String errorUrl = null;
    private int tmpErrorCode = 0;

    public WebBrowserIEImpl(IModelServiceHolder holder, Composite parent, String startURL) {
        this._holder = holder;
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        parent.setLayout((Layout)gridLayout);
        this.toolbar = new WebBrowserToolbar(this, parent, 0);
        this.browserComposite = new WebBrowserIEComposite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.browserComposite.setLayout((Layout)layout);
        this.browserComposite.setLayoutData(new GridData(1808));
        if (startURL == null) {
            startURL = "about:blank";
        }
        this.toolbar.setAddressTextString(startURL);
        this.browserComposite.setDisableScriptDebugger(true);
        this.browserComposite.addBrowserEventListener(this);
        this.scrollManager = new WebBrowserIEScrollManager(this);
        this.domByCom = new DomByCom((long)this.getBrowserAddress());
        this.navigate(startURL);
    }

    public void setFocusAddressText(boolean selectAll) {
        this.toolbar.setFocusToAddressText(selectAll);
    }

    public void showAddressText(boolean flag) {
        this.toolbar.showAddressText(flag);
    }

    public void navigate(String url) {
        this.toolbar.setAddressTextString(url);
        this.errorUrl = null;
        this._urlExist = true;
        this._navigateErrorCode = 200;
        this.browserComposite.navigate(url);
    }

    public void goBackward() {
        this.errorUrl = null;
        this.browserComposite.goBack();
    }

    public void goForward() {
        this.errorUrl = null;
        this.browserComposite.goForward();
    }

    public void navigateStop() {
        if (this._inNavigation || this._inReload) {
            this._inStop = true;
            this._inNavigation = false;
            this._inReload = false;
            this._inJavascript = false;
        }
        this.errorUrl = null;
        this.browserComposite.stop();
    }

    public void navigateRefresh() {
        if (!this._inReload) {
            this._inReload = true;
            this._inJavascript = false;
            WebBrowserEventUtil.refreshStart((IWebBrowserACTF)this);
        }
        this.errorUrl = null;
        this.browserComposite.refresh();
    }

    public ModelServiceSizeInfo getBrowserSize(boolean isWhole) {
        int[] tmpSize;
        int[] size = new int[]{1, 1, 1, 1};
        int width = this.browserComposite.getWidth() - 4;
        int height = this.browserComposite.getHeight() - 4;
        int scrollbarWidth = ScrollBarSizeUtil.getVerticalBarWidth();
        size[0] = width - scrollbarWidth;
        size[1] = height;
        size[2] = width - scrollbarWidth;
        size[3] = height;
        if (isWhole && (tmpSize = this.browserComposite.getWholeSize()).length == 2 && tmpSize[0] > -1 && tmpSize[1] > -1) {
            size[2] = tmpSize[0];
            size[3] = tmpSize[1];
            if (tmpSize[0] > size[0]) {
                size[1] = size[1] - scrollbarWidth;
            }
        }
        return new ModelServiceSizeInfo(size[0], size[1], size[2], size[3]);
    }

    public int getReadyState() {
        return this.browserComposite.getReadyState();
    }

    public boolean isReady() {
        return this.getReadyState() == 4;
    }

    public String getURL() {
        return this.browserComposite.getLocationURL();
    }

    public String getLocationName() {
        return this.browserComposite.getLocationName();
    }

    public boolean isUrlExists() {
        return this._urlExist;
    }

    public int getNavigateErrorCode() {
        return this._navigateErrorCode;
    }

    public IModelServiceScrollManager getScrollManager() {
        return this.scrollManager;
    }

    public void scrollY(int y) {
        this.browserComposite.scroll(0, y, 0);
    }

    public void scrollTo(int x, int y) {
        this.browserComposite.scroll(x, y, 1);
    }

    public void setHlinkStop(boolean bStop) {
    }

    public void setWebBrowserSilent(boolean bSilent) {
        this.browserComposite.setSilent(bSilent);
    }

    public void setDisableScriptDebugger(boolean bDisable) {
        this.browserComposite.setDisableScriptDebugger(bDisable);
    }

    public void setDisplayImage(boolean display) {
    }

    public boolean isDisableScriptDebugger() {
        return this.browserComposite.getDisableScriptDebugger();
    }

    public void setFontSize(int fontSize) {
        this.browserComposite.setFontSize(fontSize);
    }

    public int getFontSize() {
        return this.browserComposite.getFontSize();
    }

    public void highlightElementById(String idVal) {
    }

    public void hightlightElementByAttribute(String name, String value) {
    }

    public void clearHighlight() {
    }

    RGB getAnchorColor() {
        String color = RegistryUtilIE.getIERegistryString("Anchor Color");
        return this.getRGB(color);
    }

    RGB getVisitedAnchorColor() {
        String color = RegistryUtilIE.getIERegistryString("Anchor Color Visited");
        return this.getRGB(color);
    }

    private RGB getRGB(String color) {
        if (color != null) {
            try {
                String[] strArray = color.split(",");
                return new RGB(Integer.parseInt(strArray[0]), Integer.parseInt(strArray[1]), Integer.parseInt(strArray[2]));
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public int getBrowserAddress() {
        return this.browserComposite.getBrowserAddress();
    }

    public String[] getSupportMIMETypes() {
        return MIMETYPES_HTML;
    }

    public String[] getSupportExtensions() {
        return EXTS_HTML;
    }

    public void open(String url) {
        this.navigate(url);
    }

    public void open(File target) {
        if (target != null) {
            this.navigate(target.getAbsolutePath());
        }
    }

    public Document getDocument() {
        try {
            File tmpF = BrowserIE_Plugin.getDefault().createTempFile("actf", "html");
            this.saveOriginalDocument(tmpF.getAbsolutePath());
            IHTMLParser parser = HTMLParserFactory.createHTMLParser();
            parser.parse((InputStream)new FileInputStream(tmpF));
            tmpF.delete();
            return parser.getDocument();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Document getLiveDocument() {
        return this.domByCom.getDocument();
    }

    public Composite getTargetComposite() {
        return this.browserComposite;
    }

    public File saveDocumentAsHTMLFile(String file) {
        boolean saveLiveDOM;
        if (file != null && (saveLiveDOM = this.browserComposite.saveLiveDom(file))) {
            return new File(file);
        }
        return null;
    }

    public File saveOriginalDocument(String file) {
        if (file != null) {
            if ("about:blank".equals(this.getURL())) {
                try {
                    FileWriter fw = new FileWriter(file);
                    fw.write("<html></html>");
                    fw.flush();
                    fw.close();
                }
                catch (Exception exception) {
                    return null;
                }
                return new File(file);
            }
            boolean saveOrigHtmlSource = this.browserComposite.save(file);
            if (saveOrigHtmlSource) {
                return new File(file);
            }
        }
        return null;
    }

    public void jumpToNode(Node target) {
    }

    public String getCurrentMIMEType() {
        return MIMETYPES_HTML[0];
    }

    public void beforeNavigate2(BeforeNavigate2Parameters param) {
        String target = param.getUrl();
        DebugPrintUtil.debugPrintln((Object)("BN: " + target + " " + param.getTargetFrameName()));
        if (!this._inReload) {
            if (!target.startsWith("javascript")) {
                this._inJavascript = false;
                this._inNavigation = true;
                this._inReload = false;
            } else {
                this._inJavascript = true;
                this._inNavigation = false;
                this._inReload = false;
            }
        }
        WebBrowserEventUtil.beforeNavigate((IWebBrowserACTF)this, (String)target, (String)param.getTargetFrameName(), (boolean)this._inNavigation);
    }

    public void documentComplete(DocumentCompleteParameters param) {
        if (param.isTopWindow()) {
            if (this.errorUrl != null && this.errorUrl.equals(param.getUrl())) {
                this._navigateErrorCode = this.tmpErrorCode;
                this._urlExist = false;
                this._inNavigation = false;
            }
            WebBrowserEventUtil.rootDocumentComplete((IWebBrowserACTF)this);
            this._inNavigation = false;
            this._inJavascript = false;
            this._inReload = false;
            this.errorUrl = null;
        }
    }

    public void navigateComplete2(NavigateComplete2Parameters param) {
        WebBrowserEventUtil.navigateComplete((IWebBrowserACTF)this, (String)param.getUrl());
        this.toolbar.setAddressTextString(this.browserComposite.getLocationURL());
        DebugPrintUtil.debugPrintln((Object)"NavigateComplete2");
    }

    public void navigateError(NavigateErrorParameters param) {
        String tmpUrl = param.getUrl();
        this.tmpErrorCode = param.getStatusCode();
        DebugPrintUtil.debugPrintln((Object)("Navigate Error. URL:" + tmpUrl + " Status Code:" + this.tmpErrorCode + " " + this.browserComposite.getLocationURL()));
        if (this.browserComposite.getLocationURL().equals(tmpUrl)) {
            this._navigateErrorCode = this.tmpErrorCode;
            this._urlExist = false;
            this._inNavigation = false;
        } else {
            this.errorUrl = tmpUrl;
        }
    }

    public void newWindow2(NewWindow2Parameters param) {
        if (this._inNavigation && this.onloadPopupBlock) {
            param.setCancel(true);
        } else if (this.newWindow2EventListener != null) {
            this.newWindow2EventListener.newWindow2(param);
        }
    }

    public void progressChange(ProgressChangeParameters param) {
        int prog = param.getProgress();
        int progMax = param.getProgressMax();
        WebBrowserEventUtil.progressChange((IWebBrowserACTF)this, (int)prog, (int)progMax);
        DebugPrintUtil.debugPrintln((Object)("Stop: " + this._inStop + " Reload: " + this._inReload + " inJavaScript: " + this._inJavascript + " navigation: " + this._inNavigation));
        if (this._inStop) {
            if (prog == 0 && progMax == 0) {
                this._inStop = false;
                DebugPrintUtil.debugPrintln((Object)"stop fin");
                WebBrowserEventUtil.navigateStop((IWebBrowserACTF)this);
            }
        } else if (this._inReload) {
            if (prog == 0 && progMax == 0) {
                this._inReload = false;
                DebugPrintUtil.debugPrintln((Object)"reload fin");
                WebBrowserEventUtil.refreshComplete((IWebBrowserACTF)this);
            }
        } else if (this._inJavascript) {
            if (prog == -1 && progMax == -1) {
                this._inJavascript = false;
                DebugPrintUtil.debugPrintln((Object)"javascript fin");
            }
        } else if (!(this._inNavigation || prog == 0 && progMax == 0)) {
            this._inReload = true;
            DebugPrintUtil.debugPrintln((Object)"reload");
            WebBrowserEventUtil.refreshStart((IWebBrowserACTF)this);
        }
    }

    public void statusTextChange(StatusTextChangeParameters param) {
    }

    public void titleChange(TitleChangeParameters param) {
        try {
            String title = param.getText();
            WebBrowserEventUtil.titleChange((IWebBrowserACTF)this, (String)title);
            DebugPrintUtil.debugPrintln((Object)"TitleChange");
            if (!(this._inNavigation || this._inStop || this._inReload)) {
                this._inReload = true;
                this._inJavascript = false;
                DebugPrintUtil.debugPrintln((Object)"reload");
                WebBrowserEventUtil.refreshStart((IWebBrowserACTF)this);
            }
            this._holder.setEditorTitle(title);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void windowClosing(WindowClosingParameters param) {
    }

    public void windowClosed() {
        if (this.windowClosedEventListener != null) {
            this.windowClosedEventListener.windowClosed();
        }
    }

    public Object getAttribute(String name) {
        return null;
    }

    public String getID() {
        return String.valueOf(WebBrowserIEImpl.class.getName()) + ":" + this;
    }

    public String getTitle() {
        return this.getLocationName();
    }

    public void setNewWindow2EventListener(INewWiondow2EventListener newWindow2EventListner) {
        this.newWindow2EventListener = newWindow2EventListner;
    }

    public void setWindowClosedEventListener(IWindowClosedEventListener windowClosingEventListener) {
        this.windowClosedEventListener = windowClosingEventListener;
    }

    public ImagePositionInfo[] getAllImagePosition() {
        return this.browserComposite.getAllImagePosition();
    }

    public IModelServiceHolder getModelServiceHolder() {
        return this._holder;
    }

    public IWebBrowserStyleInfo getStyleInfo() {
        return new WebBrowserStyleInfoImpl(this);
    }

    public boolean clearInterval(int id) {
        return this.browserComposite.clearInterval(id);
    }

    public boolean clearTimeout(int id) {
        return this.browserComposite.clearTimeout(id);
    }

    public int setInterval(String script, int interval) {
        return this.browserComposite.setInterval(script, interval);
    }

    public int setTimeout(String script, int interval) {
        return this.browserComposite.setTimeout(script, interval);
    }
}

