/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.audio.io.impl;

import java.util.ArrayList;
import org.eclipse.actf.ai.audio.io.AudioPipeListener;
import org.eclipse.actf.ai.audio.io.IAudioPipe;
import org.eclipse.actf.ai.audio.io.IAudioReader;
import org.eclipse.actf.ai.audio.io.IAudioWriter;
import org.eclipse.actf.ai.audio.io.impl.AudioPipe;

public class LoopedAudioPipe
implements IAudioPipe,
AudioPipeListener {
    IAudioPipe target;
    boolean isActive;
    boolean joining = false;
    private ArrayList<AudioPipeListener> listeners = new ArrayList();

    public LoopedAudioPipe(IAudioReader reader, IAudioWriter writer) {
        this.target = new AudioPipe(reader, writer);
        this.target.addAudioPipeListener(this);
    }

    public void addAudioPipeListener(AudioPipeListener listener) {
        this.listeners.add(listener);
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void join() {
        this.joining = true;
        this.target.join();
        this.fireFinished();
    }

    public void setBufferSize(int miliSeconds) {
        this.target.setBufferSize(miliSeconds);
    }

    public void setInterval(int interval) {
        this.target.setInterval(interval);
    }

    public void setPriority(int priority) {
        this.target.setPriority(priority);
    }

    public void prepare() {
        this.target.prepare();
    }

    public void start() {
        this.start(0);
    }

    public void start(int delay) {
        this.target.start(delay);
        this.isActive = true;
        this.joining = false;
    }

    public void stop() {
        this.target.stop();
        this.isActive = false;
        this.fireStopped();
    }

    private void fireFinished() {
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).finished(this);
            ++i;
        }
    }

    private void fireStopped() {
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).stopped(this);
            ++i;
        }
    }

    public void finished(IAudioPipe pipe) {
        if (!this.joining) {
            pipe.start();
        }
    }

    public void stopped(IAudioPipe pipe) {
    }
}

