/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.query.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.actf.model.dom.dombycom.IDocumentEx;
import org.eclipse.actf.util.xpath.XPathService;
import org.eclipse.actf.util.xpath.XPathServiceFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLQueryImpl {
    private static final String XML_QUERY_NS = "http://www.ibm.com/xmlns/prod/aiBrowser/fennec/xml-query";
    private static final XPathService xpathService = XPathServiceFactory.newService();
    private final String[] ids;
    private Object compiledXPath;

    private XMLQueryImpl(String[] ids, Object compiledXPath) {
        this.ids = ids;
        this.compiledXPath = compiledXPath;
    }

    public boolean hasTarget() {
        return this.ids != null || this.compiledXPath != null;
    }

    public List<Node> query(Node base) {
        int len;
        NodeList nl;
        ArrayList<Node> result = null;
        if (this.ids != null) {
            if (result == null) {
                result = new ArrayList<Node>();
            }
            Document doc = base.getOwnerDocument();
            int i = 0;
            while (i < this.ids.length) {
                if (doc instanceof IDocumentEx) {
                    List r = ((IDocumentEx)doc).getElementsByIdInAllFrames(this.ids[i]);
                    result.addAll(r);
                } else {
                    Element n = doc.getElementById(this.ids[i]);
                    if (n != null) {
                        result.add(n);
                    }
                }
                ++i;
            }
        }
        if (this.compiledXPath != null && (nl = xpathService.evalForNodeList(this.compiledXPath, base)) != null && (len = nl.getLength()) > 0) {
            if (result == null) {
                result = new ArrayList(len);
            }
            int i = 0;
            while (i < len) {
                result.add(nl.item(i));
                ++i;
            }
        }
        return result;
    }

    static XMLQueryImpl parse(Element e, XMLQueryImpl parentQuery) {
        String[] ids = null;
        String idrefs = e.getAttributeNS(XML_QUERY_NS, "idrefs");
        if (idrefs.length() > 0) {
            ids = idrefs.split("[ \r\n\t]");
        }
        String path = e.getAttributeNS(XML_QUERY_NS, "path");
        Object compiled = null;
        if (path.length() > 0) {
            compiled = xpathService.compile(path);
        }
        return new XMLQueryImpl(ids, compiled);
    }

    static XMLQueryImpl parseXPath(String xpath) {
        Object compiled = xpathService.compile(xpath);
        return new XMLQueryImpl(null, compiled);
    }

    static Attr serializeQuery(Node domNode, Node usrNode) {
        Document doc = usrNode.getOwnerDocument();
        String id = XMLQueryImpl.getID(domNode);
        if (id != null && id.length() > 0) {
            Attr attr = doc.createAttributeNS(XML_QUERY_NS, "loc:idrefs");
            attr.setNodeValue(id);
            return attr;
        }
        String path = XMLQueryImpl.getXPath(domNode);
        if (path != null && path.length() > 0) {
            Attr attr = doc.createAttributeNS(XML_QUERY_NS, "loc:path");
            attr.setNodeValue(path);
            return attr;
        }
        return null;
    }

    private static String getID(Node node) {
        if (!(node instanceof Element)) {
            return null;
        }
        Element e = (Element)node;
        return e.getAttribute("id");
    }

    private static String checkID(Node n) {
        if (!(n instanceof Element)) {
            return null;
        }
        Element e = (Element)n;
        String id = e.getAttribute("id");
        if (id == null) {
            return null;
        }
        Document doc = e.getOwnerDocument();
        Element e2 = doc.getElementById(id);
        if (!e.isSameNode(e2)) {
            return null;
        }
        if (id.indexOf(58) >= 0) {
            return null;
        }
        return id;
    }

    private static String getXPath(Node node) {
        StringBuffer ret = new StringBuffer();
        Node n = node;
        while (n != null) {
            if (n instanceof Document) break;
            String id = XMLQueryImpl.checkID(n);
            if (id != null) {
                ret.insert(0, "\")");
                ret.insert(0, id);
                ret.insert(0, "id(\"");
                break;
            }
            String name = n.getNodeName();
            int k = 1;
            if (!name.startsWith("#")) {
                Node p = n.getParentNode();
                if (p != null) {
                    Node c = p.getFirstChild();
                    while (c != null) {
                        if (c == n) break;
                        if (c.getNodeName().equals(name)) {
                            ++k;
                        }
                        c = c.getNextSibling();
                    }
                }
                ret.insert(0, ']');
                ret.insert(0, k);
                ret.insert(0, '[');
                ret.insert(0, XMLQueryImpl.getNodeNameForXPath(n.getNodeName()));
                ret.insert(0, '/');
            }
            n = n.getParentNode();
        }
        return ret.toString();
    }

    private static String getNodeNameForXPath(String s) {
        if (s.startsWith("#")) {
            return String.valueOf(s.substring(1)) + "()";
        }
        return s;
    }
}

