/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.win32;

import org.eclipse.actf.util.win32.COPYDATASTRUCT;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class WMCMonitor {
    private static String productName = "Unknown";
    private int oldShellProc = 0;

    static {
        IProduct product = Platform.getProduct();
        if (product != null) {
            productName = product.getName();
        }
    }

    public WMCMonitor() {
        this("WMCWindow:" + productName);
    }

    public WMCMonitor(String title) {
        Shell activeShell;
        Display display = Display.getCurrent();
        if (display != null && (activeShell = display.getActiveShell()) != null) {
            Callback callback = new Callback((Object)this, "shellWindowProc", 4);
            int address = callback.getAddress();
            if (address != 0) {
                final Shell shell = new Shell();
                shell.setVisible(false);
                shell.setBounds(0, 0, 0, 0);
                shell.setText(title);
                this.oldShellProc = OS.GetWindowLong((int)shell.handle, (int)-4);
                OS.SetWindowLong((int)shell.handle, (int)-4, (int)address);
                activeShell.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        shell.dispose();
                    }
                });
            } else {
                callback.dispose();
            }
        }
    }

    int shellWindowProc(int hwnd, int msg, int wParam, int lParam) {
        try {
            if (74 == msg) {
                return this.onCopyData(hwnd, wParam, new COPYDATASTRUCT(lParam));
            }
            return OS.CallWindowProc((int)this.oldShellProc, (int)hwnd, (int)msg, (int)wParam, (int)lParam);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    protected abstract int onCopyData(int var1, int var2, COPYDATASTRUCT var3);
}

