/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.gui.ui.views;

import java.util.Vector;
import org.eclipse.actf.accservice.swtbridge.AccessibleObject;
import org.eclipse.actf.accservice.swtbridge.MSAA;
import org.eclipse.actf.util.win32.HighlightComposite;
import org.eclipse.actf.visualization.gui.IGuiViewIDs;
import org.eclipse.actf.visualization.gui.internal.util.GuiImages;
import org.eclipse.actf.visualization.gui.internal.util.Messages;
import org.eclipse.actf.visualization.gui.ui.views.IMSAAListView;
import org.eclipse.actf.visualization.gui.ui.views.IMSAAOutlineView;
import org.eclipse.actf.visualization.gui.ui.views.MSAATreeContentProvider;
import org.eclipse.actf.visualization.gui.ui.views.MSAAViewRegistory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class MSAAListView
extends ViewPart
implements IMSAAListView {
    private static final String[] HEADINGS = new String[]{"#", Messages.msaa_name, Messages.msaa_role, Messages.msaa_state, "X", "Y", "W", "H"};
    private static final int[] WEIGHTS = new int[]{1, 5, 5, 5, 1, 1, 1, 1};
    private static final int[] ALIGNMENTS = new int[]{131072, 16384, 16384, 16384, 131072, 131072, 131072, 131072};
    private TableViewer viewer;
    private MSAASiblingViewerSorter sorter = new MSAASiblingViewerSorter();
    private boolean suppressHilight = false;
    private Action refreshAction;
    private AccessibleObject objectOnAppear = null;
    private static final MSAATreeContentProvider provider = MSAATreeContentProvider.getDefault();
    private static final Color GRAY_COLOR = Display.getCurrent().getSystemColor(15);

    public void createPartControl(Composite composite) {
        Table table = new Table(composite, 68356);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        int n = 0;
        while (n < HEADINGS.length) {
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(WEIGHTS[n]));
            TableColumn tableColumn = new TableColumn(table, 0);
            tableColumn.setText(HEADINGS[n]);
            tableColumn.setAlignment(ALIGNMENTS[n]);
            tableColumn.setResizable(true);
            final int n2 = n + 1;
            tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ((MSAAListView)MSAAListView.this).sorter.sortingColumn = n2 == ((MSAAListView)MSAAListView.this).sorter.sortingColumn ? -n2 : n2;
                    MSAAListView.this.viewer.refresh();
                }
            });
            ++n;
        }
        this.viewer = new TableViewer(table);
        MSAASiblingContentAndLabelProvider mSAASiblingContentAndLabelProvider = new MSAASiblingContentAndLabelProvider();
        this.viewer.setContentProvider((IContentProvider)mSAASiblingContentAndLabelProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)mSAASiblingContentAndLabelProvider);
        this.viewer.setSorter((ViewerSorter)this.sorter);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                Object object;
                if (MSAAListView.this.suppressHilight) {
                    return;
                }
                ISelection iSelection = selectionChangedEvent.getSelection();
                if (iSelection instanceof IStructuredSelection && (object = ((IStructuredSelection)iSelection).getFirstElement()) instanceof AccessibleObject) {
                    AccessibleObject accessibleObject = (AccessibleObject)object;
                    IMSAAOutlineView iMSAAOutlineView = (IMSAAOutlineView)MSAAViewRegistory.findView(IGuiViewIDs.ID_OUTLINEVIEW);
                    if (iMSAAOutlineView != null) {
                        iMSAAOutlineView.setSelection(accessibleObject);
                    } else {
                        HighlightComposite.flashRectangle((Rectangle)accessibleObject.getAccLocation());
                    }
                }
            }
        });
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
        if (MSAAViewRegistory.outlineObject != null) {
            this.setSelection(MSAAViewRegistory.outlineObject);
        }
        HighlightComposite.initOverlayWindow();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
        if (this.objectOnAppear != null) {
            this.setSelection(this.objectOnAppear);
        }
    }

    public void setSelection(AccessibleObject accessibleObject) {
        AccessibleObject accessibleObject2;
        if (!this.viewer.getControl().isVisible()) {
            this.objectOnAppear = accessibleObject;
            return;
        }
        this.objectOnAppear = null;
        this.suppressHilight = true;
        AccessibleObject accessibleObject3 = accessibleObject.getCachedParent();
        if (accessibleObject3 != null && (accessibleObject2 = (AccessibleObject)this.viewer.getInput()) != accessibleObject3) {
            this.viewer.setInput((Object)accessibleObject3);
        }
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)accessibleObject), true);
        this.suppressHilight = false;
    }

    private void hookContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                MSAAListView.this.fillContextMenu(iMenuManager);
            }
        });
        Menu menu = menuManager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(iActionBars.getMenuManager());
        this.fillLocalToolBar(iActionBars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager iMenuManager) {
    }

    private void fillContextMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.refreshAction);
        iMenuManager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add((IAction)this.refreshAction);
    }

    private void makeActions() {
        this.refreshAction = new Action(Messages.msaa_refresh){

            public void run() {
                MSAAListView.this.viewer.refresh();
            }
        };
        this.refreshAction.setToolTipText(Messages.msaa_refresh);
        this.refreshAction.setImageDescriptor(GuiImages.IMAGE_REFRESH);
    }

    private class MSAASiblingContentAndLabelProvider
    extends LabelProvider
    implements IStructuredContentProvider,
    IPropertyChangeListener,
    ITableLabelProvider,
    ITableColorProvider {
        private Object[] lastElements;

        public Object[] getElements(Object object) {
            this.lastElements = null;
            if (object instanceof AccessibleObject) {
                Object[] objectArray = provider.getElements(object);
                Vector<Object> vector = new Vector<Object>();
                int n = 0;
                while (n < objectArray.length) {
                    try {
                        int n2 = ((AccessibleObject)objectArray[n]).getAccState() & 0x18000;
                        if (32768 != n2) {
                            vector.add(objectArray[n]);
                        }
                    }
                    catch (Exception exception) {}
                    ++n;
                }
                this.lastElements = vector.toArray();
            }
            return this.lastElements;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            if (object instanceof AccessibleObject) {
                switch (n) {
                    case 0: {
                        if (this.lastElements != null) {
                            int n2 = 0;
                            while (n2 < this.lastElements.length) {
                                if (object.equals(this.lastElements[n2])) {
                                    return Integer.toString(n2 + 1);
                                }
                                ++n2;
                            }
                        }
                        return "";
                    }
                    case 1: {
                        return ((AccessibleObject)object).getAccName();
                    }
                    case 2: {
                        return ((AccessibleObject)object).getRoleText();
                    }
                    case 3: {
                        return MSAA.getStateText(((AccessibleObject)object).getAccState());
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        Rectangle rectangle = ((AccessibleObject)object).getAccLocation();
                        if (rectangle == null) {
                            return "";
                        }
                        switch (n - 4) {
                            case 0: {
                                return Integer.toString(rectangle.x);
                            }
                            case 1: {
                                return Integer.toString(rectangle.y);
                            }
                            case 2: {
                                return Integer.toString(rectangle.width);
                            }
                            case 3: {
                                return Integer.toString(rectangle.height);
                            }
                        }
                    }
                }
                return "?";
            }
            return null;
        }

        public Color getBackground(Object object, int n) {
            return null;
        }

        public Color getForeground(Object object, int n) {
            int n2;
            if (object instanceof AccessibleObject && ((n2 = ((AccessibleObject)object).getAccState()) & 0x8000) != 0) {
                return GRAY_COLOR;
            }
            return null;
        }
    }

    private class MSAASiblingViewerSorter
    extends ViewerSorter {
        public int sortingColumn = 0;

        private MSAASiblingViewerSorter() {
        }

        public int compare(Viewer viewer, Object object, Object object2) {
            IBaseLabelProvider iBaseLabelProvider;
            if (this.sortingColumn != 0 && viewer instanceof TableViewer && (iBaseLabelProvider = ((TableViewer)viewer).getLabelProvider()) instanceof ITableLabelProvider) {
                int n = Math.abs(this.sortingColumn) - 1;
                String string = ((ITableLabelProvider)iBaseLabelProvider).getColumnText(object, n);
                String string2 = ((ITableLabelProvider)iBaseLabelProvider).getColumnText(object2, n);
                int n2 = 0;
                switch (n) {
                    default: {
                        try {
                            n2 = Integer.parseInt(string) - Integer.parseInt(string2);
                            break;
                        }
                        catch (Exception exception) {}
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        n2 = this.collator.compare(string, string2);
                    }
                }
                return this.sortingColumn > 0 ? n2 : -n2;
            }
            return 0;
        }
    }
}

