/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.image;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.io.PrintStream;
import java.io.PrintWriter;
import org.eclipse.actf.visualization.engines.lowvision.image.ImageException;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.IInt2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Int2D;

public class ImageUtil {
    public static Int2D bufferedImageToInt2D(BufferedImage bufferedImage) throws ImageException {
        if (bufferedImage == null) {
            throw new ImageException("Input BufferedImage is null.");
        }
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        Int2D int2D = new Int2D(n, n2);
        WritableRaster writableRaster = bufferedImage.copyData(null);
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int[] nArray = dataBufferInt.getData();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < n) {
                int2D.getData()[n4][n5] = nArray[n3];
                ++n3;
                ++n5;
            }
            ++n4;
        }
        return int2D;
    }

    public static BufferedImage int2DToBufferedImage(IInt2D iInt2D) {
        return ImageUtil.int2DArrayToBufferedImage(iInt2D.getData(), iInt2D.getWidth(), iInt2D.getHeight());
    }

    public static int[][] bufferedImageToInt2DArray(BufferedImage bufferedImage, int n, int n2) {
        int[][] nArray = new int[n2][n];
        WritableRaster writableRaster = bufferedImage.copyData(null);
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int[] nArray2 = dataBufferInt.getData();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < n) {
                nArray[n4][n5] = nArray2[n3];
                ++n3;
                ++n5;
            }
            ++n4;
        }
        return nArray;
    }

    public static BufferedImage int2DArrayToBufferedImage(int[][] nArray, int n, int n2) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        WritableRaster writableRaster = bufferedImage.copyData(null);
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int[] nArray2 = dataBufferInt.getData();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < n) {
                nArray2[n3] = nArray[n4][n5];
                ++n3;
                ++n5;
            }
            ++n4;
        }
        bufferedImage.setData(writableRaster);
        return bufferedImage;
    }

    public static int[][] copyInt2DArray(int[][] nArray, int n, int n2) {
        int[][] nArray2 = new int[n2][n];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                nArray2[n3][n4] = nArray[n3][n4];
                ++n4;
            }
            ++n3;
        }
        return nArray2;
    }

    public static void dumpInt2DArray(PrintStream printStream, int[][] nArray, int n, int n2) {
        PrintWriter printWriter = new PrintWriter(printStream, false);
        ImageUtil.dumpInt2DArray(printWriter, nArray, n, n2);
    }

    public static void dumpInt2DArray(PrintWriter printWriter, int[][] nArray, int n, int n2) {
        printWriter.println("-------");
        printWriter.println("dumping int[][]");
        printWriter.println("width = " + n + ", height = " + n2);
        printWriter.println("data:");
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                printWriter.print("" + nArray[n3][n4]);
                ++n4;
            }
            printWriter.println("");
            ++n3;
        }
        printWriter.println("-------");
        printWriter.flush();
    }
}

