/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.chain.jdk;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.tea.core.services.TaskingLog;
import org.eclipse.tea.library.build.chain.TeaBuildElement;
import org.eclipse.tea.library.build.model.PluginData;
import org.eclipse.tea.library.build.util.FileUtils;

public class TeaJdkLibBuildElement
extends TeaBuildElement {
    private IProject project;
    private String libName;
    private String target;

    public TeaJdkLibBuildElement(IProject project, String libName, String target) {
        this.project = project;
        this.libName = libName;
        this.target = target;
    }

    public IProject getProject() {
        return this.project;
    }

    void execute(TaskingLog log) throws Exception {
        File f;
        String[] envs;
        PluginData data = new PluginData(this.project);
        File targetFile = new File(data.getBundleDir(), this.target);
        if (targetFile.exists()) {
            log.info("using existing " + targetFile);
        }
        if ((envs = data.getRequiredExecutionEnvironment()).length < 1) {
            log.warn("no execution environments for " + this.project);
            return;
        }
        IExecutionEnvironmentsManager eeManager = JavaRuntime.getExecutionEnvironmentsManager();
        IExecutionEnvironment bestEE = null;
        String[] stringArray = envs;
        int n = envs.length;
        int n2 = 0;
        while (n2 < n) {
            String env = stringArray[n2];
            bestEE = eeManager.getEnvironment(env);
            if (bestEE != null) break;
            ++n2;
        }
        IVMInstall vm = bestEE.getDefaultVM();
        if (vm == null) {
            log.warn("no default VM for " + bestEE.getId());
            IVMInstall[] compatibleVMs = bestEE.getCompatibleVMs();
            if (compatibleVMs == null || compatibleVMs.length < 1) {
                log.warn("no compatile VM for " + bestEE.getId());
                return;
            }
            vm = compatibleVMs[0];
        }
        if (!(f = new File(vm.getInstallLocation(), this.libName)).exists()) {
            throw new IllegalStateException("VM installation in " + vm.getInstallLocation() + " does not have " + this.libName);
        }
        FileUtils.copyFile(f, targetFile);
        this.project.refreshLocal(2, null);
    }

    @Override
    public String getName() {
        return "JDK Library " + this.libName + " for " + this.project.getName();
    }
}

