/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.statushandler;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.runtime.statushandler.StatusHandlerManager;
import org.eclipse.tcf.te.runtime.statushandler.activator.CoreBundleActivator;
import org.eclipse.tcf.te.runtime.statushandler.interfaces.IStatusHandler;
import org.osgi.framework.Bundle;

public final class StatusHandlerUtil {
    public static void handleStatus(IStatus status, Object context, String template, String title, String contextHelpId, Object caller, ICallback callback) {
        StatusHandlerUtil.handleStatus(status, context, template, title, contextHelpId, caller, callback, false);
    }

    public static void handleStatus(IStatus status, Object context, String template, String title, String contextHelpId, Object caller, ICallback callback, boolean showDetails) {
        Assert.isNotNull((Object)status);
        Assert.isNotNull((Object)context);
        IStatusHandler[] handlers = StatusHandlerManager.getInstance().getHandler(context);
        if (handlers.length > 0) {
            PropertiesContainer data = new PropertiesContainer();
            if (title != null) {
                data.setProperty("title", (Object)title);
            }
            if (contextHelpId != null) {
                data.setProperty("contextHelpId", (Object)contextHelpId);
            }
            if (caller != null) {
                data.setProperty("caller", caller);
            }
            String fullMsg = StatusHandlerUtil.getStatusFullMessage(status);
            StatusHandlerUtil.updateMessage(status, template, fullMsg);
            if (showDetails) {
                data.setProperty("detailsText", (Object)fullMsg);
            }
            handlers[0].handleStatus(status, (IPropertiesContainer)data, callback);
        } else {
            Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log(status);
            callback.done(caller, status);
        }
    }

    private static String getStatusFullMessage(IStatus status) {
        StringBuilder message = new StringBuilder();
        String msg = status.getMessage();
        if (msg != null && msg.contains("Error text:")) {
            StringTokenizer tokenizer = new StringTokenizer(msg, ",");
            while (tokenizer.hasMoreElements()) {
                String token = tokenizer.nextToken();
                if (!token.trim().startsWith("Error text:")) continue;
                token = token.replaceAll("Error text:", " ");
                message.append(token.trim());
                break;
            }
        } else if (msg != null) {
            message.append(msg.trim());
        }
        if (status.getException() != null && status.getException().getLocalizedMessage() != null && !status.getException().getLocalizedMessage().contains(message.toString())) {
            message.append("\n\n");
            message.append(status.getException().getLocalizedMessage());
        }
        String fullMsg = null;
        if (message.length() > 0) {
            fullMsg = message.toString().trim();
        }
        return fullMsg;
    }

    private static void updateMessage(IStatus status, String template, String fullMsg) {
        Assert.isNotNull((Object)status);
        if (template != null) {
            fullMsg = NLS.bind((String)template, (Object)(fullMsg != null ? fullMsg : ""));
        }
        if (fullMsg != null) {
            fullMsg = fullMsg.replaceAll("\r\n", "\n");
            try {
                final Field f = status.getClass().getDeclaredField("message");
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        f.setAccessible(true);
                        return null;
                    }
                });
                f.set(status, fullMsg);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

