/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.cdt.ui;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.core.model.IMoveToAddress;
import org.eclipse.cdt.debug.core.model.IMoveToLine;
import org.eclipse.cdt.debug.core.model.IResumeAtAddress;
import org.eclipse.cdt.debug.core.model.IResumeAtLine;
import org.eclipse.cdt.debug.core.model.IRunToAddress;
import org.eclipse.cdt.debug.core.model.IRunToLine;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLookupDirector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.tcf.internal.debug.model.TCFContextState;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildren;
import org.eclipse.tcf.internal.debug.ui.model.TCFDebugTask;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeRegister;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.JSON;
import org.eclipse.tcf.services.IBreakpoints;
import org.eclipse.tcf.services.ILineNumbers;
import org.eclipse.tcf.services.IMemory;
import org.eclipse.tcf.services.IRegisters;
import org.eclipse.tcf.services.IRunControl;
import org.eclipse.tcf.util.TCFDataCache;
import org.eclipse.tcf.util.TCFTask;

public class TCFSuspendResumeAdapter
implements ISuspendResume,
IRunToLine,
IRunToAddress,
IMoveToLine,
IMoveToAddress,
IResumeAtLine,
IResumeAtAddress,
IAdaptable {
    private final TCFNodeExecContext fExecCtx;

    public TCFSuspendResumeAdapter(TCFNodeExecContext execCtx) {
        this.fExecCtx = execCtx;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isInstance(this)) {
            return this;
        }
        return null;
    }

    public boolean canResume() {
        return this.isSuspended();
    }

    public boolean canSuspend() {
        return !this.isSuspended();
    }

    public boolean isSuspended() {
        try {
            Boolean result = (Boolean)new TCFTask<Boolean>(){

                public void run() {
                    if (TCFSuspendResumeAdapter.this.fExecCtx.isDisposed()) {
                        this.done(Boolean.FALSE);
                        return;
                    }
                    TCFDataCache state = TCFSuspendResumeAdapter.this.fExecCtx.getState();
                    if (!state.validate((Runnable)((Object)this))) {
                        return;
                    }
                    if (state.getError() == null && state.getData() != null) {
                        this.done(((TCFContextState)state.getData()).is_suspended);
                        return;
                    }
                    this.done(Boolean.FALSE);
                }
            }.get();
            return result != null ? result : false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void resume() throws DebugException {
        new TCFDebugTask<Object>(){

            public void run() {
                if (TCFSuspendResumeAdapter.this.fExecCtx.isDisposed()) {
                    this.done(null);
                    return;
                }
                TCFDataCache cache = TCFSuspendResumeAdapter.this.fExecCtx.getRunContext();
                if (!cache.validate((Runnable)((Object)this))) {
                    return;
                }
                IRunControl.RunControlContext runCtx = (IRunControl.RunControlContext)cache.getData();
                runCtx.resume(0, 1, new IRunControl.DoneCommand(){

                    public void doneCommand(IToken token, Exception error) {
                        if (error != null) {
                            this.error(error);
                        } else {
                            this.done(null);
                        }
                    }
                });
            }
        }.getD();
    }

    public void suspend() throws DebugException {
        new TCFDebugTask<Object>(){

            public void run() {
                if (TCFSuspendResumeAdapter.this.fExecCtx.isDisposed()) {
                    this.done(null);
                    return;
                }
                TCFDataCache cache = TCFSuspendResumeAdapter.this.fExecCtx.getRunContext();
                if (!cache.validate((Runnable)((Object)this))) {
                    return;
                }
                IRunControl.RunControlContext runCtx = (IRunControl.RunControlContext)cache.getData();
                if (runCtx.canSuspend()) {
                    runCtx.suspend(new IRunControl.DoneCommand(){

                        public void doneCommand(IToken token, Exception error) {
                            if (error != null) {
                                this.error(error);
                            } else {
                                this.done(null);
                            }
                        }
                    });
                }
            }
        }.getD();
    }

    public boolean canResumeAtAddress(IAddress address) {
        return true;
    }

    public void resumeAtAddress(IAddress address) throws DebugException {
        this.moveToLocation(new Location(address.getValue()), true);
    }

    public boolean canResumeAtLine(IFile file, int lineNumber) {
        return true;
    }

    public void resumeAtLine(IFile file, int lineNumber) throws DebugException {
        IPath location = file.getLocation();
        if (location == null) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.tcf.cdt.ui", "Cannot resume at line: Not a local file."));
        }
        this.resumeAtLine(location.toOSString(), lineNumber);
    }

    public boolean canResumeAtLine(String fileName, int lineNumber) {
        return true;
    }

    public void resumeAtLine(String fileName, int lineNumber) throws DebugException {
        String debuggerPath = this.mapToDebuggerPath(fileName);
        this.moveToLocation(new Location(debuggerPath, lineNumber), true);
    }

    public boolean canMoveToAddress(IAddress address) {
        return true;
    }

    public void moveToAddress(IAddress address) throws DebugException {
        this.moveToLocation(new Location(address.getValue()), false);
    }

    public boolean canMoveToLine(String fileName, int lineNumber) {
        return true;
    }

    public void moveToLine(String fileName, int lineNumber) throws DebugException {
        String debuggerPath = this.mapToDebuggerPath(fileName);
        this.moveToLocation(new Location(debuggerPath, lineNumber), false);
    }

    public boolean canRunToAddress(IAddress address) {
        return this.canResume();
    }

    public void runToAddress(IAddress address, boolean skipBreakpoints) throws DebugException {
        this.runToLocation(new Location(address.getValue()), skipBreakpoints);
    }

    public boolean canRunToLine(IFile file, int lineNumber) {
        return this.canResume();
    }

    public void runToLine(IFile file, int lineNumber, boolean skipBreakpoints) throws DebugException {
        IPath location = file.getLocation();
        if (location == null) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.tcf.cdt.ui", "Cannot run to line: Not a local file."));
        }
        this.runToLine(location.toOSString(), lineNumber, skipBreakpoints);
    }

    public boolean canRunToLine(String fileName, int lineNumber) {
        return this.canResume();
    }

    public void runToLine(String fileName, int lineNumber, boolean skipBreakpoints) throws DebugException {
        String debuggerPath = this.mapToDebuggerPath(fileName);
        this.runToLocation(new Location(debuggerPath, lineNumber), skipBreakpoints);
    }

    private String mapToDebuggerPath(String fileName) {
        IPath compilationPath;
        ISourceLocator locator = this.fExecCtx.getModel().getLaunch().getSourceLocator();
        if (locator instanceof CSourceLookupDirector && (compilationPath = ((CSourceLookupDirector)locator).getCompilationPath(fileName)) != null) {
            return compilationPath.toString();
        }
        return new Path(fileName).lastSegment();
    }

    private void runToLocation(final Location location, boolean skipBreakpoints) throws DebugException {
        new TCFDebugTask<Object>(){

            public void run() {
                if (TCFSuspendResumeAdapter.this.fExecCtx.isDisposed()) {
                    this.done(null);
                    return;
                }
                final IChannel channel = TCFSuspendResumeAdapter.this.fExecCtx.getChannel();
                final IBreakpoints breakpoints = (IBreakpoints)channel.getRemoteService(IBreakpoints.class);
                if (breakpoints == null) {
                    this.error("Cannot set breakpoint.");
                    return;
                }
                final String contextId = TCFSuspendResumeAdapter.this.fExecCtx.getID();
                HashMap<String, Object> properties = new HashMap<String, Object>();
                if (location.fFile != null) {
                    properties.put("File", location.fFile);
                    properties.put("Line", location.fLine);
                } else {
                    properties.put("Location", location.fAddress.toString());
                }
                properties.put("Enabled", Boolean.TRUE);
                properties.put("Service", "RunControl");
                final String breakpointId = "Step." + contextId;
                properties.put("ID", breakpointId);
                breakpoints.add(properties, new IBreakpoints.DoneCommand(){

                    public void doneCommand(IToken token, Exception error) {
                        if (error != null) {
                            this.error(error);
                            return;
                        }
                        final Runnable removeBreakpoint = new Runnable(){

                            @Override
                            public void run() {
                                breakpoints.remove(new String[]{breakpointId}, new IBreakpoints.DoneCommand(){

                                    public void doneCommand(IToken token, Exception error) {
                                    }
                                });
                            }
                        };
                        Runnable resume = new Runnable(){

                            @Override
                            public void run() {
                                final IRunControl runControl = (IRunControl)channel.getRemoteService(IRunControl.class);
                                if (runControl == null) {
                                    this.error("Cannot resume.");
                                    removeBreakpoint.run();
                                    return;
                                }
                                TCFDataCache cache = TCFSuspendResumeAdapter.this.fExecCtx.getRunContext();
                                if (!cache.validate((Runnable)this)) {
                                    return;
                                }
                                if (cache.getError() != null) {
                                    this.error(cache.getError());
                                    removeBreakpoint.run();
                                    return;
                                }
                                runControl.addListener(new IRunControl.RunControlListener(){

                                    private void finished() {
                                        runControl.removeListener((IRunControl.RunControlListener)this);
                                        removeBreakpoint.run();
                                    }

                                    public void contextSuspended(String context, String pc, String reason, Map<String, Object> params) {
                                        if (contextId.equals(context)) {
                                            this.finished();
                                        }
                                    }

                                    public void contextResumed(String context) {
                                    }

                                    public void contextRemoved(String[] context_ids) {
                                        String[] stringArray = context_ids;
                                        int n = context_ids.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            String context = stringArray[n2];
                                            if (contextId.equals(context)) {
                                                this.finished();
                                                return;
                                            }
                                            ++n2;
                                        }
                                    }

                                    public void contextException(String context, String msg) {
                                    }

                                    public void contextChanged(IRunControl.RunControlContext[] contexts) {
                                    }

                                    public void contextAdded(IRunControl.RunControlContext[] contexts) {
                                    }

                                    public void containerSuspended(String context, String pc, String reason, Map<String, Object> params, String[] suspended_ids) {
                                        String[] stringArray = suspended_ids;
                                        int n = suspended_ids.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            String context2 = stringArray[n2];
                                            if (contextId.equals(context2)) {
                                                this.finished();
                                                return;
                                            }
                                            ++n2;
                                        }
                                    }

                                    public void containerResumed(String[] context_ids) {
                                    }
                                });
                                IRunControl.RunControlContext runCtx = (IRunControl.RunControlContext)cache.getData();
                                runCtx.resume(0, 1, new IRunControl.DoneCommand(){

                                    public void doneCommand(IToken token, Exception error) {
                                        if (error != null) {
                                            this.error(error);
                                        } else {
                                            this.done(null);
                                        }
                                    }
                                });
                            }
                        };
                        resume.run();
                    }
                });
            }
        }.getD();
    }

    private void moveToLocation(final Location location, final boolean resume) throws DebugException {
        new TCFDebugTask<Object>(){
            private IRegisters.RegistersContext fPCReg;

            public void run() {
                if (TCFSuspendResumeAdapter.this.fExecCtx.isDisposed()) {
                    this.done(null);
                    return;
                }
                LinkedList<TCFChildren> queue = new LinkedList<TCFChildren>();
                queue.add(TCFSuspendResumeAdapter.this.fExecCtx.getRegisters());
                block0: while (this.fPCReg == null && !queue.isEmpty()) {
                    TCFChildren regNodesCache = (TCFChildren)queue.removeFirst();
                    if (!regNodesCache.validate((Runnable)((Object)this))) {
                        return;
                    }
                    Map regNodes = (Map)regNodesCache.getData();
                    if (regNodes == null || regNodes.size() == 0) {
                        if (regNodesCache.getError() != null) {
                            this.error(regNodesCache.getError());
                        } else {
                            this.error("Cannot retrive registers info");
                        }
                        return;
                    }
                    for (TCFNode node : regNodes.values()) {
                        TCFNodeRegister regNode = (TCFNodeRegister)node;
                        TCFDataCache regCtxCache = regNode.getContext();
                        if (!regCtxCache.validate((Runnable)((Object)this))) {
                            return;
                        }
                        IRegisters.RegistersContext context = (IRegisters.RegistersContext)regCtxCache.getData();
                        if (context != null && "PC".equals(context.getRole())) {
                            this.fPCReg = context;
                            continue block0;
                        }
                        queue.add(regNode.getChildren());
                    }
                }
                if (this.fPCReg == null) {
                    this.error("Cannot determine PC register.");
                    return;
                }
                if (location.fAddress == null) {
                    IChannel channel = TCFSuspendResumeAdapter.this.fExecCtx.getChannel();
                    ILineNumbers lineNumbers = (ILineNumbers)channel.getRemoteService(ILineNumbers.class);
                    if (lineNumbers == null) {
                        this.error("No line numbers service.");
                        return;
                    }
                    TCFDataCache memNodeCache = TCFSuspendResumeAdapter.this.fExecCtx.getMemoryNode();
                    if (!memNodeCache.validate((Runnable)((Object)this))) {
                        return;
                    }
                    TCFNodeExecContext memNode = (TCFNodeExecContext)memNodeCache.getData();
                    if (memNode == null) {
                        if (memNodeCache.getError() != null) {
                            this.error(memNodeCache.getError());
                        } else {
                            this.error("Cannot determine memory context.");
                        }
                        return;
                    }
                    TCFDataCache memCtxCache = memNode.getMemoryContext();
                    if (!memCtxCache.validate((Runnable)((Object)this))) {
                        return;
                    }
                    IMemory.MemoryContext memCtx = (IMemory.MemoryContext)memCtxCache.getData();
                    if (memCtx == null) {
                        if (memNodeCache.getError() != null) {
                            this.error(memNodeCache.getError());
                        } else {
                            this.error("Cannot determine memory context.");
                        }
                        return;
                    }
                    lineNumbers.mapToMemory(memCtx.getID(), location.fFile, location.fLine, 0, new ILineNumbers.DoneMapToMemory(){

                        public void doneMapToMemory(IToken token, Exception error, ILineNumbers.CodeArea[] areas) {
                            if (error != null) {
                                this.error(error);
                                return;
                            }
                            if (areas == null || areas.length == 0) {
                                this.error("Cannot map source location to address.");
                                return;
                            }
                            this.doneGetLocationAddress(areas[0].start_address);
                        }
                    });
                } else {
                    this.doneGetLocationAddress(location.fAddress);
                }
            }

            private void doneGetLocationAddress(Number address) {
                if (address == null) {
                    this.error("Cannot map source location to address.");
                    return;
                }
                byte[] value = this.addressToByteArray(address, this.fPCReg.getSize(), this.fPCReg.isBigEndian());
                this.fPCReg.set(value, new IRegisters.DoneSet(){

                    public void doneSet(IToken token, Exception error) {
                        if (error != null) {
                            this.error(error);
                            return;
                        }
                        TCFSuspendResumeAdapter.this.fExecCtx.getModel().setDebugViewSelection((TCFNode)TCFSuspendResumeAdapter.this.fExecCtx, "Move");
                        if (resume) {
                            IChannel channel;
                            Runnable resume2;
                            TCFDataCache cache = TCFSuspendResumeAdapter.this.fExecCtx.getRunContext();
                            if (cache.validate(resume2 = new Runnable(channel = TCFSuspendResumeAdapter.this.fExecCtx.getChannel(), cache){
                                private final /* synthetic */ IChannel val$channel;
                                private final /* synthetic */ TCFDataCache val$cache;
                                {
                                    this.val$channel = iChannel;
                                    this.val$cache = tCFDataCache;
                                }

                                @Override
                                public void run() {
                                    IRunControl runControl = (IRunControl)this.val$channel.getRemoteService(IRunControl.class);
                                    if (runControl == null) {
                                        this.error("Cannot resume.");
                                        return;
                                    }
                                    if (!this.val$cache.validate((Runnable)this)) {
                                        return;
                                    }
                                    if (this.val$cache.getError() != null) {
                                        this.error(this.val$cache.getError());
                                        return;
                                    }
                                    IRunControl.RunControlContext runCtx = (IRunControl.RunControlContext)this.val$cache.getData();
                                    runCtx.resume(0, 1, new IRunControl.DoneCommand(){

                                        public void doneCommand(IToken token, Exception error) {
                                            if (error != null) {
                                                this.error(error);
                                            } else {
                                                this.done(null);
                                            }
                                        }
                                    });
                                }
                            })) {
                                resume2.run();
                            }
                        } else {
                            this.done(null);
                        }
                    }
                });
            }

            private byte[] addressToByteArray(Number address, int size, boolean bigEndian) {
                byte[] bytes = new byte[size];
                byte[] addrBytes = JSON.toBigInteger((Number)address).toByteArray();
                int i = 0;
                while (i < bytes.length) {
                    byte b = 0;
                    if (i < addrBytes.length) {
                        b = addrBytes[addrBytes.length - i - 1];
                    }
                    bytes[bigEndian ? size - i - 1 : i] = b;
                    ++i;
                }
                return bytes;
            }
        }.getD();
    }

    private static class Location {
        String fFile;
        int fLine;
        Number fAddress;

        Location(String file, int line) {
            this.fFile = file;
            this.fLine = line;
        }

        Location(Number address) {
            this.fAddress = address;
        }
    }
}

