/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.views.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.tcf.te.runtime.services.ServiceUtils;
import org.eclipse.tcf.te.ui.interfaces.handler.IEditorHandlerDelegate;
import org.eclipse.tcf.te.ui.views.activator.UIPlugin;
import org.eclipse.tcf.te.ui.views.editor.EditorInput;
import org.eclipse.tcf.te.ui.views.nls.Messages;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;

public class OpenEditorHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object ctrlPressed;
        boolean expand;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        if (window == null) {
            window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
        boolean bl = expand = (ctrlPressed = HandlerUtil.getVariable((ExecutionEvent)event, (String)"ctrlPressed")) instanceof Boolean ? (Boolean)ctrlPressed : false;
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            TreePath[] path;
            CommonViewer viewer = ((CommonNavigator)part).getCommonViewer();
            Object element = ((IStructuredSelection)selection).getFirstElement();
            if (selection instanceof TreeSelection && (path = ((TreeSelection)selection).getPaths()) != null && path.length > 0) {
                element = path[0].getLastSegment();
            }
            if (viewer.isExpandable(element) && expand) {
                viewer.setExpandedState(element, !viewer.getExpandedState(element));
            } else {
                OpenEditorHandler.openEditorOnSelection(window, selection);
            }
        }
        return null;
    }

    public static void openEditorOnSelection(IWorkbenchWindow window, ISelection selection) {
        Object element;
        Assert.isNotNull((Object)window);
        Assert.isNotNull((Object)selection);
        if (selection instanceof IStructuredSelection && !selection.isEmpty() && (element = ((IStructuredSelection)selection).getFirstElement()) != null) {
            IWorkbenchPage page = window.getActivePage();
            IEditorHandlerDelegate delegate = (IEditorHandlerDelegate)ServiceUtils.getUIServiceDelegate((Object)element, (Object)element, IEditorHandlerDelegate.class);
            EditorInput input = delegate != null ? delegate.getEditorInput(element) : new EditorInput(element);
            try {
                IEditorPart editor = page.openEditor((IEditorInput)input, "org.eclipse.tcf.te.ui.views.Editor");
                if (delegate != null) {
                    delegate.postOpenEditor(editor, element);
                }
            }
            catch (PartInitException e) {
                Status status = new Status(4, UIPlugin.getUniqueIdentifier(), Messages.OpenCommandHandler_error_openEditor, (Throwable)e);
                UIPlugin.getDefault().getLog().log((IStatus)status);
            }
        }
    }
}

