/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator.model;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelRefreshService;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.IPeerModelRefreshService;
import org.eclipse.tcf.te.tcf.locator.nodes.LocatorModel;
import org.eclipse.tcf.te.tcf.locator.nodes.PeerModel;

public final class ModelManager {
    static volatile IPeerModel peerModel = null;
    static volatile ILocatorModel locatorModel = null;

    public static IPeerModel getPeerModel() {
        return ModelManager.getPeerModel(false);
    }

    public static IPeerModel getPeerModel(boolean shutdown) {
        if (peerModel == null && !shutdown) {
            Protocol.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    ModelManager.initialize();
                }
            });
        }
        return peerModel;
    }

    public static ILocatorModel getLocatorModel() {
        return ModelManager.getLocatorModel(false);
    }

    public static ILocatorModel getLocatorModel(boolean shutdown) {
        if (locatorModel == null && !shutdown) {
            Protocol.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    ModelManager.initialize();
                }
            });
        }
        return locatorModel;
    }

    protected static void initialize() {
        PlatformObject model;
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        if (peerModel == null) {
            model = new PeerModel();
            peerModel = model;
            model.getService(IPeerModelRefreshService.class).refresh(null);
        }
        if (locatorModel == null) {
            model = new LocatorModel();
            locatorModel = model;
            model.getService(ILocatorModelRefreshService.class).refresh(null);
            ((LocatorModel)model).checkLocatorListener();
        }
    }

    public static void dispose() {
        if (peerModel != null) {
            Protocol.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    peerModel.dispose();
                }
            });
            peerModel = null;
        }
        if (locatorModel != null) {
            Protocol.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    locatorModel.dispose();
                }
            });
            locatorModel = null;
        }
    }
}

