/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.model;

import java.math.BigInteger;
import java.util.Map;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.tcf.core.ErrorReport;
import org.eclipse.tcf.internal.debug.model.TCFSymFileRef;
import org.eclipse.tcf.internal.debug.ui.ColorCache;
import org.eclipse.tcf.internal.debug.ui.ImageCache;
import org.eclipse.tcf.internal.debug.ui.model.IDetailsProvider;
import org.eclipse.tcf.internal.debug.ui.model.StyledStringBuffer;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.internal.debug.ui.model.TCFModelFonts;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.protocol.JSON;
import org.eclipse.tcf.services.IMemoryMap;
import org.eclipse.tcf.util.TCFDataCache;

public class TCFNodeModule
extends TCFNode
implements IDetailsProvider {
    private final TCFNode.TCFData<TCFNodeExecContext.MemoryRegion> region;
    private int sort_pos;

    protected TCFNodeModule(final TCFNodeExecContext parent, String id, final int index) {
        super(parent, id);
        this.region = new TCFNode.TCFData<TCFNodeExecContext.MemoryRegion>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                TCFDataCache<TCFNodeExecContext.MemoryRegion[]> map_cache = parent.getMemoryMap();
                if (!map_cache.validate((Runnable)((Object)this))) {
                    return false;
                }
                Throwable error = map_cache.getError();
                TCFNodeExecContext.MemoryRegion[] map_data = (TCFNodeExecContext.MemoryRegion[])map_cache.getData();
                TCFNodeExecContext.MemoryRegion region = null;
                if (map_data != null && index < map_data.length) {
                    region = map_data[index];
                }
                this.set(null, error, region);
                return true;
            }
        };
    }

    public TCFDataCache<TCFNodeExecContext.MemoryRegion> getRegion() {
        return this.region;
    }

    void setSortPosition(int sort_pos) {
        this.sort_pos = sort_pos;
    }

    void onMemoryMapChanged() {
        this.region.reset();
    }

    @Override
    protected boolean getData(ILabelUpdate update, Runnable done) {
        IMemoryMap.MemoryRegion r;
        if (!this.region.validate(done)) {
            return false;
        }
        TCFNodeExecContext.MemoryRegion mr = (TCFNodeExecContext.MemoryRegion)this.region.getData();
        IMemoryMap.MemoryRegion memoryRegion = r = mr != null ? mr.region : null;
        if (r == null) {
            update.setLabel("...", 0);
        } else {
            String[] col_ids = update.getColumnIds();
            if (col_ids == null) {
                update.setLabel(r.getFileName(), 0);
            } else {
                int i = 0;
                while (i < col_ids.length) {
                    String col_id = col_ids[i];
                    if ("Name".equals(col_id)) {
                        update.setLabel(r.getFileName(), i);
                    } else if ("Address".equals(col_id)) {
                        update.setLabel(this.toHexString(r.getAddress()), i);
                    } else if ("Size".equals(col_id)) {
                        update.setLabel(this.toHexString(r.getSize()), i);
                    } else if ("Flags".equals(col_id)) {
                        update.setLabel(this.getFlagsLabel(r.getFlags()), i);
                    } else if ("Offset".equals(col_id)) {
                        update.setLabel(this.toHexString(r.getOffset()), i);
                    } else if ("Section".equals(col_id)) {
                        String sectionName = r.getSectionName();
                        update.setLabel(sectionName != null ? sectionName : "", i);
                    }
                    ++i;
                }
            }
        }
        update.setImageDescriptor(ImageCache.getImageDescriptor("icons/memory-map"), 0);
        return true;
    }

    @Override
    protected void getFontData(ILabelUpdate update, String view_id) {
        FontData fn = TCFModelFonts.getNormalFontData(view_id);
        String[] cols = update.getColumnIds();
        if (cols == null || cols.length == 0) {
            update.setFontData(fn, 0);
        } else {
            String[] ids = update.getColumnIds();
            int i = 0;
            while (i < cols.length) {
                if ("Address".equals(ids[i]) || "Offset".equals(ids[i]) || "Size".equals(ids[i])) {
                    update.setFontData(TCFModelFonts.getMonospacedFontData(view_id), i);
                } else {
                    update.setFontData(fn, i);
                }
                ++i;
            }
        }
    }

    @Override
    public boolean getDetailText(StyledStringBuffer bf, Runnable done) {
        Map kernel_module;
        IMemoryMap.MemoryRegion r;
        if (!this.region.validate(done)) {
            return false;
        }
        TCFNodeExecContext.MemoryRegion mr = (TCFNodeExecContext.MemoryRegion)this.region.getData();
        IMemoryMap.MemoryRegion memoryRegion = r = mr != null ? mr.region : null;
        if (r == null) {
            return true;
        }
        String file_name = r.getFileName();
        if (file_name != null) {
            bf.append("File name: ", 1).append(file_name).append('\n');
            TCFNodeExecContext exe = (TCFNodeExecContext)this.parent;
            TCFDataCache<TCFSymFileRef> sym_cache = exe.getSymFileInfo(JSON.toBigInteger((Number)r.getAddress()));
            if (sym_cache != null) {
                if (!sym_cache.validate(done)) {
                    return false;
                }
                TCFSymFileRef sym_data = (TCFSymFileRef)sym_cache.getData();
                if (sym_data != null) {
                    if (sym_data.props != null) {
                        Map map;
                        String sym_file_name = (String)sym_data.props.get("FileName");
                        if (sym_file_name != null) {
                            bf.append("Symbol file name: ", 1).append(sym_file_name).append('\n');
                        }
                        if ((map = (Map)sym_data.props.get("FileError")) != null) {
                            String msg = TCFModel.getErrorMessage((Throwable)new ErrorReport("", map), false);
                            bf.append("Symbol file error: ", 1).append(msg, 2, null, ColorCache.rgb_error).append('\n');
                        }
                    }
                    if (sym_data.error != null) {
                        bf.append("Symbol file error: ", 1).append(TCFModel.getErrorMessage(sym_data.error, false), 2, null, ColorCache.rgb_error).append('\n');
                    }
                }
            }
            String section = r.getSectionName();
            Number offset = r.getOffset();
            if (section != null) {
                bf.append("File section: ", 1).append(section).append('\n');
            }
            if (offset != null) {
                bf.append("File offset: ", 1).append(this.toHexString(offset), 4).append('\n');
            }
        }
        Number addr = r.getAddress();
        Number size = r.getSize();
        if (addr != null) {
            bf.append("Address: ", 1).append(this.toHexString(addr), 4).append('\n');
        }
        if (size != null) {
            bf.append("Size: ", 1).append(this.toHexString(size), 4).append('\n');
        }
        if ((kernel_module = (Map)r.getProperties().get("KernelModule")) != null) {
            int cnt = 0;
            Number init = (Number)kernel_module.get("Init");
            Number core = (Number)kernel_module.get("Core");
            Number init_size = (Number)kernel_module.get("InitSize");
            Number core_size = (Number)kernel_module.get("CoreSize");
            bf.append("Kernel module: ", 1);
            if (init != null) {
                bf.append("init addr ", 1).append(this.toHexString(init), 4);
                ++cnt;
            }
            if (init_size != null) {
                if (cnt > 0) {
                    bf.append(", ");
                }
                bf.append("init size ", 1).append(this.toHexString(init_size), 4);
                ++cnt;
            }
            if (core != null) {
                if (cnt > 0) {
                    bf.append(", ");
                }
                bf.append("core addr ", 1).append(this.toHexString(core), 4);
                ++cnt;
            }
            if (core_size != null) {
                if (cnt > 0) {
                    bf.append(", ");
                }
                bf.append("core size ", 1).append(this.toHexString(core_size), 4);
                ++cnt;
            }
            bf.append('\n');
        }
        bf.append("Flags: ", 1).append(this.getFlagsLabel(r.getFlags())).append('\n');
        return true;
    }

    private String toHexString(Number address) {
        if (address == null) {
            return "";
        }
        BigInteger addr = JSON.toBigInteger((Number)address);
        String s = addr.toString(16);
        int sz = s.length() <= 8 ? 8 : 16;
        int l = sz - s.length();
        if (l < 0) {
            l = 0;
        }
        if (l > 16) {
            l = 16;
        }
        return String.valueOf("0x0000000000000000".substring(0, 2 + l)) + s;
    }

    private String getFlagsLabel(int flags) {
        StringBuilder flagsLabel = new StringBuilder(3);
        if ((flags & 1) != 0) {
            flagsLabel.append('r');
        } else {
            flagsLabel.append('-');
        }
        if ((flags & 2) != 0) {
            flagsLabel.append('w');
        } else {
            flagsLabel.append('-');
        }
        if ((flags & 4) != 0) {
            flagsLabel.append('x');
        } else {
            flagsLabel.append('-');
        }
        return flagsLabel.toString();
    }

    @Override
    public int compareTo(TCFNode n) {
        TCFNodeModule e = (TCFNodeModule)n;
        if (this.sort_pos < e.sort_pos) {
            return -1;
        }
        if (this.sort_pos > e.sort_pos) {
            return 1;
        }
        return 0;
    }
}

