/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.trees;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.te.ui.trees.ColumnDescriptor;
import org.eclipse.tcf.te.ui.trees.ColumnState;
import org.eclipse.tcf.te.ui.trees.FilterDescriptor;
import org.eclipse.tcf.te.ui.trees.FilterState;
import org.eclipse.ui.IMemento;

class TreeViewerState {
    private List<ColumnState> columns = Collections.synchronizedList(new ArrayList());
    private List<FilterState> filters = Collections.synchronizedList(new ArrayList());

    public void restoreState(IMemento aMemento) {
        IMemento[] mFilters;
        int n;
        IMemento[] mColumns = aMemento.getChildren("column");
        if (mColumns != null && mColumns.length > 0) {
            IMemento[] iMementoArray = mColumns;
            n = mColumns.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento mColumn = iMementoArray[n2];
                String columnId = mColumn.getString("id");
                Assert.isNotNull((Object)columnId);
                Boolean value = mColumn.getBoolean("visible");
                boolean visible = value != null && value != false;
                Integer integer = mColumn.getInteger("width");
                int width = integer;
                integer = mColumn.getInteger("order");
                int order = integer;
                ColumnState column = new ColumnState();
                column.setColumnId(columnId);
                column.setVisible(visible);
                column.setWidth(width);
                column.setOrder(order);
                this.columns.add(column);
                ++n2;
            }
        }
        if ((mFilters = aMemento.getChildren("filter")) != null && mFilters.length > 0) {
            IMemento[] iMementoArray = mFilters;
            int n3 = mFilters.length;
            n = 0;
            while (n < n3) {
                IMemento mFilter = iMementoArray[n];
                String filterId = mFilter.getString("id");
                Assert.isNotNull((Object)filterId);
                Boolean value = mFilter.getBoolean("enabled");
                boolean enabled = value != null && value != false;
                FilterState filter = new FilterState();
                filter.setFilterId(filterId);
                filter.setEnabled(enabled);
                this.filters.add(filter);
                ++n;
            }
        }
    }

    public void saveState(IMemento aMemento) {
        if (this.columns != null) {
            for (ColumnState column : this.columns) {
                String columnId = column.getColumnId();
                IMemento mColumn = aMemento.createChild("column");
                mColumn.putString("id", columnId);
                boolean visible = column.isVisible();
                mColumn.putBoolean("visible", visible);
                int width = column.getWidth();
                mColumn.putInteger("width", width);
                int order = column.getOrder();
                mColumn.putInteger("order", order);
            }
        }
        if (this.filters != null) {
            for (FilterState filter : this.filters) {
                IMemento mFilter = aMemento.createChild("filter");
                mFilter.putString("id", filter.getFilterId());
                boolean enabled = filter.isEnabled();
                mFilter.putBoolean("enabled", enabled);
            }
        }
    }

    public void addColumn(ColumnDescriptor column) {
        ColumnState state = new ColumnState();
        state.setColumnId(column.getId());
        state.setVisible(column.isVisible());
        state.setWidth(column.getWidth());
        state.setOrder(column.getOrder());
        this.columns.add(state);
    }

    public void addFilter(FilterDescriptor filter) {
        FilterState state = new FilterState();
        state.setFilterId(filter.getId());
        state.setEnabled(filter.isEnabled());
        this.filters.add(state);
    }

    public List<ColumnState> getColumnStates() {
        return this.columns;
    }

    public void updateColumnDescriptor(ColumnDescriptor[] columnDescriptors) {
        if (columnDescriptors != null) {
            int i = 0;
            while (i < this.columns.size()) {
                ColumnDescriptor columnDescriptor = columnDescriptors[i];
                ColumnState columnState = this.columns.get(i);
                columnDescriptor.setVisible(columnState.isVisible());
                columnDescriptor.setWidth(columnState.getWidth());
                columnDescriptor.setOrder(columnState.getOrder());
                ++i;
            }
        }
    }

    public void updateFilterDescriptor(FilterDescriptor[] filterDescriptors) {
        if (filterDescriptors != null) {
            int i = 0;
            while (i < this.filters.size()) {
                FilterDescriptor filterDescriptor = filterDescriptors[i];
                FilterState filterState = this.filters.get(i);
                filterDescriptor.setEnabled(filterState.isEnabled());
                ++i;
            }
        }
    }

    public void updateColumnState(ColumnDescriptor[] columnDescriptors) {
        if (columnDescriptors != null) {
            int i = 0;
            while (i < this.columns.size()) {
                ColumnDescriptor columnDescriptor = columnDescriptors[i];
                ColumnState columnState = this.columns.get(i);
                columnState.setVisible(columnDescriptor.isVisible());
                columnState.setWidth(columnDescriptor.getWidth());
                columnState.setOrder(columnDescriptor.getOrder());
                ++i;
            }
        }
    }

    public void updateFilterState(FilterDescriptor[] filterDescriptors) {
        if (filterDescriptors != null) {
            int i = 0;
            while (i < this.filters.size()) {
                FilterDescriptor filterDescriptor = filterDescriptors[i];
                FilterState filterState = this.filters.get(i);
                filterState.setEnabled(filterDescriptor.isEnabled());
                ++i;
            }
        }
    }
}

