/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.launch;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.tcf.core.AbstractPeer;
import org.eclipse.tcf.internal.debug.Activator;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;

public class TCFUserDefPeer
extends AbstractPeer {
    public TCFUserDefPeer(Map<String, String> attrs) {
        super(attrs);
    }

    public static void loadPeers() {
        try {
            String s;
            assert (Protocol.isDispatchThread());
            IPath path = Activator.getDefault().getStateLocation();
            File f = path.append("peers.ini").toFile();
            if (!f.exists()) {
                return;
            }
            HashMap<String, String> attrs = new HashMap<String, String>();
            BufferedReader rd = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
            while ((s = rd.readLine()) != null) {
                if (s.length() == 0) {
                    new TCFUserDefPeer(attrs);
                    attrs = new HashMap();
                    continue;
                }
                int i = s.indexOf(61);
                if (i <= 0) continue;
                attrs.put(s.substring(0, i), s.substring(i + 1));
            }
            rd.close();
        }
        catch (Exception x) {
            Activator.log("Cannot read peer list", x);
        }
    }

    public static void savePeers() {
        try {
            assert (Protocol.isDispatchThread());
            IPath path = Activator.getDefault().getStateLocation();
            File f = path.append("peers.ini").toFile();
            BufferedWriter wr = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8"));
            for (IPeer peer : Protocol.getLocator().getPeers().values()) {
                if (!(peer instanceof TCFUserDefPeer)) continue;
                Map attrs = peer.getAttributes();
                for (String nm : attrs.keySet()) {
                    wr.write(nm);
                    wr.write(61);
                    wr.write((String)attrs.get(nm));
                    wr.newLine();
                }
                wr.newLine();
            }
            wr.close();
        }
        catch (Exception x) {
            Activator.log("Cannot save peer list", x);
        }
    }
}

