/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.launch.ui.remote.app;

import org.eclipse.core.runtime.Assert;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.tcf.te.launch.core.persistence.DefaultPersistenceDelegate;
import org.eclipse.tcf.te.launch.core.persistence.launchcontext.LaunchContextsPersistenceDelegate;
import org.eclipse.tcf.te.launch.ui.interfaces.ILaunchConfigurationTabFormPart;
import org.eclipse.tcf.te.launch.ui.tabs.AbstractLaunchConfigurationTab;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.ui.dialogs.FSOpenFileDialog;
import org.eclipse.tcf.te.tcf.launch.ui.nls.Messages;
import org.eclipse.tcf.te.ui.controls.BaseEditBrowseTextControl;
import org.eclipse.tcf.te.ui.forms.parts.AbstractSection;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class LaunchConfigurationMainTabSection
extends AbstractSection
implements ILaunchConfigurationTabFormPart {
    BaseEditBrowseTextControl processImage;
    BaseEditBrowseTextControl processArguments;
    private Button stopAtEntry;
    private Button stopAtMain;
    private Button attachChildren;
    IModelNode firstSelection = null;

    public LaunchConfigurationMainTabSection(IManagedForm form, Composite parent) {
        super(form, parent, 66);
        this.getSection().setBackground(parent.getBackground());
        this.createClient(this.getSection(), form.getToolkit());
    }

    protected void createClient(final Section section, FormToolkit toolkit) {
        Assert.isNotNull((Object)section);
        Assert.isNotNull((Object)toolkit);
        section.setText(Messages.LaunchConfigurationMainTabSection_title);
        if (section.getParent().getLayout() instanceof GridLayout) {
            section.setLayoutData((Object)new GridData(272, 0x1000000, true, false));
        }
        Composite client = this.createClientContainer((Composite)section, 3, toolkit);
        Assert.isNotNull((Object)client);
        section.setClient((Control)client);
        client.setBackground(section.getBackground());
        this.createSectionToolbar(section, toolkit);
        this.processImage = new BaseEditBrowseTextControl(null){

            protected void onButtonControlSelected() {
                if (LaunchConfigurationMainTabSection.this.firstSelection != null) {
                    String absPath;
                    Object candidate;
                    FSOpenFileDialog dialog = new FSOpenFileDialog(section.getShell());
                    dialog.setFilterPath(this.getEditFieldControlText());
                    dialog.setInput((Object)LaunchConfigurationMainTabSection.this.firstSelection);
                    if (dialog.open() == 0 && (candidate = dialog.getFirstResult()) instanceof IFSTreeNode && (absPath = ((IFSTreeNode)candidate).getLocation()) != null) {
                        LaunchConfigurationMainTabSection.this.processImage.setEditFieldControlText(absPath);
                    }
                }
            }

            public void modifyText(ModifyEvent e) {
                super.modifyText(e);
                LaunchConfigurationMainTabSection.this.getManagedForm().dirtyStateChanged();
            }

            protected boolean isAdjustEditFieldControlWidthHint() {
                return true;
            }
        };
        this.processImage.setEditFieldLabel(Messages.LaunchConfigurationMainTabSection_processImage_label);
        this.processImage.setIsGroup(false);
        this.processImage.setHideBrowseButton(false);
        this.processImage.setAdjustBackgroundColor(true);
        this.processImage.setParentControlIsInnerPanel(true);
        this.processImage.setFormToolkit(toolkit);
        this.processImage.setupPanel(client);
        this.processImage.doCreateControlDecoration(this.processImage.getEditFieldControl(), client);
        this.processArguments = new BaseEditBrowseTextControl(null){

            public void modifyText(ModifyEvent e) {
                super.modifyText(e);
                LaunchConfigurationMainTabSection.this.getManagedForm().dirtyStateChanged();
            }

            protected boolean isAdjustEditFieldControlWidthHint() {
                return true;
            }
        };
        this.processArguments.setEditFieldLabel(Messages.LaunchConfigurationMainTabSection_processArguments_label);
        this.processArguments.setIsGroup(false);
        this.processArguments.setHideBrowseButton(true);
        this.processArguments.setAdjustBackgroundColor(true);
        this.processArguments.setParentControlIsInnerPanel(true);
        this.processArguments.setFormToolkit(toolkit);
        this.processArguments.setupPanel(client);
        Object container = this.getManagedForm().getContainer();
        if (container instanceof AbstractLaunchConfigurationTab) {
            String mode;
            ILaunchConfigurationDialog dialog = ((AbstractLaunchConfigurationTab)container).getLaunchConfigurationDialog();
            String string = mode = dialog != null ? dialog.getMode() : null;
            if ("debug".equals(mode)) {
                Label label = new Label(client, 256);
                GridData layoutData = new GridData(4, 0x1000000, true, false);
                layoutData.horizontalSpan = 3;
                label.setLayoutData((Object)layoutData);
                this.stopAtEntry = new Button(client, 32);
                this.stopAtEntry.setText(Messages.LaunchConfigurationMainTabSection_stopAtEntry_label);
                layoutData = new GridData(4, 0x1000000, true, false);
                layoutData.horizontalSpan = 3;
                this.stopAtEntry.setLayoutData((Object)layoutData);
                this.stopAtEntry.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        LaunchConfigurationMainTabSection.this.getManagedForm().dirtyStateChanged();
                    }
                });
                this.stopAtMain = new Button(client, 32);
                this.stopAtMain.setText(Messages.LaunchConfigurationMainTabSection_stopAtMain_label);
                layoutData = new GridData(4, 0x1000000, true, false);
                layoutData.horizontalSpan = 3;
                this.stopAtMain.setLayoutData((Object)layoutData);
                this.stopAtMain.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        LaunchConfigurationMainTabSection.this.getManagedForm().dirtyStateChanged();
                    }
                });
                this.attachChildren = new Button(client, 32);
                this.attachChildren.setText(Messages.LaunchConfigurationMainTabSection_attachChildren_label);
                layoutData = new GridData(4, 0x1000000, true, false);
                layoutData.horizontalSpan = 3;
                this.attachChildren.setLayoutData((Object)layoutData);
                this.attachChildren.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        LaunchConfigurationMainTabSection.this.getManagedForm().dirtyStateChanged();
                    }
                });
            }
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        Assert.isNotNull((Object)configuration);
        if (this.processImage != null) {
            String image = DefaultPersistenceDelegate.getAttribute((ILaunchConfiguration)configuration, (String)"org.eclipse.tcf.te.tcf.processes.core.process_image", (String)"");
            this.processImage.setEditFieldControlText(image);
        }
        if (this.processArguments != null) {
            String arguments = DefaultPersistenceDelegate.getAttribute((ILaunchConfiguration)configuration, (String)"org.eclipse.tcf.te.tcf.processes.core.process_arguments", (String)"");
            this.processArguments.setEditFieldControlText(arguments);
        }
        if (this.stopAtEntry != null) {
            boolean selected = DefaultPersistenceDelegate.getAttribute((ILaunchConfiguration)configuration, (String)"org.eclipse.tcf.te.tcf.processes.core.process_stop_at_entry", (boolean)false);
            this.stopAtEntry.setSelection(selected);
        }
        if (this.stopAtMain != null) {
            boolean selected = DefaultPersistenceDelegate.getAttribute((ILaunchConfiguration)configuration, (String)"org.eclipse.tcf.te.tcf.processes.core.process_stop_at_main", (boolean)false);
            this.stopAtMain.setSelection(selected);
        }
        if (this.attachChildren != null) {
            boolean selected = DefaultPersistenceDelegate.getAttribute((ILaunchConfiguration)configuration, (String)"org.eclipse.tcf.te.tcf.processes.core.process_attach_children", (boolean)false);
            this.attachChildren.setSelection(selected);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        Assert.isNotNull((Object)configuration);
        if (this.processImage != null) {
            String image = this.processImage.getEditFieldControlText();
            if (image != null && image.trim().length() > 0) {
                DefaultPersistenceDelegate.setAttribute((ILaunchConfigurationWorkingCopy)configuration, (String)"org.eclipse.tcf.te.tcf.processes.core.process_image", (String)image);
            } else {
                DefaultPersistenceDelegate.setAttribute((ILaunchConfigurationWorkingCopy)configuration, (String)"org.eclipse.tcf.te.tcf.processes.core.process_image", null);
            }
        } else {
            DefaultPersistenceDelegate.setAttribute((ILaunchConfigurationWorkingCopy)configuration, (String)"org.eclipse.tcf.te.tcf.processes.core.process_image", null);
        }
        if (this.processArguments != null) {
            String arguments = this.processArguments.getEditFieldControlText();
            if (arguments != null && arguments.trim().length() > 0) {
                DefaultPersistenceDelegate.setAttribute((ILaunchConfigurationWorkingCopy)configuration, (String)"org.eclipse.tcf.te.tcf.processes.core.process_arguments", (String)arguments);
            } else {
                DefaultPersistenceDelegate.setAttribute((ILaunchConfigurationWorkingCopy)configuration, (String)"org.eclipse.tcf.te.tcf.processes.core.process_arguments", null);
            }
        } else {
            DefaultPersistenceDelegate.setAttribute((ILaunchConfigurationWorkingCopy)configuration, (String)"org.eclipse.tcf.te.tcf.processes.core.process_arguments", null);
        }
        if (this.stopAtEntry != null) {
            DefaultPersistenceDelegate.setAttribute((ILaunchConfigurationWorkingCopy)configuration, (String)"org.eclipse.tcf.te.tcf.processes.core.process_stop_at_entry", (boolean)this.stopAtEntry.getSelection());
        }
        if (this.stopAtMain != null) {
            DefaultPersistenceDelegate.setAttribute((ILaunchConfigurationWorkingCopy)configuration, (String)"org.eclipse.tcf.te.tcf.processes.core.process_stop_at_main", (boolean)this.stopAtMain.getSelection());
        }
        if (this.attachChildren != null) {
            DefaultPersistenceDelegate.setAttribute((ILaunchConfigurationWorkingCopy)configuration, (String)"org.eclipse.tcf.te.tcf.processes.core.process_attach_children", (boolean)this.attachChildren.getSelection());
        }
    }

    public boolean isValid(ILaunchConfiguration configuration) {
        this.firstSelection = null;
        IModelNode[] contexts = LaunchContextsPersistenceDelegate.getLaunchContexts((ILaunchConfiguration)configuration);
        if (contexts != null && contexts.length > 0) {
            this.firstSelection = contexts[0];
        }
        this.processImage.getButtonControl().setEnabled(this.firstSelection != null);
        if (this.processImage.getEditFieldControlText().trim().length() > 0) {
            this.setMessage(null, 0);
        } else {
            this.setMessage(Messages.LaunchConfigurationMainTabSection_error_missingProcessImage, 3);
        }
        this.processImage.updateControlDecoration(this.getMessage(), this.getMessageType());
        return this.processImage.getEditFieldControlText().trim().length() > 0;
    }
}

