/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.internal.mappings;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swtchart.IBarSeries;
import org.eclipse.swtchart.ILineSeries;
import org.eclipse.swtchart.LineStyle;
import org.eclipse.swtchart.extensions.barcharts.IBarSeriesSettings;
import org.eclipse.swtchart.extensions.core.IPointSeriesSettings;
import org.eclipse.swtchart.extensions.core.ISeriesSettings;
import org.eclipse.swtchart.extensions.core.MappedSeriesSettings;
import org.eclipse.swtchart.extensions.core.MappingsKey;
import org.eclipse.swtchart.extensions.core.MappingsSupport;
import org.eclipse.swtchart.extensions.core.MappingsType;
import org.eclipse.swtchart.extensions.core.ResourceSupport;
import org.eclipse.swtchart.extensions.core.SeriesLabelProvider;
import org.eclipse.swtchart.extensions.internal.mappings.MappingsIO;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesSettings;
import org.eclipse.swtchart.extensions.piecharts.ICircularSeriesSettings;
import org.eclipse.swtchart.extensions.scattercharts.IScatterSeriesSettings;

public class Mappings_v1000 {
    public static final String VERSION_NUMBER = "v1000";

    public Map<MappingsKey, ISeriesSettings> readSettings(String[] lines) {
        HashMap<MappingsKey, ISeriesSettings> mappings = new HashMap<MappingsKey, ISeriesSettings>();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            try {
                if (!line.startsWith("Version=")) {
                    String[] values = line.split("\t");
                    this.importMapping(values, mappings);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return mappings;
    }

    public String saveSettings(List<MappedSeriesSettings> mappings) {
        StringBuilder builder = new StringBuilder();
        MappingsIO.appendVersion(builder, VERSION_NUMBER);
        for (MappedSeriesSettings mapping : mappings) {
            ArrayList<Object> values = new ArrayList<Object>();
            this.exportMapping(values, mapping);
            builder.append(this.create(values));
        }
        return builder.toString();
    }

    private void exportMapping(List<Object> values, MappedSeriesSettings mapping) {
        ISeriesSettings seriesSettings = mapping.getSeriesSettings();
        values.add((Object)mapping.getMappingsType());
        values.add(this.clean(mapping.getIdentifier()));
        this.exportSeriesSetting(values, seriesSettings);
        this.exportSeriesSetting(values, seriesSettings.getSeriesSettingsHighlight());
    }

    private void importMapping(String[] values, Map<MappingsKey, ISeriesSettings> mappings) {
        MappingsType mappingsType;
        ISeriesSettings seriesSettings;
        int index = 0;
        if (values.length >= 2 && (seriesSettings = MappingsSupport.createSeriesSettings(mappingsType = MappingsSupport.getMappingsType(values[index++]))) != null) {
            String id = values[index++];
            MappingsKey mappingsKey = new MappingsKey(mappingsType, id);
            index = this.importSeriesSetting(values, index, seriesSettings);
            index = this.importSeriesSetting(values, index, seriesSettings.getSeriesSettingsHighlight());
            mappings.put(mappingsKey, seriesSettings);
        }
    }

    private void exportSeriesSetting(List<Object> values, ISeriesSettings seriesSettings) {
        values.add(this.clean(seriesSettings.getDescription()));
        values.add(seriesSettings.isVisible());
        values.add(seriesSettings.isVisibleInLegend());
        values.add(ResourceSupport.getColor((Color)SeriesLabelProvider.getColor(seriesSettings)));
        if (seriesSettings instanceof IBarSeriesSettings) {
            this.exportBarSeriesSetting(values, (IBarSeriesSettings)seriesSettings);
        } else if (seriesSettings instanceof ICircularSeriesSettings) {
            this.exportCircularSeriesSetting(values, (ICircularSeriesSettings)seriesSettings);
        } else if (seriesSettings instanceof ILineSeriesSettings) {
            this.exportLineSeriesSetting(values, (ILineSeriesSettings)seriesSettings);
        } else if (seriesSettings instanceof IScatterSeriesSettings) {
            this.exportScatterSeriesSetting(values, (IScatterSeriesSettings)seriesSettings);
        }
    }

    private int importSeriesSetting(String[] values, int index, ISeriesSettings seriesSettings) {
        if (values.length >= index + 4) {
            seriesSettings.setDescription(values[index++]);
            seriesSettings.setVisible(Boolean.parseBoolean(values[index++]));
            seriesSettings.setVisibleInLegend(Boolean.parseBoolean(values[index++]));
            SeriesLabelProvider.setColor(seriesSettings, ResourceSupport.getColor((String)values[index++]));
        }
        if (seriesSettings instanceof IBarSeriesSettings) {
            index = this.importBarSeriesSetting(values, index, (IBarSeriesSettings)seriesSettings);
        } else if (seriesSettings instanceof ICircularSeriesSettings) {
            index = this.importCircularSeriesSetting(values, index, (ICircularSeriesSettings)seriesSettings);
        } else if (seriesSettings instanceof ILineSeriesSettings) {
            index = this.importLineSeriesSetting(values, index, (ILineSeriesSettings)seriesSettings);
        } else if (seriesSettings instanceof IScatterSeriesSettings) {
            index = this.importScatterSeriesSetting(values, index, (IScatterSeriesSettings)seriesSettings);
        }
        return index;
    }

    private void exportBarSeriesSetting(List<Object> values, IBarSeriesSettings barSeriesSettings) {
        values.add(ResourceSupport.getColor((Color)barSeriesSettings.getBarColor()));
        values.add(barSeriesSettings.getBarPadding());
        values.add(barSeriesSettings.getBarWidth());
        values.add(barSeriesSettings.isBarOverlay());
        values.add(barSeriesSettings.getBarWidthStyle().name());
        values.add(barSeriesSettings.isEnableStack());
    }

    private int importBarSeriesSetting(String[] values, int index, IBarSeriesSettings barSeriesSettings) {
        if (values.length >= index + 6) {
            barSeriesSettings.setBarColor(ResourceSupport.getColor((String)values[index++]));
            barSeriesSettings.setBarPadding(Integer.parseInt(values[index++]));
            barSeriesSettings.setBarWidth(Integer.parseInt(values[index++]));
            barSeriesSettings.setBarOverlay(Boolean.parseBoolean(values[index++]));
            barSeriesSettings.setBarWidthStyle(IBarSeries.BarWidthStyle.valueOf((String)values[index++]));
            barSeriesSettings.setEnableStack(Boolean.parseBoolean(values[index++]));
        }
        return index;
    }

    private void exportCircularSeriesSetting(List<Object> values, ICircularSeriesSettings circularSeriesSettings) {
        values.add(ResourceSupport.getColor((Color)circularSeriesSettings.getSliceColor()));
        values.add(ResourceSupport.getColor((Color)circularSeriesSettings.getBorderColor()));
        values.add(circularSeriesSettings.getBorderWidth());
        values.add(circularSeriesSettings.getBorderStyle().name());
    }

    private int importCircularSeriesSetting(String[] values, int index, ICircularSeriesSettings circularSeriesSettings) {
        if (values.length >= index + 4) {
            circularSeriesSettings.setSliceColor(ResourceSupport.getColor((String)values[index++]));
            circularSeriesSettings.setBorderColor(ResourceSupport.getColor((String)values[index++]));
            circularSeriesSettings.setBorderWidth(Integer.parseInt(values[index++]));
            circularSeriesSettings.setBorderStyle(LineStyle.valueOf((String)values[index++]));
        }
        return index;
    }

    private void exportLineSeriesSetting(List<Object> values, ILineSeriesSettings lineSeriesSettings) {
        this.exportPointSeriesSetting(values, lineSeriesSettings);
        values.add(lineSeriesSettings.getLineStyle().name());
        values.add(lineSeriesSettings.getLineWidth());
        values.add(ResourceSupport.getColor((Color)lineSeriesSettings.getLineColor()));
        values.add(lineSeriesSettings.getAntialias());
        values.add(lineSeriesSettings.isEnableArea());
        values.add(lineSeriesSettings.isEnableStack());
        values.add(lineSeriesSettings.isEnableStep());
    }

    private int importLineSeriesSetting(String[] values, int index, ILineSeriesSettings lineSeriesSettings) {
        if (values.length >= (index = this.importPointSeriesSetting(values, index, lineSeriesSettings)) + 7) {
            lineSeriesSettings.setLineStyle(LineStyle.valueOf((String)values[index++]));
            lineSeriesSettings.setLineWidth(Integer.parseInt(values[index++]));
            lineSeriesSettings.setLineColor(ResourceSupport.getColor((String)values[index++]));
            lineSeriesSettings.setAntialias(Integer.valueOf(values[index++]));
            lineSeriesSettings.setEnableArea(Boolean.valueOf(values[index++]));
            lineSeriesSettings.setEnableStack(Boolean.valueOf(values[index++]));
            lineSeriesSettings.setEnableStep(Boolean.valueOf(values[index++]));
        }
        return index;
    }

    private void exportScatterSeriesSetting(List<Object> values, IScatterSeriesSettings scatterSeriesSettings) {
        this.exportPointSeriesSetting(values, scatterSeriesSettings);
    }

    private int importScatterSeriesSetting(String[] values, int index, IScatterSeriesSettings scatterSeriesSettings) {
        index = this.importPointSeriesSetting(values, index, scatterSeriesSettings);
        return index;
    }

    private void exportPointSeriesSetting(List<Object> values, IPointSeriesSettings pointSeriesSettings) {
        values.add(pointSeriesSettings.getSymbolType().name());
        values.add(pointSeriesSettings.getSymbolSize());
        values.add(ResourceSupport.getColor((Color)pointSeriesSettings.getSymbolColor()));
    }

    private int importPointSeriesSetting(String[] values, int index, IPointSeriesSettings pointSeriesSettings) {
        if (values.length >= index + 3) {
            pointSeriesSettings.setSymbolType(ILineSeries.PlotSymbolType.valueOf((String)values[index++]));
            pointSeriesSettings.setSymbolSize(Integer.valueOf(values[index++]));
            pointSeriesSettings.setSymbolColor(ResourceSupport.getColor((String)values[index++]));
        }
        return index;
    }

    private String create(List<Object> values) {
        StringBuilder builder = new StringBuilder();
        Iterator<Object> iterator = values.iterator();
        while (iterator.hasNext()) {
            builder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            builder.append("\t");
        }
        builder.append("\r\n");
        return builder.toString();
    }

    private final String clean(String value) {
        return value.replace("\t", "");
    }
}

