/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.core.runtime;

import com.ibm.icu.text.DateFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.statet.ecommons.debug.core.model.AbstractProcess;
import org.eclipse.statet.ecommons.io.FileUtil;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.nico.core.runtime.History;
import org.eclipse.statet.nico.core.runtime.ITrack;
import org.eclipse.statet.nico.core.runtime.Queue;
import org.eclipse.statet.nico.core.runtime.ToolController;
import org.eclipse.statet.nico.core.runtime.ToolStatus;
import org.eclipse.statet.nico.core.runtime.ToolWorkspace;

public class ToolProcess
extends AbstractProcess
implements IProcess,
Tool,
ToolController.IToolStatusListener {
    public static final String PROCESS_TYPE_SUFFIX = ".nico";
    public static final int EXITCODE_DISCONNECTED = 101;
    private final String fMainType;
    private final Set<String> fFeatureSets = new HashSet<String>();
    private final String fToolLabelShort;
    private final String fToolLabelLong;
    private String fToolLabelTrimmedWD;
    private String fToolLabelStatus;
    private final String fAddress;
    private final long fConnectionTimestamp;
    private long fStartupTimestamp;
    private String fStartupWD;
    Map<String, Object> connectionInfo;
    private ToolController fController;
    private final Queue fQueue;
    private final History fHistory;
    private ToolWorkspace fWorkspaceData;
    private final Object fDisposeLock = new Object();
    private int fRetain;
    private boolean fIsDisposed;
    private final boolean fCaptureOutput;
    private volatile ToolStatus fStatus = ToolStatus.STARTING;
    private ImList<? extends ITrack> fTracks = ImCollections.emptyList();

    public ToolProcess(ILaunch launch, String mainType, String labelPrefix, String name, String address, String wd, long timestamp) {
        super(launch, name);
        this.fMainType = mainType;
        this.fAddress = address;
        this.fStartupWD = wd;
        this.fStartupTimestamp = timestamp;
        this.fConnectionTimestamp = timestamp;
        this.fToolLabelShort = labelPrefix;
        this.fToolLabelLong = String.valueOf(labelPrefix) + ' ' + name;
        this.fToolLabelStatus = ToolStatus.STARTING.getMarkedLabel();
        this.fToolLabelTrimmedWD = this.trimPath(wd);
        this.fCaptureOutput = false;
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener(new ILaunchesListener(){

            public void launchesAdded(ILaunch[] launches) {
            }

            public void launchesChanged(ILaunch[] launches) {
            }

            public void launchesRemoved(ILaunch[] launches) {
                ILaunch[] iLaunchArray = launches;
                int n = launches.length;
                int n2 = 0;
                while (n2 < n) {
                    DebugPlugin plugin;
                    ILaunch launch = iLaunchArray[n2];
                    if (ToolProcess.this.getLaunch() == launch && (plugin = DebugPlugin.getDefault()) != null) {
                        plugin.getLaunchManager().removeLaunchListener((ILaunchesListener)this);
                        ToolProcess.this.dispose();
                    }
                    ++n2;
                }
            }
        });
        this.fQueue = new Queue(this);
        this.fHistory = new History(this);
    }

    public void init(ToolController controller) {
        this.fController = controller;
        this.fWorkspaceData = this.fController.getWorkspaceData();
        this.fWorkspaceData.addPropertyListener(new ToolWorkspace.Listener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChanged(ToolWorkspace workspace, Map<String, Object> properties) {
                DebugEvent nameEvent;
                Map attributes;
                Map map = attributes = ToolProcess.this.getAttributes();
                synchronized (map) {
                    ToolProcess.this.fToolLabelTrimmedWD = null;
                    nameEvent = ToolProcess.this.doSet(attributes, IProcess.ATTR_PROCESS_LABEL, ToolProcess.this.computeConsoleLabel());
                }
                if (nameEvent != null) {
                    ToolProcess.this.fireEvent(nameEvent);
                }
            }
        });
        this.fToolLabelTrimmedWD = null;
        Map attributes = this.getAttributes();
        this.doSet(attributes, IProcess.ATTR_PROCESS_LABEL, this.computeConsoleLabel());
        this.doSet(attributes, IProcess.ATTR_PROCESS_TYPE, (String.valueOf(this.fMainType) + PROCESS_TYPE_SUFFIX).intern());
        this.fHistory.init();
        this.created();
    }

    public void registerFeatureSet(String featureSetID) {
        this.fFeatureSets.add(featureSetID);
    }

    public boolean isProvidingFeatureSet(String featureSetID) {
        return this.fFeatureSets.contains(featureSetID);
    }

    private String computeConsoleLabel() {
        String wd = this.fToolLabelTrimmedWD;
        if (wd == null) {
            wd = this.fToolLabelTrimmedWD = this.trimPath(FileUtil.toString((IFileStore)this.fWorkspaceData.getWorkspaceDir()));
        }
        return String.valueOf(this.fToolLabelShort) + ' ' + this.getLabel() + "  \u2219  " + wd + "   \t " + this.fToolLabelStatus;
    }

    private String trimPath(String path) {
        if (path == null) {
            return "\u2013";
        }
        if (path.length() < 30) {
            return path;
        }
        int post1 = this.prevPathSeperator(path, path.length() - 1);
        if (post1 < 25) {
            return path;
        }
        int post2 = this.prevPathSeperator(path, post1 - 1);
        if (post2 < 20) {
            return path;
        }
        int pre1 = this.nextPathSeperator(path, 0);
        int pre2 = this.nextPathSeperator(path, pre1 + 1);
        pre2 = pre2 > 12 ? 10 : ++pre2;
        if (post2 - pre2 < 10) {
            return path;
        }
        return String.valueOf(path.substring(0, pre2)) + " ... " + path.substring(post2);
    }

    private int prevPathSeperator(String path, int offset) {
        int idx2;
        int idx1 = path.lastIndexOf(47, offset);
        return idx1 > (idx2 = path.lastIndexOf(92, offset)) ? idx1 : idx2;
    }

    private int nextPathSeperator(String path, int offset) {
        int idx1 = path.indexOf(47, offset);
        int idx2 = path.indexOf(92, offset);
        return idx1 >= 0 && idx1 < idx2 ? idx1 : idx2;
    }

    public final String getMainType() {
        return this.fMainType;
    }

    public String getLabel(int config) {
        if ((config & 1) != 0) {
            return this.fToolLabelLong;
        }
        return this.fToolLabelShort;
    }

    public ToolController getController() {
        return this.fController;
    }

    public History getHistory() {
        return this.fHistory;
    }

    public Queue getQueue() {
        return this.fQueue;
    }

    public IStreamsProxy getStreamsProxy() {
        return this.fCaptureOutput && this.fController != null ? this.fController.getStreams() : null;
    }

    public ToolWorkspace getWorkspaceData() {
        return this.fWorkspaceData;
    }

    public ToolStatus getToolStatus() {
        return this.fStatus;
    }

    void setExitValue(int value) {
        this.doSetExitValue(value);
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public void terminate() throws DebugException {
        ToolController controller = this.fController;
        if (controller != null) {
            controller.scheduleQuit();
        }
    }

    public boolean isTerminated() {
        return this.fStatus == ToolStatus.TERMINATED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void controllerStatusChanged(ToolStatus oldStatus, ToolStatus newStatus, List<DebugEvent> eventCollection) {
        DebugEvent nameEvent;
        Map attributes;
        this.fStatus = newStatus;
        if (newStatus == ToolStatus.TERMINATED) {
            this.fController = null;
            eventCollection.add(new DebugEvent((Object)this, 8));
        }
        Map map = attributes = this.getAttributes();
        synchronized (map) {
            this.fToolLabelStatus = newStatus.getMarkedLabel();
            nameEvent = this.doSet(attributes, IProcess.ATTR_PROCESS_LABEL, this.computeConsoleLabel());
        }
        if (nameEvent != null) {
            eventCollection.add(nameEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void dispose() {
        Object object = this.fDisposeLock;
        synchronized (object) {
            this.fIsDisposed = true;
            if (this.fRetain > 0) {
                return;
            }
        }
        this.doDispose();
    }

    public Map<String, Object> getConnectionInfo() {
        return this.connectionInfo;
    }

    public void prepareRestart(Map<String, Object> data) {
        if (this.fStatus != ToolStatus.TERMINATED) {
            throw new IllegalStateException();
        }
        if (data == null) {
            throw new NullPointerException();
        }
        data.put("process", this);
        data.put("processDispose", this.poseponeDispose());
        data.put("address", this.fAddress);
        data.put("connectionInfo", this.connectionInfo);
    }

    public void restartCompleted(Map<String, Object> data) {
        if (data == null) {
            throw new NullPointerException();
        }
        if (data.get("process") != this) {
            throw new IllegalArgumentException();
        }
        this.approveDispose(data.get("processDispose"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object poseponeDispose() {
        Object object = this.fDisposeLock;
        synchronized (object) {
            block4: {
                if (this.fRetain > 0 || !this.fIsDisposed) break block4;
                return null;
            }
            ++this.fRetain;
        }
        return new AtomicBoolean(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void approveDispose(Object ticket) {
        if (ticket instanceof AtomicBoolean && ((AtomicBoolean)ticket).getAndSet(false)) {
            Object object = this.fDisposeLock;
            synchronized (object) {
                --this.fRetain;
                if (this.fRetain > 0 || !this.fIsDisposed) {
                    return;
                }
            }
            this.doDispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDispose() {
        if (this.fQueue != null) {
            Queue queue = this.fQueue;
            synchronized (queue) {
                this.fQueue.internal_dispose();
            }
        }
        if (this.fHistory != null) {
            this.fHistory.dispose();
        }
    }

    void setTracks(List<? extends ITrack> tracks) {
        this.fTracks = ImCollections.toList(tracks);
    }

    public ImList<? extends ITrack> getTracks() {
        return this.fTracks;
    }

    void setStartupTimestamp(long timestamp) {
        this.fStartupTimestamp = timestamp;
    }

    public long getStartupTimestamp() {
        return this.fStartupTimestamp;
    }

    public long getConnectionTimestamp() {
        return this.fConnectionTimestamp;
    }

    public String createTimestampComment(long timestamp) {
        return String.valueOf(DateFormat.getDateTimeInstance().format((Object)timestamp)) + '\n';
    }

    void setStartupWD(String wd) {
        this.fStartupWD = wd;
    }

    public String getStartupWD() {
        return this.fStartupWD;
    }

    public String toString() {
        return this.fToolLabelLong;
    }
}

