/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.data.impl;

import java.io.IOException;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.data.RComplexStore;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.impl.AbstractComplexStore;
import org.eclipse.statet.rj.data.impl.ExternalizableRStore;

@NonNullByDefault
public class RComplexBFix64Store
extends AbstractComplexStore
implements ExternalizableRStore {
    public static final int SEGMENT_LENGTH = 0x10000000;
    private final long length;
    protected final double[] @NonNull [] realValues;
    protected final double[] @NonNull [] imaginaryValues;

    public RComplexBFix64Store(long length) {
        this.length = length;
        this.realValues = RComplexBFix64Store.new2dDoubleArray(length, 0x10000000);
        this.imaginaryValues = RComplexBFix64Store.new2dDoubleArray(length, 0x10000000);
    }

    public RComplexBFix64Store(double[] @NonNull [] realValues, double[] @NonNull [] imaginaryValues) {
        this.length = RComplexBFix64Store.check2dArrayLength(realValues, 0x10000000);
        if (this.length != RComplexBFix64Store.check2dArrayLength(imaginaryValues, 0x10000000)) {
            throw new IllegalArgumentException();
        }
        this.realValues = realValues;
        this.imaginaryValues = imaginaryValues;
    }

    public RComplexBFix64Store(double[] @NonNull [] realValues, double[] @NonNull [] imaginaryValues, boolean @Nullable [] @NonNull [] isNAs) {
        this.length = RComplexBFix64Store.check2dArrayLength(realValues, 0x10000000);
        if (this.length != RComplexBFix64Store.check2dArrayLength(imaginaryValues, 0x10000000)) {
            throw new IllegalArgumentException();
        }
        this.realValues = realValues;
        this.imaginaryValues = imaginaryValues;
        if (isNAs != null) {
            if (RComplexBFix64Store.check2dArrayLength(isNAs, 0x10000000) != this.length) {
                throw new IllegalArgumentException();
            }
            int i = 0;
            while (i < isNAs.length) {
                boolean[] isNAi = isNAs[i];
                int j = 0;
                while (j < isNAi.length) {
                    if (isNAi[j]) {
                        this.realValues[i][j] = NA_numeric_DOUBLE;
                        this.imaginaryValues[i][j] = NA_numeric_DOUBLE;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public RComplexBFix64Store(RJIO io, long length) throws IOException {
        this.length = length;
        this.realValues = RComplexBFix64Store.new2dDoubleArray(length, 0x10000000);
        this.imaginaryValues = RComplexBFix64Store.new2dDoubleArray(length, 0x10000000);
        int i = 0;
        while (i < this.realValues.length) {
            io.readDoubleData(this.realValues[i], this.realValues[i].length);
            io.readDoubleData(this.imaginaryValues[i], this.imaginaryValues[i].length);
            ++i;
        }
    }

    @Override
    public void writeExternal(RJIO io) throws IOException {
        int i = 0;
        while (i < this.realValues.length) {
            io.writeDoubleData(this.realValues[i], this.realValues[i].length);
            io.writeDoubleData(this.imaginaryValues[i], this.imaginaryValues[i].length);
            ++i;
        }
    }

    @Override
    protected final boolean isStructOnly() {
        return false;
    }

    @Override
    public final long getLength() {
        return this.length;
    }

    @Override
    public boolean isNA(int idx) {
        double v = this.realValues[idx / 0x10000000][idx % 0x10000000];
        return Double.isNaN(v) && (int)Double.doubleToRawLongBits(v) == 1954;
    }

    @Override
    public boolean isNA(long idx) {
        double v = this.realValues[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)];
        return Double.isNaN(v) && (int)Double.doubleToRawLongBits(v) == 1954;
    }

    @Override
    public void setNA(int idx) {
        this.realValues[idx / 0x10000000][idx % 0x10000000] = NA_numeric_DOUBLE;
        this.imaginaryValues[idx / 0x10000000][idx % 0x10000000] = NA_numeric_DOUBLE;
    }

    @Override
    public void setNA(long idx) {
        this.realValues[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)] = NA_numeric_DOUBLE;
        this.imaginaryValues[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)] = NA_numeric_DOUBLE;
    }

    @Override
    public boolean isNaN(int idx) {
        double v = this.realValues[idx / 0x10000000][idx % 0x10000000];
        return Double.isNaN(v) && (int)Double.doubleToRawLongBits(v) != 1954;
    }

    @Override
    public boolean isNaN(long idx) {
        double value = this.realValues[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)];
        return Double.isNaN(value) && (int)Double.doubleToRawLongBits(value) != 1954;
    }

    @Override
    public boolean isMissing(int idx) {
        return Double.isNaN(this.realValues[idx / 0x10000000][idx % 0x10000000]);
    }

    @Override
    public boolean isMissing(long idx) {
        return Double.isNaN(this.realValues[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)]);
    }

    @Override
    public double getCplxRe(int idx) {
        return this.realValues[idx / 0x10000000][idx % 0x10000000];
    }

    @Override
    public double getCplxRe(long idx) {
        return this.realValues[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)];
    }

    @Override
    public double getCplxIm(int idx) {
        return this.imaginaryValues[idx / 0x10000000][idx % 0x10000000];
    }

    @Override
    public double getCplxIm(long idx) {
        return this.imaginaryValues[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)];
    }

    @Override
    public void setCplx(int idx, double real, double imaginary) {
        if (Double.isNaN(real) || Double.isNaN(imaginary)) {
            this.realValues[idx / 0x10000000][idx % 0x10000000] = Double.NaN;
            this.imaginaryValues[idx / 0x10000000][idx % 0x10000000] = Double.NaN;
        } else {
            this.realValues[idx / 0x10000000][idx % 0x10000000] = real;
            this.imaginaryValues[idx / 0x10000000][idx % 0x10000000] = imaginary;
        }
    }

    @Override
    public void setCplx(long idx, double real, double imaginary) {
        if (Double.isNaN(real) || Double.isNaN(imaginary)) {
            this.realValues[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)] = Double.NaN;
            this.imaginaryValues[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)] = Double.NaN;
        } else {
            this.realValues[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)] = real;
            this.imaginaryValues[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)] = imaginary;
        }
    }

    @Override
    public void setNum(int idx, double real) {
        if (Double.isNaN(real)) {
            this.realValues[idx / 0x10000000][idx % 0x10000000] = Double.NaN;
            this.imaginaryValues[idx / 0x10000000][idx % 0x10000000] = Double.NaN;
        } else {
            this.realValues[idx / 0x10000000][idx % 0x10000000] = real;
            this.imaginaryValues[idx / 0x10000000][idx % 0x10000000] = 0.0;
        }
    }

    @Override
    public void setNum(long idx, double real) {
        if (Double.isNaN(real)) {
            this.realValues[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)] = Double.NaN;
            this.imaginaryValues[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)] = Double.NaN;
        } else {
            this.realValues[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)] = real;
            this.imaginaryValues[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)] = 0.0;
        }
    }

    @Override
    public  @Nullable RComplexStore.Complex get(int idx) {
        if (idx < 0 || (long)idx >= this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        double v = this.realValues[idx / 0x10000000][idx % 0x10000000];
        return !Double.isNaN(v) || (int)Double.doubleToRawLongBits(v) != 1954 ? new RComplexStore.Complex(v, this.imaginaryValues[idx / 0x10000000][idx % 0x10000000]) : null;
    }

    @Override
    public  @Nullable RComplexStore.Complex get(long idx) {
        if (idx < 0L || idx >= this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        double v = this.realValues[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)];
        return !Double.isNaN(v) || (int)Double.doubleToRawLongBits(v) != 1954 ? new RComplexStore.Complex(v, this.imaginaryValues[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)]) : null;
    }

    @Override
    public  @Nullable RComplexStore.Complex[] toArray() {
        int l = this.checkToArrayLength();
        RComplexStore.Complex[] array = new RComplexStore.Complex[l];
        int i = 0;
        int destIdx = 0;
        while (i < this.realValues.length) {
            double[] res = this.realValues[i];
            double[] ims = this.imaginaryValues[i];
            int j = 0;
            while (j < res.length) {
                double v = res[j];
                if (!Double.isNaN(v) || (int)Double.doubleToRawLongBits(v) != 1954) {
                    array[destIdx] = new RComplexStore.Complex(v, ims[j]);
                }
                ++j;
                ++destIdx;
            }
            ++i;
        }
        return array;
    }

    @Override
    public boolean allEqual(RStore<?> other) {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

