/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.core.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.statet.internal.r.debug.core.model.BasicRVariable;
import org.eclipse.statet.internal.r.debug.core.model.RArrayValue;
import org.eclipse.statet.internal.r.debug.core.model.RDebugTargetImpl;
import org.eclipse.statet.internal.r.debug.core.model.RElementVariableValue;
import org.eclipse.statet.internal.r.debug.core.model.REnvValue;
import org.eclipse.statet.internal.r.debug.core.model.RFunctionValue;
import org.eclipse.statet.internal.r.debug.core.model.RLanguageValue;
import org.eclipse.statet.internal.r.debug.core.model.RListValue;
import org.eclipse.statet.internal.r.debug.core.model.RMainThread;
import org.eclipse.statet.internal.r.debug.core.model.RPromiseValue;
import org.eclipse.statet.internal.r.debug.core.model.RValueProxy;
import org.eclipse.statet.internal.r.debug.core.model.RVariableProxy;
import org.eclipse.statet.internal.r.debug.core.model.RVectorValue;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.r.console.core.RProcessREnvironment;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.debug.core.RElementVariable;
import org.eclipse.statet.r.debug.core.RValue;
import org.eclipse.statet.r.debug.core.RVariable;
import org.eclipse.statet.rj.data.RArray;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RReference;

@NonNullByDefault
public final class BasicRElementVariable
extends BasicRVariable
implements RElementVariable {
    public static final int DEFAULT_FRAGMENT_COUNT = 100;
    private final RMainThread thread;
    private CombinedRElement element;
    private int stamp;
    private @Nullable RValue value;
    private @Nullable CombinedRElement previousElement;
    private @Nullable IValue previousValue;

    public static @Nullable RElementName createFQElementName(RVariable variable) {
        ArrayList<RElementName> segments = new ArrayList<RElementName>();
        int lastRType = 0;
        do {
            if (!(variable instanceof RElementVariable)) continue;
            CombinedRElement element = ((RElementVariable)variable).getElement();
            RElementName elementName = element.getElementName();
            if (elementName.getType() == 16) {
                return null;
            }
            lastRType = element.getRObjectType();
            segments.add(elementName);
        } while ((variable = variable.getParent()) != null);
        if (lastRType != 8) {
            return null;
        }
        Collections.reverse(segments);
        return RElementName.create(segments);
    }

    private static boolean isEnv(@Nullable RObject object) {
        return object != null && object.getRObjectType() == 8;
    }

    public BasicRElementVariable(CombinedRElement element, RMainThread thread, int stamp, @Nullable RVariable parent) {
        super((RDebugTargetImpl)thread.getDebugTarget(), parent);
        this.thread = thread;
        this.element = element;
        this.stamp = stamp;
    }

    public synchronized boolean update(CombinedRElement element, int stamp) {
        if (this.isValidUpdate(element)) {
            this.previousElement = this.element;
            this.previousValue = this.value;
            this.element = element;
            this.stamp = stamp;
            this.value = null;
            return true;
        }
        return false;
    }

    private boolean isValidUpdate(CombinedRElement element) {
        if (element.getRObjectType() == this.element.getRObjectType()) {
            switch (element.getRObjectType()) {
                case 2: {
                    return element.getData().getStoreType() == this.element.getData().getStoreType();
                }
                case 3: {
                    return element.getData().getStoreType() == this.element.getData().getStoreType() && ((RArray)element).getDim().getLength() == ((RArray)this.element).getDim().getLength();
                }
                case 8: 
                case 10: {
                    return Objects.equals(element.getRClassName(), this.element.getRClassName());
                }
            }
            return true;
        }
        return false;
    }

    public synchronized void reset(int stamp) {
        this.stamp = stamp;
        this.value = null;
    }

    @Override
    public final RMainThread getThread() {
        return this.thread;
    }

    public final CombinedRElement getCurrentElement() {
        return this.element;
    }

    public final @Nullable RValue getCurrentValue() {
        return this.value;
    }

    public final int getCurrentStamp() {
        return this.stamp;
    }

    public final @Nullable CombinedRElement getPreviousElement() {
        return this.previousElement;
    }

    public final @Nullable IValue getPreviousValue() {
        return this.previousValue;
    }

    @Override
    public synchronized CombinedRElement getElement() {
        return this.element;
    }

    @Override
    public @Nullable RElementName getFQElementName() {
        return BasicRElementVariable.createFQElementName(this);
    }

    @Override
    public synchronized String getName() {
        return this.element.getElementName().getDisplayName();
    }

    @Override
    public synchronized String getReferenceTypeName() throws DebugException {
        return this.element.getRClassName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasValueChanged() throws DebugException {
        IValue previousValue;
        CombinedRElement previousElement;
        CombinedRElement element;
        BasicRElementVariable basicRElementVariable = this;
        synchronized (basicRElementVariable) {
            element = this.element;
            previousElement = this.previousElement;
            previousValue = this.previousValue;
        }
        if (previousElement != null) {
            switch (element.getRObjectType()) {
                case 2: {
                    if (previousValue == null || element.getLength() != 1L) break;
                    return ((RVectorValue)this.getValue()).hasValueChanged(0L);
                }
                case 14: {
                    return ((RReference)element).getHandle() != ((RReference)previousElement).getHandle();
                }
            }
        }
        return false;
    }

    @Override
    public RValue getValue() throws DebugException {
        return this.getValue(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RValue getValue(@Nullable ProgressMonitor m) throws DebugException {
        int stamp;
        CombinedRElement element;
        BasicRElementVariable basicRElementVariable = this;
        synchronized (basicRElementVariable) {
            if (this.value != null) {
                return this.value;
            }
            element = this.element;
            stamp = this.stamp;
            if (element.getRObjectType() != 14) {
                this.value = this.createValue(element);
                return this.value;
            }
        }
        if (m != null) {
            try {
                element = this.getThread().resolveReference(element, stamp, m);
            }
            catch (StatusException e) {
                throw new DebugException((IStatus)new Status(4, "org.eclipse.statet.r.debug.core", 5010, "Request failed: cannot resolve reference.", (Throwable)e));
            }
        } else {
            element = this.getThread().resolveReference(element, stamp);
        }
        RValue value = null;
        if (element.getRObjectType() == 8) {
            value = this.createEnvValue((RProcessREnvironment)element, stamp);
        }
        BasicRElementVariable basicRElementVariable2 = this;
        synchronized (basicRElementVariable2) {
            if (this.value != null) {
                return this.value;
            }
            if (value == null) {
                value = this.createValue(element);
            }
            this.value = value;
            return this.value;
        }
    }

    @Override
    public synchronized boolean supportsValueModification() {
        switch (this.element.getRObjectType()) {
            case 2: {
                return this.element.getLength() == 1L;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verifyValue(String expression) throws DebugException {
        CombinedRElement element;
        BasicRElementVariable basicRElementVariable = this;
        synchronized (basicRElementVariable) {
            element = this.element;
        }
        switch (element.getRObjectType()) {
            case 2: {
                if (element.getLength() == 1L) {
                    return ((RVectorValue)this.getValue()).validateDataExpr(expression);
                }
                throw this.newNotSupported();
            }
        }
        throw this.newNotSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(String expression) throws DebugException {
        CombinedRElement element;
        BasicRElementVariable basicRElementVariable = this;
        synchronized (basicRElementVariable) {
            element = this.element;
        }
        switch (element.getRObjectType()) {
            case 2: {
                if (element.getLength() == 1L) {
                    ((RVectorValue)this.getValue()).setDataExpr(0L, expression);
                    return;
                }
                throw this.newNotSupported();
            }
        }
        throw this.newNotSupported();
    }

    private RValue createValue(CombinedRElement element) throws DebugException {
        switch (element.getRObjectType()) {
            case 2: {
                return new RVectorValue(this);
            }
            case 3: {
                return new RArrayValue(this);
            }
            case 7: {
                return new RListValue(this);
            }
            case 8: {
                return this.createEnvValue((RProcessREnvironment)element, this.stamp);
            }
            case 6: 
            case 10: {
                return new RListValue.ByName(this);
            }
            case 12: {
                return new RLanguageValue(this);
            }
            case 13: {
                return new RFunctionValue(this);
            }
            case 18: {
                if (!BasicRElementVariable.isEnv((RObject)element.getModelParent())) break;
                return new RPromiseValue(this);
            }
        }
        return new RElementVariableValue(this);
    }

    private @Nullable RValue createEnvValue(RProcessREnvironment element, int stamp) throws DebugException {
        REnvValue envValue = this.thread.getEnvValue(element, stamp);
        if (envValue != null) {
            RElementName elementName = element.getElementName();
            if (elementName != null && elementName.getNextSegment() == null && envValue.setVariable(this)) {
                return envValue;
            }
            return RValueProxy.create(envValue, this);
        }
        throw new DebugException((IStatus)new Status(4, "org.eclipse.statet.r.debug.core", 5010, "Request failed: reference is stale.", null));
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        obj = RVariableProxy.unproxy(obj);
        return super.equals(obj);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + ": " + this.getName();
    }
}

