/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.util;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.preferences.ui.ScopedPreferenceStore;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;

public class CombinedPreferenceStore {
    public static IPreferenceStore createStore(IPreferenceStore[] preferenceStores, PreferenceAccess corePrefs, String[] coreQualifier) {
        IScopeContext mainScope;
        ImList contexts = corePrefs.getPreferenceContexts();
        if (contexts.size() > 0 && contexts.get(contexts.size() - 1) instanceof DefaultScope) {
            contexts = contexts.subList(0, contexts.size() - 1);
        }
        IScopeContext iScopeContext = mainScope = !contexts.isEmpty() ? (IScopeContext)contexts.get(0) : InstanceScope.INSTANCE;
        if (preferenceStores.length == 0 && contexts.size() <= 1 && coreQualifier.length == 1) {
            return new ScopedPreferenceStore(mainScope, coreQualifier[0]);
        }
        ArrayList<Object> stores = new ArrayList<Object>();
        String[] stringArray = coreQualifier;
        int n = coreQualifier.length;
        int n2 = 0;
        while (n2 < n) {
            String qualifier = stringArray[n2];
            ScopedPreferenceStore store = new ScopedPreferenceStore(mainScope, qualifier);
            store.setSearchContexts(contexts);
            stores.add(store);
            ++n2;
        }
        stores.addAll(Arrays.asList(preferenceStores));
        return new ChainedPreferenceStore(stores.toArray(new IPreferenceStore[stores.size()]));
    }

    public static IPreferenceStore createStore(PreferenceAccess corePrefs, String coreQualifier) {
        return CombinedPreferenceStore.createStore(new IPreferenceStore[0], corePrefs, new String[]{coreQualifier});
    }

    public static IPreferenceStore createStore(IPreferenceStore ... preferenceStores) {
        return new ChainedPreferenceStore(preferenceStores);
    }

    private CombinedPreferenceStore() {
    }
}

