/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.tex.core.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.statet.docmlet.tex.core.ast.ContainerNode;
import org.eclipse.statet.docmlet.tex.core.ast.ControlNode;
import org.eclipse.statet.docmlet.tex.core.ast.Dummy;
import org.eclipse.statet.docmlet.tex.core.ast.Embedded;
import org.eclipse.statet.docmlet.tex.core.ast.Environment;
import org.eclipse.statet.docmlet.tex.core.ast.Group;
import org.eclipse.statet.docmlet.tex.core.ast.Label;
import org.eclipse.statet.docmlet.tex.core.ast.Math;
import org.eclipse.statet.docmlet.tex.core.ast.NodeType;
import org.eclipse.statet.docmlet.tex.core.ast.SourceComponent;
import org.eclipse.statet.docmlet.tex.core.ast.TexAstNode;
import org.eclipse.statet.docmlet.tex.core.ast.TexAsts;
import org.eclipse.statet.docmlet.tex.core.ast.Text;
import org.eclipse.statet.docmlet.tex.core.ast.Verbatim;
import org.eclipse.statet.docmlet.tex.core.commands.Argument;
import org.eclipse.statet.docmlet.tex.core.commands.EnvDefinitions;
import org.eclipse.statet.docmlet.tex.core.commands.LtxCommandDefinitions;
import org.eclipse.statet.docmlet.tex.core.commands.TexCommand;
import org.eclipse.statet.docmlet.tex.core.commands.TexCommandSet;
import org.eclipse.statet.docmlet.tex.core.commands.TexEmbedCommand;
import org.eclipse.statet.docmlet.tex.core.parser.CustomScanner;
import org.eclipse.statet.docmlet.tex.core.parser.LtxLexer;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.string.BasicStringFactory;
import org.eclipse.statet.jcommons.string.StringFactory;
import org.eclipse.statet.jcommons.text.core.input.TextParserInput;
import org.eclipse.statet.ltk.ast.core.AstNode;

@NonNullByDefault
public class LtxParser {
    private static final byte ST_ROOT = 0;
    private static final byte ST_CURLY = 1;
    private static final byte ST_SQUARED = 2;
    private static final byte ST_BEGINEND = 3;
    private static final byte ST_MATHROUND = 4;
    private static final byte ST_MATHSQUARED = 5;
    private static final byte ST_MATHDOLLAR = 6;
    private static final byte ST_MATHDOLLARDOLLAR = 7;
    private static final Object LABEL_TEXT = new Object(){

        public String toString() {
            return "LABEL";
        }
    };
    private static final Object NUM_TEXT = new Object(){

        public String toString() {
            return "NUM";
        }
    };
    private final LtxLexer lexer;
    private TexCommandSet commandSet;
    private @Nullable Map<String, TexCommand> customCommands;
    private @Nullable Map<String, TexCommand> customEnvs;
    private @Nullable Map<String, TexCommand> additionalCommands;
    private @Nullable Map<String, TexCommand> additionalEnvs;
    private byte[] stackTypes = new byte[32];
    private @Nullable Object[] stackEndKeys = new Object[32];
    private int stackPos = -1;
    private int foundEndStackPos;
    private int foundEndOffset;
    private @Nullable TexAstNode foundEndNode;
    private boolean inMath;
    private final Text whitespace = new Text(null, -1, -1);
    private boolean wasLinebreak;
    private @Nullable List<Embedded> embeddedList;
    private final StringFactory symbolTextFactory;
    private final StringFactory otherTextFactory;

    private static @Nullable TexCommand getCommand(@Nullable Map<String, TexCommand> map, String key) {
        return map != null ? map.get(key) : null;
    }

    public LtxParser(@Nullable LtxLexer lexer, @Nullable StringFactory symbolTextFactory) {
        this.lexer = lexer != null ? lexer : new LtxLexer();
        this.lexer.setReportSquaredBrackets(true);
        if (symbolTextFactory != null) {
            this.symbolTextFactory = symbolTextFactory;
            this.otherTextFactory = BasicStringFactory.INSTANCE;
        } else {
            this.symbolTextFactory = BasicStringFactory.INSTANCE;
            this.otherTextFactory = BasicStringFactory.INSTANCE;
        }
    }

    public LtxParser() {
        this(null, null);
    }

    private @Nullable TexCommand getCommand(String controlWord) {
        TexCommand command;
        if (controlWord.equals("end")) {
            return LtxCommandDefinitions.GENERICENV_end_COMMAND;
        }
        if (this.inMath) {
            command = this.commandSet.getLtxMathCommandMap().get(controlWord);
        } else {
            command = this.commandSet.getLtxPreambleCommandMap().get(controlWord);
            if (command == null) {
                command = this.commandSet.getLtxTextCommandMap().get(controlWord);
            }
        }
        if (command == null && (command = LtxParser.getCommand(this.customCommands, controlWord)) == null) {
            command = LtxParser.getCommand(this.additionalCommands, controlWord);
        }
        return command;
    }

    private @Nullable TexCommand getEnv(String name) {
        TexCommand command = this.commandSet.getLtxInternEnvMap().get(name);
        if (command == null) {
            command = this.inMath ? this.commandSet.getLtxMathEnvMap().get(name) : this.commandSet.getLtxTextEnvMap().get(name);
            if (command == null && (command = LtxParser.getCommand(this.customEnvs, name)) == null) {
                command = LtxParser.getCommand(this.additionalEnvs, name);
            }
        }
        return command;
    }

    public void setCollectEmebeddedNodes(boolean enable) {
        this.embeddedList = enable ? new ArrayList(32) : null;
    }

    public @Nullable List<Embedded> getEmbeddedNodes() {
        return this.embeddedList;
    }

    public @Nullable Map<String, TexCommand> getCustomCommandMap() {
        return this.customCommands;
    }

    public @Nullable Map<String, TexCommand> getCustomEnvMap() {
        return this.customEnvs;
    }

    private void initTask(TextParserInput input, TaskConfig config) {
        if (this.embeddedList != null) {
            this.embeddedList.clear();
        }
        this.commandSet = config.commandSet;
        this.additionalCommands = config.additionalCommands;
        this.additionalEnvs = config.additionalEnvs;
        this.customCommands = null;
        this.customEnvs = null;
        this.lexer.reset(input);
        this.foundEndStackPos = -1;
        this.stackPos = -1;
        this.inMath = false;
        this.lexer.setReport$$(true);
        this.lexer.setReportAsterisk(false);
        this.lexer.setReportSquaredBrackets(true);
    }

    public SourceComponent parse(TextParserInput input, TexCommandSet commandSet) {
        this.initTask(input, new TaskConfig(commandSet));
        SourceComponent node = new SourceComponent();
        if (this.lexer.next() != -1) {
            node.startOffset = this.lexer.getOffset();
        }
        this.putToStack((byte)0, null);
        this.parseGroup(node);
        node.endOffset = this.lexer.getStopOffset();
        return node;
    }

    public SourceComponent parse(TextParserInput input, AstNode parent, TexCommandSet commandSet) {
        this.initTask(input, new TaskConfig(commandSet));
        SourceComponent node = new SourceComponent(parent, input.getStartIndex(), input.getStopIndex());
        if (this.lexer.next() != -1) {
            node.startOffset = this.lexer.getOffset();
        }
        this.putToStack((byte)0, null);
        this.parseGroup(node);
        node.endOffset = this.lexer.getStopOffset();
        return node;
    }

    public ControlNode scanControlWordArgs(TextParserInput input, TexCommand command, boolean expand, TaskConfig config) {
        this.initTask(input, config);
        this.wasLinebreak = false;
        ControlNode.Word controlNode = new ControlNode.Word(command.getControlWord());
        controlNode.startOffset = input.getStartIndex();
        controlNode.endOffset = input.getStartIndex();
        this.lexer.consume();
        this.parseWord(controlNode, command, false);
        if (expand && this.lexer.getOffset() > controlNode.endOffset) {
            controlNode.endOffset = this.lexer.getOffset();
        }
        return controlNode;
    }

    private void putToStack(byte type, @Nullable Object key) {
        if (++this.stackPos >= this.stackTypes.length) {
            int l = this.stackTypes.length + 16;
            this.stackTypes = Arrays.copyOf(this.stackTypes, l);
            this.stackEndKeys = Arrays.copyOf(this.stackEndKeys, l);
        }
        this.stackTypes[this.stackPos] = type;
        this.stackEndKeys[this.stackPos] = key;
    }

    private void putToStack(byte type, byte argContent) {
        switch (argContent & 0xF0) {
            case 32: 
            case 48: {
                this.putToStack(type, LABEL_TEXT);
                break;
            }
            case 80: {
                this.putToStack(type, NUM_TEXT);
                break;
            }
            default: {
                this.putToStack(type, null);
            }
        }
    }

    private void parseGroup(ContainerNode group) {
        ArrayList<TexAstNode> children = new ArrayList<TexAstNode>();
        Text textNode = null;
        block17: while (this.foundEndStackPos < 0) {
            switch (this.lexer.pop()) {
                case -1: {
                    group.endOffset = this.lexer.getStopOffset();
                    group.status = 8468;
                    this.foundEndStackPos = 0;
                    this.foundEndNode = null;
                    break block17;
                }
                case 5: {
                    TexAstNode node = this.createAndParseWord();
                    if (node == null) break block17;
                    node.texParent = group;
                    children.add(node);
                    textNode = null;
                    break;
                }
                case 6: {
                    this.wasLinebreak = false;
                    ControlNode.Char node = new ControlNode.Char(this.lexer.getText(this.symbolTextFactory));
                    node.startOffset = this.lexer.getOffset();
                    node.endOffset = this.lexer.getStopOffset();
                    if (this.inMath) {
                        if (node.getText() == ")") {
                            int endPos = this.stackPos;
                            while (endPos >= 0) {
                                if (this.stackTypes[endPos] == 4) {
                                    node.command = EnvDefinitions.ENV_math_END_SHORTHAND;
                                    this.foundEndStackPos = endPos;
                                    this.foundEndNode = node;
                                    this.lexer.consume();
                                    break block17;
                                }
                                --endPos;
                            }
                        } else if (node.getText() == "]") {
                            int endPos = this.stackPos;
                            while (endPos >= 0) {
                                if (this.stackTypes[endPos] == 5) {
                                    node.command = EnvDefinitions.ENV_displaymath_END_SHORTHAND;
                                    this.foundEndStackPos = endPos;
                                    this.foundEndNode = node;
                                    this.lexer.consume();
                                    break block17;
                                }
                                --endPos;
                            }
                        }
                        node.texParent = group;
                        children.add(node);
                        this.lexer.consume();
                        textNode = null;
                        break;
                    }
                    if (node.getText() == "(") {
                        Environment.MathLatexShorthand env = new Environment.MathLatexShorthand(group, node);
                        children.add(env);
                        this.lexer.consume();
                        node.command = EnvDefinitions.ENV_math_BEGIN_SHORTHAND;
                        node.texParent = env;
                        this.putToStack((byte)4, null);
                        this.inMath = true;
                        this.parseGroup(env);
                        this.inMath = false;
                        textNode = null;
                        break;
                    }
                    if (node.getText() == "[") {
                        Environment.MathLatexShorthand env = new Environment.MathLatexShorthand(group, node);
                        children.add(env);
                        this.lexer.consume();
                        node.command = EnvDefinitions.ENV_displaymath_BEGIN_SHORTHAND;
                        node.texParent = env;
                        this.putToStack((byte)5, null);
                        this.inMath = true;
                        this.parseGroup(env);
                        this.inMath = false;
                        textNode = null;
                        break;
                    }
                    node.texParent = group;
                    children.add(node);
                    this.lexer.consume();
                    textNode = null;
                    break;
                }
                case 9: {
                    this.wasLinebreak = false;
                    Group.Bracket node = new Group.Bracket(group, this.lexer.getOffset(), this.lexer.getStopOffset());
                    node.startOffset = this.lexer.getOffset();
                    node.endOffset = this.lexer.getStopOffset();
                    children.add(node);
                    this.lexer.consume();
                    this.putToStack((byte)1, null);
                    this.parseGroup(node);
                    node.texParent = group;
                    textNode = null;
                    break;
                }
                case 10: {
                    this.wasLinebreak = false;
                    if (this.stackTypes[this.stackPos] == 1) {
                        this.foundEndStackPos = this.stackPos;
                        this.foundEndOffset = this.lexer.getStopOffset();
                        this.lexer.consume();
                        textNode = null;
                        break block17;
                    }
                    Dummy node = new Dummy();
                    node.status = 8724;
                    node.startOffset = this.lexer.getOffset();
                    node.endOffset = this.lexer.getStopOffset();
                    node.texParent = group;
                    children.add(node);
                    this.lexer.consume();
                    textNode = null;
                    break;
                }
                case 12: {
                    this.wasLinebreak = false;
                    if (this.stackTypes[this.stackPos] == 2) {
                        this.foundEndStackPos = this.stackPos;
                        this.foundEndOffset = this.lexer.getStopOffset();
                        this.lexer.consume();
                        break block17;
                    }
                    if (textNode == null) {
                        textNode = new Text(group, this.lexer.getOffset(), this.lexer.getStopOffset());
                        children.add(textNode);
                        this.lexer.consume();
                        break;
                    }
                    if (textNode == this.whitespace) {
                        textNode = new Text(group, textNode.startOffset, this.lexer.getStopOffset());
                        children.add(textNode);
                        this.lexer.consume();
                        break;
                    }
                    textNode.endOffset = this.lexer.getStopOffset();
                    this.lexer.consume();
                    break;
                }
                case 2: {
                    if (textNode == null) {
                        if (children.size() > 0) {
                            textNode = this.whitespace;
                            textNode.startOffset = this.lexer.getOffset();
                            this.lexer.consume();
                            break;
                        }
                        this.lexer.consume();
                        break;
                    }
                    if (textNode == this.whitespace) {
                        this.lexer.consume();
                        break;
                    }
                    textNode.endOffset = this.lexer.getStopOffset();
                    this.lexer.consume();
                    break;
                }
                case 3: {
                    this.wasLinebreak = false;
                    if (children.isEmpty()) {
                        if (this.stackEndKeys[this.stackPos] == LABEL_TEXT) {
                            Label node = new Label(group, this.lexer.getOffset(), this.lexer.getStopOffset(), this.lexer.getFullText(this.symbolTextFactory));
                            node.startOffset = this.lexer.getOffset();
                            node.endOffset = this.lexer.getStopOffset();
                            node.texParent = group;
                            children.add(node);
                            this.lexer.consume();
                            break;
                        }
                        if (this.stackEndKeys[this.stackPos] == NUM_TEXT) {
                            Text.Num node = new Text.Num(group, this.lexer.getOffset(), this.lexer.getStopOffset(), this.checkNum(this.lexer.getFullText(this.otherTextFactory)));
                            node.startOffset = this.lexer.getOffset();
                            node.endOffset = this.lexer.getStopOffset();
                            node.texParent = group;
                            children.add(node);
                            this.lexer.consume();
                            break;
                        }
                    }
                    if (textNode == null) {
                        textNode = new Text(group, this.lexer.getOffset(), this.lexer.getStopOffset());
                        children.add(textNode);
                        this.lexer.consume();
                        break;
                    }
                    if (textNode == this.whitespace) {
                        textNode = new Text(group, textNode.startOffset, this.lexer.getStopOffset());
                        children.add(textNode);
                        this.lexer.consume();
                        break;
                    }
                    textNode.endOffset = this.lexer.getStopOffset();
                    this.lexer.consume();
                    break;
                }
                case 4: 
                case 11: {
                    this.wasLinebreak = false;
                    if (textNode == null) {
                        textNode = new Text(group, this.lexer.getOffset(), this.lexer.getStopOffset());
                        children.add(textNode);
                        this.lexer.consume();
                        break;
                    }
                    textNode.endOffset = this.lexer.getStopOffset();
                    this.lexer.consume();
                    break;
                }
                case 1: {
                    this.wasLinebreak = true;
                    this.lexer.consume();
                    textNode = null;
                    break;
                }
                case 14: {
                    this.wasLinebreak = false;
                    if (this.inMath) {
                        int endPos = this.stackPos;
                        while (endPos >= 0) {
                            if (this.stackTypes[endPos] == 6) {
                                this.foundEndStackPos = endPos;
                                this.foundEndOffset = this.lexer.getStopOffset();
                                this.lexer.consume();
                                break block17;
                            }
                            --endPos;
                        }
                        if (textNode == null || textNode == this.whitespace) {
                            textNode = new Text(group, this.lexer.getOffset(), this.lexer.getStopOffset());
                            children.add(textNode);
                            this.lexer.consume();
                            break;
                        }
                        textNode.endOffset = this.lexer.getStopOffset();
                        this.lexer.consume();
                        break;
                    }
                    Math.SingleDollar node = new Math.SingleDollar(group, this.lexer.getOffset(), this.lexer.getStopOffset());
                    children.add(node);
                    this.lexer.consume();
                    this.putToStack((byte)6, null);
                    this.inMath = true;
                    this.lexer.setReport$$(false);
                    this.parseGroup(node);
                    this.inMath = false;
                    this.lexer.setReport$$(true);
                    textNode = null;
                    break;
                }
                case 15: {
                    this.wasLinebreak = false;
                    if (this.inMath) {
                        int endPos = this.stackPos;
                        while (endPos >= 0) {
                            if (this.stackTypes[endPos] == 7) {
                                this.foundEndStackPos = endPos;
                                this.foundEndOffset = this.lexer.getStopOffset();
                                this.lexer.consume();
                                break block17;
                            }
                            --endPos;
                        }
                        group.endOffset = this.lexer.getStopOffset();
                        if (textNode == null || textNode == this.whitespace) {
                            textNode = new Text(group, this.lexer.getOffset(), this.lexer.getStopOffset());
                            children.add(textNode);
                            this.lexer.consume();
                            break;
                        }
                        textNode.endOffset = this.lexer.getStopOffset();
                        this.lexer.consume();
                        break;
                    }
                    Math.DoubleDollar node = new Math.DoubleDollar(group, this.lexer.getOffset(), this.lexer.getStopOffset());
                    children.add(node);
                    this.lexer.consume();
                    this.putToStack((byte)7, null);
                    this.inMath = true;
                    this.parseGroup(node);
                    this.inMath = false;
                    textNode = null;
                    break;
                }
                case 16: {
                    this.handleComment();
                    break;
                }
                case 17: {
                    this.wasLinebreak = false;
                    Verbatim node = new Verbatim();
                    node.texParent = group;
                    node.startOffset = this.lexer.getOffset();
                    node.endOffset = this.lexer.getStopOffset();
                    children.add(node);
                    this.lexer.consume();
                    textNode = null;
                    break;
                }
                case 18: {
                    this.wasLinebreak = false;
                    Embedded node = new Embedded(group, this.lexer.getOffset(), this.lexer.getStopOffset(), this.lexer.getText().intern());
                    children.add(node);
                    this.lexer.consume();
                    if (this.embeddedList != null) {
                        this.embeddedList.add(node);
                    }
                    textNode = null;
                    break;
                }
                default: {
                    throw new IllegalStateException("type= " + this.lexer.getType() + ", offset= " + this.lexer.getOffset());
                }
            }
        }
        if (!children.isEmpty()) {
            group.children = children.toArray(new TexAstNode[children.size()]);
        }
        if (this.foundEndStackPos == this.stackPos) {
            group.setEndNode(this.foundEndOffset, this.foundEndNode);
            this.foundEndStackPos = -1;
        } else {
            group.setMissingEnd();
        }
        --this.stackPos;
    }

    private @Nullable TexAstNode createAndParseWord() {
        this.wasLinebreak = false;
        String label = this.lexer.getText(this.symbolTextFactory);
        ControlNode.Word controlNode = new ControlNode.Word(label);
        controlNode.startOffset = this.lexer.getOffset();
        controlNode.endOffset = this.lexer.getStopOffset();
        this.lexer.consume();
        return this.parseWord(controlNode, this.getCommand(label), true);
    }

    private @Nullable TexAstNode parseWord(ControlNode.Word controlNode, @Nullable TexCommand command, boolean exec) {
        List<Argument> arguments;
        if (command == null) {
            if (this.lexer.pop() == 2) {
                this.lexer.consume();
            }
            return controlNode;
        }
        String label = controlNode.getText();
        if (command.supportAsterisk()) {
            this.lexer.setReportAsterisk(true);
            block22: while (true) {
                switch (this.lexer.pop()) {
                    case 2: {
                        this.lexer.consume();
                        continue block22;
                    }
                    case 8: {
                        this.wasLinebreak = false;
                        this.lexer.consume();
                        break block22;
                    }
                }
                break;
            }
            this.lexer.setReportAsterisk(false);
        }
        if (!(arguments = command.getArguments()).isEmpty()) {
            int nextArg = 0;
            ArrayList<Group.Square> children = new ArrayList<Group.Square>();
            block23: while (this.foundEndStackPos < 0 && nextArg < arguments.size()) {
                Argument argument = arguments.get(nextArg);
                boolean optional = (argument.getType() & 2) != 0;
                switch (this.lexer.pop()) {
                    case 2: {
                        this.lexer.consume();
                        break;
                    }
                    case 1: {
                        if (this.wasLinebreak) break block23;
                        this.wasLinebreak = true;
                        this.lexer.consume();
                        break;
                    }
                    case 11: {
                        if (!optional) break block23;
                        this.wasLinebreak = false;
                        Group argNode = new Group.Square(controlNode, this.lexer.getOffset(), this.lexer.getStopOffset());
                        children.add((Group.Square)argNode);
                        this.lexer.consume();
                        this.putToStack((byte)2, argument.getContent());
                        if (argument.getContent() == -15) {
                            this.consumeEmbedGroup(argNode, (TexEmbedCommand)command, nextArg);
                        } else {
                            this.parseGroup(argNode);
                        }
                        controlNode.endOffset = argNode.endOffset;
                        ++nextArg;
                        break;
                    }
                    case 9: {
                        while (optional) {
                            if (++nextArg >= arguments.size()) break block23;
                            argument = arguments.get(nextArg);
                            boolean bl = optional = argument.getType() == 2;
                        }
                        if (argument.getType() != 1) break block23;
                        this.wasLinebreak = false;
                        Group argNode = new Group.Bracket(controlNode, this.lexer.getOffset(), this.lexer.getStopOffset());
                        children.add((Group.Square)argNode);
                        this.lexer.consume();
                        this.putToStack((byte)1, argument.getContent());
                        if (argument.getContent() == -15) {
                            this.consumeEmbedGroup(argNode, (TexEmbedCommand)command, nextArg);
                        } else {
                            this.parseGroup(argNode);
                        }
                        controlNode.endOffset = argNode.endOffset;
                        if (command.getType() == 17) {
                            if (argNode.status != 0 || argNode.children.length != 1 || argNode.children[0].getNodeType() != NodeType.LABEL) break block23;
                            label = argNode.children[0].getText();
                            TexCommand envCommand = this.getEnv(label);
                            if (envCommand != null) {
                                command = envCommand;
                                arguments = command.getArguments();
                            }
                        }
                        ++nextArg;
                        break;
                    }
                    default: {
                        break block23;
                    }
                }
            }
            controlNode.arguments = children.toArray(new TexAstNode[children.size()]);
        }
        controlNode.command = command;
        if (!exec || this.foundEndStackPos >= 0) {
            return controlNode;
        }
        switch (command.getType() & 0xFF) {
            case 50: 
            case 66: {
                if (this.lexer.getType() != 0) break;
                this.lexer.setModeVerbatimEnv(("end{" + label + "}").toCharArray());
                if (this.lexer.next() == 17) {
                    Environment.Word envNode = new Environment.Word(null, controlNode);
                    this.putToStack((byte)3, label);
                    this.parseGroup(envNode);
                    return envNode;
                }
                throw new IllegalStateException();
            }
            case 3: {
                if (this.lexer.getType() != 0) break;
                this.lexer.setModeVerbatimLine();
                if (this.lexer.next() == 17) {
                    Verbatim verbatimNode;
                    this.wasLinebreak = false;
                    switch (this.lexer.getFlags()) {
                        case 1: {
                            controlNode.status = 4370;
                            this.lexer.consume();
                            return controlNode;
                        }
                        case 2: {
                            verbatimNode = new Verbatim();
                            verbatimNode.texParent = controlNode;
                            verbatimNode.status = 8466;
                            verbatimNode.startOffset = this.lexer.getOffset() + 1;
                            verbatimNode.endOffset = controlNode.endOffset = this.lexer.getStopOffset();
                            this.lexer.consume();
                            break;
                        }
                        default: {
                            verbatimNode = new Verbatim();
                            verbatimNode.texParent = controlNode;
                            verbatimNode.startOffset = this.lexer.getOffset() + 1;
                            verbatimNode.endOffset = controlNode.endOffset = this.lexer.getStopOffset() - 1;
                            this.lexer.consume();
                        }
                    }
                    controlNode.arguments = new TexAstNode[]{verbatimNode};
                    return controlNode;
                }
                throw new IllegalStateException();
            }
            case 18: {
                Environment.Word envNode = new Environment.Word(null, controlNode);
                controlNode.texParent = envNode;
                this.putToStack((byte)3, label);
                this.inMath = true;
                this.parseGroup(envNode);
                this.inMath = false;
                return envNode;
            }
            case 17: 
            case 34: 
            case 114: 
            case 130: 
            case 242: {
                if (label != null && !label.equals("begin")) {
                    Environment.Word envNode = new Environment.Word(null, controlNode);
                    controlNode.texParent = envNode;
                    this.putToStack((byte)3, label);
                    this.parseGroup(envNode);
                    return envNode;
                }
                controlNode.status = 4369;
                return controlNode;
            }
            case 33: {
                if (controlNode.arguments.length == 1) {
                    Group argNode = (Group)controlNode.arguments[0];
                    if (argNode.status == 0 && argNode.children.length == 1 && argNode.children[0].getNodeType() == NodeType.LABEL) {
                        label = argNode.children[0].getText();
                        if (label != null) {
                            int endPos = this.stackPos;
                            while (endPos >= 0) {
                                if (label.equals(this.stackEndKeys[endPos])) {
                                    this.foundEndStackPos = endPos;
                                    this.foundEndNode = controlNode;
                                    return null;
                                }
                                --endPos;
                            }
                        }
                        controlNode.status = 8721;
                    }
                }
                controlNode.status = 4369;
                return controlNode;
            }
            case 52: {
                if (controlNode.arguments.length > 0) {
                    this.parseDef(controlNode, command);
                }
                return controlNode;
            }
        }
        return controlNode;
    }

    private @Nullable String checkNum(String text) {
        if (text.isEmpty()) {
            return null;
        }
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (c < '0' || c > '9') {
                return null;
            }
            ++i;
        }
        return text;
    }

    private void parseDef(ControlNode node, TexCommand command) {
        Map<String, TexCommand> map;
        String controlWord;
        boolean type;
        switch (command.getType() & 0xFFF) {
            case 308: {
                type = false;
                break;
            }
            case 564: {
                type = true;
                break;
            }
            default: {
                return;
            }
        }
        TexAstNode[] argNodes = TexAsts.resolveArguments(node);
        if (argNodes[0] == null || argNodes[0].status != 0 || argNodes[0].getChildCount() != 1) {
            return;
        }
        TexAstNode argNode = argNodes[0].getChild(0);
        switch (argNode.getNodeType()) {
            case LABEL: {
                if (type && !(controlWord = ((Label)argNode).getText()).isEmpty()) break;
                return;
            }
            case CONTROL: {
                controlWord = ((ControlNode)argNode).getText();
                if (!controlWord.isEmpty()) break;
                return;
            }
            default: {
                return;
            }
        }
        int optionalArgs = 0;
        int requiredArgs = 0;
        if (argNodes[1] != null && argNodes[1].status == 0 && argNodes[1].getChildCount() == 1 && (argNode = argNodes[1].getChild(0)).getNodeType() == NodeType.TEXT && argNode.getText() != null) {
            try {
                requiredArgs = Integer.parseInt(argNode.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (argNodes[2] != null && argNodes[2].status == 0) {
            optionalArgs = 1;
            --requiredArgs;
        }
        if (requiredArgs < 0) {
            requiredArgs = 0;
        }
        Object[] args = new Argument[optionalArgs + requiredArgs];
        int i = 0;
        while (optionalArgs-- > 0) {
            args[i++] = new Argument(2, 0);
        }
        while (requiredArgs-- > 0) {
            args[i++] = new Argument(1, 0);
        }
        if (type) {
            map = this.customEnvs;
            if (map == null) {
                this.customEnvs = map = new HashMap<String, TexCommand>();
            }
        } else {
            map = this.customCommands;
            if (map == null) {
                map = new HashMap<String, TexCommand>();
                this.customCommands = map;
            }
        }
        map.put(controlWord, new TexCommand(0, controlWord, false, (List<Argument>)ImCollections.newList((Object[])args), "(custom)"));
    }

    private void handleComment() {
        this.wasLinebreak = false;
        this.lexer.consume();
    }

    private void consumeEmbedGroup(ContainerNode group, TexEmbedCommand command, int argIdx) {
        byte s;
        Embedded.Inline embedded = new Embedded.Inline((TexAstNode)group, this.lexer.getStopOffset(), command.getEmbeddedType(argIdx));
        this.wasLinebreak = false;
        CustomScanner scanner = command.getArgumentScanner(argIdx);
        byte by = s = scanner != null ? scanner.consume(this.lexer) : this.consumeEmbeddedDefault();
        if (s == 0) {
            s = this.lexer.pop();
        }
        switch (s) {
            case -1: {
                this.foundEndStackPos = 0;
                this.foundEndNode = null;
                break;
            }
            case 1: {
                break;
            }
            case 10: {
                if (this.stackTypes[this.stackPos] != 1) break;
                this.foundEndStackPos = this.stackPos;
                this.foundEndOffset = this.lexer.getStopOffset();
                break;
            }
            case 12: {
                if (this.stackTypes[this.stackPos] != 2) break;
                this.foundEndStackPos = this.stackPos;
                this.foundEndOffset = this.lexer.getStopOffset();
                break;
            }
        }
        embedded.endOffset = this.lexer.getOffset();
        group.children = new TexAstNode[]{embedded};
        if (this.embeddedList != null) {
            this.embeddedList.add(embedded);
        }
        if (this.foundEndStackPos == this.stackPos) {
            group.setEndNode(this.foundEndOffset, this.foundEndNode);
            this.foundEndStackPos = -1;
        } else {
            group.setMissingEnd();
        }
        --this.stackPos;
    }

    public byte consumeEmbeddedDefault() {
        int c;
        byte endReturn;
        int endChar;
        TextParserInput input = this.lexer.getInput();
        this.lexer.consume(true);
        switch (this.stackTypes[this.stackPos]) {
            case 2: {
                endChar = 93;
                endReturn = 10;
                break;
            }
            case 1: {
                endChar = 125;
                endReturn = 12;
                break;
            }
            default: {
                throw new IllegalStateException("stateType= " + this.stackTypes[this.stackPos]);
            }
        }
        int offset = 0;
        do {
            if ((c = input.get(offset++)) >= 32) continue;
            input.consume(offset - 1);
            this.lexer.consume(true);
            return 0;
        } while (c != endChar);
        input.consume(offset);
        this.lexer.consume(true);
        return endReturn;
    }

    public static class TaskConfig {
        public TexCommandSet commandSet;
        public @Nullable Map<String, TexCommand> additionalCommands;
        public @Nullable Map<String, TexCommand> additionalEnvs;

        public TaskConfig(TexCommandSet commandSet) {
            this.commandSet = (TexCommandSet)ObjectUtils.nonNullAssert((Object)commandSet);
        }
    }
}

