/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.util;

import org.eclipse.statet.jcommons.collections.ImCollection;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;

@NonNullByDefault
public final class StringUtils {
    private static final byte[] U_DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};

    public static String formatCodePoint(int cp) {
        int nDigits = Math.max((39 - Integer.numberOfLeadingZeros(cp)) / 8 * 2, 4);
        byte[] latin1 = new byte[2 + nDigits];
        latin1[0] = 85;
        latin1[1] = 43;
        int i = latin1.length;
        do {
            latin1[--i] = U_DIGITS[cp & 0xF];
            cp >>>= 4;
        } while (i > 2);
        return new String(latin1, 0, 0, latin1.length);
    }

    /*
     * Unable to fully structure code
     */
    public static int firstIndexOfNonTrim(String s, int start, int end) {
        if (start >= 0 && end <= s.length()) ** GOTO lbl4
        throw new StringIndexOutOfBoundsException();
lbl-1000:
        // 1 sources

        {
            ++start;
lbl4:
            // 2 sources

            ** while (start < end && s.charAt((int)start) <= ' ')
        }
lbl5:
        // 1 sources

        return start;
    }

    public static int firstIndexOfNonTrim(String s) {
        int start = 0;
        int end = s.length();
        while (start < end && s.charAt(start) <= ' ') {
            ++start;
        }
        return start;
    }

    /*
     * Unable to fully structure code
     */
    public static int lastIndexOfNonTrim(String s, int start, int end) {
        if (start >= 0 && end <= s.length()) ** GOTO lbl4
        throw new StringIndexOutOfBoundsException();
lbl-1000:
        // 1 sources

        {
            --end;
lbl4:
            // 2 sources

            ** while (start < end && s.charAt((int)(end - 1)) <= ' ')
        }
lbl5:
        // 1 sources

        return end;
    }

    public static int lastIndexOfNonTrim(String s) {
        int end = s.length();
        while (end > 0 && s.charAt(end - 1) <= ' ') {
            --end;
        }
        return end;
    }

    /*
     * Unable to fully structure code
     */
    public static String trim(String s, int start, int end) {
        if (start < 0 || end > s.length()) {
            throw new StringIndexOutOfBoundsException();
        }
        if (start != 0 || end != s.length()) ** GOTO lbl6
        return s.trim();
lbl-1000:
        // 1 sources

        {
            ++start;
lbl6:
            // 2 sources

            ** while (start < end && s.charAt((int)start) <= ' ')
        }
lbl7:
        // 2 sources

        while (start < end && s.charAt(end - 1) <= ' ') {
            --end;
        }
        return s.substring(start, end);
    }

    public static boolean isTrimEmpty(String s) {
        int start = 0;
        int end = s.length();
        while (start < end && s.charAt(start) <= ' ') {
            ++start;
        }
        return start == end;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isTrimEmpty(String s, int start, int end) {
        if (start >= 0 && end <= s.length()) ** GOTO lbl4
        throw new StringIndexOutOfBoundsException();
lbl-1000:
        // 1 sources

        {
            ++start;
lbl4:
            // 2 sources

            ** while (start < end && s.charAt((int)start) <= ' ')
        }
lbl5:
        // 1 sources

        return start == end;
    }

    public static boolean containsAny(String s, ImCollection<String> searchStrings) {
        String prevString = null;
        for (String searchString : searchStrings) {
            if (prevString != null && searchString.startsWith(prevString)) continue;
            prevString = searchString;
            if (s.indexOf(searchString) < 0) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAny(StringBuilder s, ImCollection<String> searchStrings) {
        String prevString = null;
        for (String searchString : searchStrings) {
            if (prevString != null && searchString.startsWith(prevString)) continue;
            prevString = searchString;
            if (s.indexOf(searchString) < 0) continue;
            return true;
        }
        return false;
    }

    public static int firstIndexOfAny(String s, ImCollection<String> searchStrings, int fromIndex) {
        if (fromIndex < 0 || fromIndex > s.length()) {
            throw new StringIndexOutOfBoundsException(fromIndex);
        }
        int matchIndex = Integer.MAX_VALUE;
        String prevString = null;
        for (String searchString : searchStrings) {
            if (prevString != null && searchString.startsWith(prevString)) continue;
            prevString = searchString;
            int index = s.indexOf(searchString, fromIndex);
            if (index < 0 || index >= matchIndex) continue;
            matchIndex = index;
        }
        return matchIndex != Integer.MAX_VALUE ? matchIndex : -1;
    }

    public static int firstIndexOfAny(String s, ImCollection<String> searchStrings) {
        int matchIndex = Integer.MAX_VALUE;
        String prevString = null;
        for (String searchString : searchStrings) {
            if (prevString != null && searchString.startsWith(prevString)) continue;
            prevString = searchString;
            int index = s.indexOf(searchString);
            if (index < 0 || index >= matchIndex) continue;
            matchIndex = index;
        }
        return matchIndex != Integer.MAX_VALUE ? matchIndex : -1;
    }

    public static int firstIndexOfAny(StringBuilder s, ImCollection<String> searchStrings, int fromIndex) {
        if (fromIndex < 0 || fromIndex > s.length()) {
            throw new StringIndexOutOfBoundsException(fromIndex);
        }
        int matchIndex = Integer.MAX_VALUE;
        String prevString = null;
        for (String searchString : searchStrings) {
            if (prevString != null && searchString.startsWith(prevString)) continue;
            prevString = searchString;
            int index = s.indexOf(searchString, fromIndex);
            if (index < 0 || index >= matchIndex) continue;
            matchIndex = index;
        }
        return matchIndex != Integer.MAX_VALUE ? matchIndex : -1;
    }

    public static int firstIndexOfAny(StringBuilder s, ImCollection<String> searchStrings) {
        int matchIndex = Integer.MAX_VALUE;
        String prevString = null;
        for (String searchString : searchStrings) {
            if (prevString != null && searchString.startsWith(prevString)) continue;
            prevString = searchString;
            int index = s.indexOf(searchString);
            if (index < 0 || index >= matchIndex) continue;
            matchIndex = index;
        }
        return matchIndex != Integer.MAX_VALUE ? matchIndex : -1;
    }

    public static @Nullable Match firstMatchOfAny(String s, ImCollection<String> searchStrings, int fromIndex) {
        if (fromIndex < 0 || fromIndex > s.length()) {
            throw new StringIndexOutOfBoundsException(fromIndex);
        }
        String matchString = null;
        int matchIndex = Integer.MAX_VALUE;
        String prevString = null;
        boolean prevMatch = false;
        for (String searchString : searchStrings) {
            if (prevString != null && searchString.startsWith(prevString)) {
                if (!prevMatch || !s.startsWith(searchString, matchIndex)) continue;
                matchString = prevString = searchString;
                continue;
            }
            int index = s.indexOf(searchString, fromIndex);
            prevMatch = index >= 0 && (index < matchIndex || index == matchIndex && searchString.length() > matchString.length());
            if (prevMatch) {
                matchString = searchString;
                matchIndex = index;
            }
            prevString = searchString;
        }
        return matchString != null ? new Match(matchString, matchIndex) : null;
    }

    public static @Nullable Match firstMatchOfAny(String s, ImCollection<String> searchStrings) {
        String matchString = null;
        int matchIndex = Integer.MAX_VALUE;
        String prevString = null;
        boolean prevMatch = false;
        for (String searchString : searchStrings) {
            if (prevString != null && searchString.startsWith(prevString)) {
                if (!prevMatch || !s.startsWith(searchString, matchIndex)) continue;
                matchString = searchString;
                continue;
            }
            int index = s.indexOf(searchString);
            prevMatch = index >= 0 && (index < matchIndex || index == matchIndex && searchString.length() > matchString.length());
            if (prevMatch) {
                matchString = searchString;
                matchIndex = index;
            }
            prevString = searchString;
        }
        return matchString != null ? new Match(matchString, matchIndex) : null;
    }

    public static @Nullable Match firstMatchOfAny(StringBuilder s, ImCollection<String> searchStrings, int fromIndex) {
        if (fromIndex < 0 || fromIndex > s.length()) {
            throw new StringIndexOutOfBoundsException(fromIndex);
        }
        String matchString = null;
        int matchIndex = Integer.MAX_VALUE;
        String prevString = null;
        boolean prevMatch = false;
        for (String searchString : searchStrings) {
            if (prevString != null && searchString.startsWith(prevString)) {
                if (!prevMatch || matchIndex + searchString.length() > s.length() || !s.substring(matchIndex, matchIndex + searchString.length()).equals(searchString)) continue;
                matchString = prevString = searchString;
                continue;
            }
            int index = s.indexOf(searchString, fromIndex);
            prevMatch = index >= 0 && (index < matchIndex || index == matchIndex && searchString.length() > matchString.length());
            if (prevMatch) {
                matchString = searchString;
                matchIndex = index;
            }
            prevString = searchString;
        }
        return matchString != null ? new Match(matchString, matchIndex) : null;
    }

    public static @Nullable Match firstMatchOfAny(StringBuilder s, ImCollection<String> searchStrings) {
        String matchString = null;
        int matchIndex = Integer.MAX_VALUE;
        String prevString = null;
        boolean prevMatch = false;
        for (String searchString : searchStrings) {
            if (prevString != null && searchString.startsWith(prevString)) {
                if (!prevMatch || matchIndex + searchString.length() > s.length() || !s.substring(matchIndex, matchIndex + searchString.length()).equals(searchString)) continue;
                matchString = prevString = searchString;
                continue;
            }
            int index = s.indexOf(searchString);
            prevMatch = index >= 0 && (index < matchIndex || index == matchIndex && searchString.length() > matchString.length());
            if (prevMatch) {
                matchString = searchString;
                matchIndex = index;
            }
            prevString = searchString;
        }
        return matchString != null ? new Match(matchString, matchIndex) : null;
    }

    private StringUtils() {
    }

    public static final class Match {
        private final String string;
        private final int startIndex;

        public Match(String string, int startIndex) {
            this.string = ObjectUtils.nonNullAssert(string);
            this.startIndex = startIndex;
        }

        public String getString() {
            return this.string;
        }

        public int getStartIndex() {
            return this.startIndex;
        }

        public int getEndIndex() {
            return this.startIndex + this.string.length();
        }

        public int getLength() {
            return this.string.length();
        }
    }
}

