/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.datafilter;

import java.util.Collection;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.statet.internal.r.ui.datafilter.FilterSet;
import org.eclipse.statet.internal.r.ui.datafilter.FilterType;
import org.eclipse.statet.internal.r.ui.datafilter.Messages;
import org.eclipse.statet.internal.r.ui.datafilter.TextVariableFilter;
import org.eclipse.statet.internal.r.ui.datafilter.VariableFilter;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.r.core.RUtil;
import org.eclipse.statet.r.ui.dataeditor.RDataTableColumn;
import org.eclipse.statet.rj.data.RDataUtils;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.UnexpectedRDataException;
import org.eclipse.statet.rj.services.FunctionCall;
import org.eclipse.statet.rj.ts.core.RToolService;

public class LevelVariableFilter
extends VariableFilter {
    private RStore availableValues = NO_VALUES;
    private final IObservableSet<Object> selectedValues;

    public LevelVariableFilter(FilterSet set, RDataTableColumn column) {
        super(set, column);
        this.selectedValues = new WritableSet(set.getRealm());
        this.registerObservable((IObservable)this.selectedValues);
    }

    @Override
    public FilterType getType() {
        return FilterType.LEVEL;
    }

    @Override
    public void load(VariableFilter filter) {
        if (filter.getType() == FilterType.LEVEL) {
            final LevelVariableFilter levelFilter = (LevelVariableFilter)filter;
            this.runInRealm(new Runnable(){

                @Override
                public void run() {
                    LevelVariableFilter.this.selectedValues.addAll((Collection)levelFilter.getSelectedValues());
                }
            });
        } else if (filter.getType() == FilterType.TEXT) {
            final TextVariableFilter textFilter = (TextVariableFilter)filter;
            this.runInRealm(new Runnable(){

                @Override
                public void run() {
                    LevelVariableFilter.this.selectedValues.addAll(textFilter.getSelectedValues());
                }
            });
        }
    }

    @Override
    public void reset() {
        this.runInRealm(new Runnable(){

            @Override
            public void run() {
                LevelVariableFilter.this.selectedValues.clear();
            }
        });
    }

    @Override
    protected void update(RToolService r, ProgressMonitor m) throws StatusException, UnexpectedRDataException {
        RDataTableColumn column = this.getColumn();
        FunctionCall fcall = r.createFunctionCall("rj:::.getDataLevelValues");
        fcall.add(column.getRExpression());
        fcall.addInt("max", 1000);
        RObject data = fcall.evalData(m);
        if (data.getRObjectType() == 1) {
            this.setError(Messages.LevelFilter_TooMuch_message);
            return;
        }
        RDataUtils.checkRVector((RObject)data);
        if (column.getDataStore().getStoreType() == 10) {
            this.setValues(RDataUtils.checkData((RStore)data.getData(), (byte)5));
        } else {
            this.setValues(RDataUtils.checkData((RStore)data.getData(), (byte)column.getDataStore().getStoreType()));
        }
    }

    @Override
    protected void setError(final String message) {
        this.runInRealm(new Runnable(){

            @Override
            public void run() {
                LevelVariableFilter.this.availableValues = (RStore)NO_VALUES;
                LevelVariableFilter.super.setError(message);
                LevelVariableFilter.this.notifyListeners();
            }
        });
    }

    protected void setValues(final RStore values) {
        this.runInRealm(new Runnable(){

            @Override
            public void run() {
                if (!LevelVariableFilter.this.availableValues.equals(values) || LevelVariableFilter.this.getError() != null) {
                    LevelVariableFilter.this.availableValues = values;
                    LevelVariableFilter.super.setError(null);
                    LevelVariableFilter.this.notifyListeners();
                }
            }
        });
    }

    @Override
    protected String createFilter(String varExpression) {
        return LevelVariableFilter.createLevelFilter(this.availableValues, this.selectedValues, varExpression);
    }

    static String createLevelFilter(RStore availableValues, Collection<?> selectedValues, String varExpression) {
        if (availableValues == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        int num = 0;
        int na = 0;
        int i = 0;
        while ((long)i < availableValues.getLength()) {
            Object element = availableValues.get(i);
            if (element == null) {
                na = selectedValues.contains(element) ? 1 : -1;
            } else if (selectedValues.contains(element)) {
                if (num > 0) {
                    sb.append(" | ");
                }
                sb.append(varExpression);
                sb.append(" == ");
                if (element instanceof String) {
                    sb.append('\"').append(RUtil.escapeCompletely((String)((String)element))).append('\"');
                } else {
                    sb.append(element);
                }
                ++num;
            }
            ++i;
        }
        if (num > 0 || na == 1) {
            if (na >= 0) {
                if (num > 0) {
                    sb.append(" | ");
                }
                sb.append("is.na(").append(varExpression).append(')');
            } else {
                if (num > 0) {
                    sb.insert(0, '(');
                    sb.append(')');
                    sb.append(" & ");
                }
                sb.append("!is.na(").append(varExpression).append(')');
            }
            if (na == 1) {
                ++num;
            }
        }
        sb.append(')');
        return sb.length() <= 2 || (long)num == availableValues.getLength() ? "" : sb.toString();
    }

    public RStore getAvailableValues() {
        return this.availableValues;
    }

    public IObservableSet getSelectedValues() {
        return this.selectedValues;
    }
}

