/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.statet.ecommons.preferences.AbstractPreferencesModelObject;
import org.eclipse.statet.ecommons.preferences.PreferencesManageListener;
import org.eclipse.statet.ecommons.preferences.PreferencesUtil;
import org.eclipse.statet.ecommons.preferences.SettingsChangeNotifier;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.preferences.core.util.PreferenceUtils;
import org.eclipse.statet.ecommons.text.ui.settings.TextStyleManager;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.ecommons.ui.util.ImageDescriptorRegistry;
import org.eclipse.statet.ecommons.ui.util.ImageRegistryUtil;
import org.eclipse.statet.internal.r.ui.RIdentifierGroups;
import org.eclipse.statet.internal.r.ui.editors.RDocumentProvider;
import org.eclipse.statet.internal.r.ui.editors.RFragmentDocumentProvider;
import org.eclipse.statet.internal.r.ui.editors.RdDocumentProvider;
import org.eclipse.statet.internal.r.ui.graphics.ShowGraphicViewListener;
import org.eclipse.statet.internal.r.ui.wizards.RPkgTemplateContextType;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.ltk.ui.LTKUIPreferences;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssistComputerRegistry;
import org.eclipse.statet.ltk.ui.sourceediting.assist.InfoHoverRegistry;
import org.eclipse.statet.ltk.ui.templates.EnhTemplateStore;
import org.eclipse.statet.ltk.ui.util.CombinedPreferenceStore;
import org.eclipse.statet.nico.core.NicoCore;
import org.eclipse.statet.r.codegeneration.RCodeTemplateContextType;
import org.eclipse.statet.r.codegeneration.RdCodeTemplateContextType;
import org.eclipse.statet.r.ui.editors.REditorOptions;
import org.eclipse.statet.r.ui.editors.templates.REditorTemplateContextType;
import org.eclipse.statet.rj.eclient.graphics.ERGraphicsManager;
import org.eclipse.statet.rj.eclient.graphics.comclient.ERGraphicFactory;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class RUIPlugin
extends AbstractUIPlugin {
    public static final int INTERNAL_ERROR = 100;
    public static final int IO_ERROR = 101;
    public static final String IMG_WIZBAN_NEWRDFILE = "org.eclipse.statet.r.ui/image/wizban/new.rd-file";
    public static final String IMG_WIZBAN_NEWRFILE = "org.eclipse.statet.r.ui/image/wizban/new.r-file";
    public static final String IMG_WIZBAN_NEW_RPROJECT = "org.eclipse.statet.r.ui/image/wizban/new.r_project";
    public static final String IMG_WIZBAN_NEW_RPKGPROJECT = "org.eclipse.statet.r.ui/image/wizban/new.rpkg_project";
    public static final String IMG_LOCTOOL_FILTER_GENERAL = "org.eclipse.statet.r.ui/image/ltool/filter.general";
    public static final String IMG_LOCTOOL_FILTER_LOCAL = "org.eclipse.statet.r.ui/image/ltool/filter.local";
    public static final String IMG_LOCTOOL_REFRESH_RECOMMENDED = "org.eclipse.statet.r.ui/image/ltool/refresh.recommended";
    private static final String R_CODE_TEMPLATES_KEY = "RCodeGen.templates";
    private static final String RD_CODE_TEMPLATES_KEY = "RdCodeGen.templates";
    private static final String RPKG_CODE_TEMPLATES_KEY = "RPkgCodeGen.templates";
    private static final String R_EDITOR_TEMPLATES_KEY = "REditor.templates";
    private static RUIPlugin instance;
    private boolean started;
    private ImageDescriptorRegistry imageDescriptorRegistry;
    private IPreferenceStore editorPreferenceStore;
    private RDocumentProvider rDocumentProvider;
    private RFragmentDocumentProvider rFragmentDocumentProvider;
    private RdDocumentProvider rdDocumentProvider;
    private TextStyleManager rTextStyles;
    private TextStyleManager rdTextStyles;
    private RIdentifierGroups identifierGroups;
    private REditorOptions editorSettings;
    private REditorOptions consoleSettings;
    private List<PreferencesManageListener> prefUpdaters;
    private TemplateStore rCodeTemplatesStore;
    private ContextTypeRegistry rCodeTemplatesContextTypeRegistry;
    private TemplateStore rdCodeTemplatesStore;
    private ContextTypeRegistry rdCodeTemplatesContextTypeRegistry;
    private TemplateStore rPkgCodeTemplatesStore;
    private ContextTypeRegistry rPkgCodeTemplatesContextTypeRegistry;
    private EnhTemplateStore rEditorTemplatesStore;
    private ContextTypeRegistry rEditorContextTypeRegistry;
    private ContentAssistComputerRegistry rConsoleContentAssistRegistry;
    private ContentAssistComputerRegistry rEditorContentAssistRegistry;
    private InfoHoverRegistry rEditorInfoHoverRegistry;
    private ERGraphicFactory commonRGraphicFactory;
    private List<Disposable> disposables;

    public static boolean isSearchPlugInActivated() {
        return Platform.getBundle((String)"org.eclipse.search").getState() == 32;
    }

    public static RUIPlugin getInstance() {
        return instance;
    }

    public static final void log(IStatus status) {
        RUIPlugin plugin = RUIPlugin.getInstance();
        if (plugin != null) {
            plugin.getLog().log(status);
        }
    }

    public static void logError(int code, String message, Throwable e) {
        RUIPlugin.log((IStatus)new Status(4, "org.eclipse.statet.r.ui", code, message, e));
    }

    public static void logError(String message, Throwable e) {
        RUIPlugin.log((IStatus)new Status(4, "org.eclipse.statet.r.ui", message, e));
    }

    public RUIPlugin() {
        instance = this;
    }

    public void start(BundleContext context) throws Exception {
        this.prefUpdaters = new ArrayList<PreferencesManageListener>();
        this.disposables = new ArrayList<Disposable>();
        super.start(context);
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        try {
            RUIPlugin rUIPlugin = this;
            synchronized (rUIPlugin) {
                this.started = false;
                this.imageDescriptorRegistry = null;
            }
            for (Disposable d : this.disposables) {
                try {
                    d.dispose();
                }
                catch (Throwable e) {
                    RUIPlugin.logError("Error occured when dispose module", e);
                }
            }
            this.disposables = null;
            this.rDocumentProvider = null;
            this.rdDocumentProvider = null;
            this.editorPreferenceStore = null;
            this.rCodeTemplatesStore = null;
            this.rCodeTemplatesContextTypeRegistry = null;
            this.rdCodeTemplatesStore = null;
            this.rdCodeTemplatesContextTypeRegistry = null;
            this.rPkgCodeTemplatesStore = null;
            this.rPkgCodeTemplatesContextTypeRegistry = null;
            this.rEditorTemplatesStore = null;
            this.rEditorContextTypeRegistry = null;
            this.rEditorContentAssistRegistry = null;
            this.rConsoleContentAssistRegistry = null;
            this.rEditorInfoHoverRegistry = null;
            Iterator<PreferencesManageListener> iter = this.prefUpdaters.iterator();
            while (iter.hasNext()) {
                iter.next().dispose();
            }
            this.prefUpdaters.clear();
        }
        finally {
            instance = null;
            super.stop(context);
        }
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        ImageRegistryUtil util = new ImageRegistryUtil((AbstractUIPlugin)this);
        util.register(IMG_WIZBAN_NEW_RPROJECT, "wizban", "new-r_project.png");
        util.register(IMG_WIZBAN_NEW_RPKGPROJECT, "wizban", "new-rpkg_project.png");
        util.register(IMG_WIZBAN_NEWRFILE, "wizban", "new_r-file.png");
        util.register(IMG_WIZBAN_NEWRDFILE, "wizban", "new_rd-file.png");
        util.register("org.eclipse.statet.r.ui/image/obj/r_script", "obj_16", "r-file_obj.gif");
        util.register("org.eclipse.statet.r.ui/image/obj/r_environment", "obj_16", "r_env.png");
        util.register("org.eclipse.statet.r.ui/image/obj/r_environment.remote", "obj_16", "r_env-remote.png");
        util.register("org.eclipse.statet.r.ui/image/obj/r_package", "obj_16", "package.png");
        util.register("org.eclipse.statet.r.ui/image/obj/r_package-notavail", "obj_16", "package-nota.png");
        util.register("org.eclipse.statet.r.ui.rhelp/image/obj/Page", "obj_16", "rhelp-page.png");
        util.register("org.eclipse.statet.r.ui.rhelp/image/obj/Page.internal", "obj_16", "rhelp-page-internal.png");
        util.register("org.eclipse.statet.r.ui.rhelp/image/obj/Topic", "obj_16", "rhelp-topic.png");
        util.register("org.eclipse.statet.r.ui.rhelp/image/obj/Topic.internal", "obj_16", "rhelp-topic-internal.png");
        util.register("org.eclipse.statet.r.ui.rhelp/image/obj/Search", "tool_16", "rhelp-search.png");
        util.register("org.eclipse.statet.r.ui.rhelp/image/view/RHelp", "view_16", "rhelp.png");
        util.register("org.eclipse.statet.r.ui/image/obj/function.common", "obj_16", "function.png");
        util.register("org.eclipse.statet.r.ui/image/obj/function.common.local", "obj_16", "function-local.png");
        util.register("org.eclipse.statet.r.ui/image/obj/function.generic", "obj_16", "generic_function.png");
        util.register("org.eclipse.statet.r.ui/image/obj/method", "obj_16", "method.png");
        util.register("org.eclipse.statet.r.ui/image/obj/variable.common", "obj_16", "var.png");
        util.register("org.eclipse.statet.r.ui/image/obj/variable.common.local", "obj_16", "var-local.png");
        util.register("org.eclipse.statet.r.ui/image/obj/variable.slot", "obj_16", "slot.png");
        util.register("org.eclipse.statet.r.ui/image/obj/packageenv", "obj_16", "packageenv.png");
        util.register("org.eclipse.statet.r.ui/image/obj/globalenv", "obj_16", "globalenv.png");
        util.register("org.eclipse.statet.r.ui/image/obj/emptyenv", "obj_16", "emptyenv.png");
        util.register("org.eclipse.statet.r.ui/image/obj/otherenv", "obj_16", "otherenv.png");
        util.register("org.eclipse.statet.r.ui/image/obj/dataframe", "obj_16", "dataframe.png");
        util.register("org.eclipse.statet.r.ui/image/obj/datastore", "obj_16", "dataframe_col.png");
        util.register("org.eclipse.statet.r.ui/image/obj/list", "obj_16", "list.png");
        util.register("org.eclipse.statet.r.ui/image/obj/vector", "obj_16", "vector.png");
        util.register("org.eclipse.statet.r.ui/image/obj/array", "obj_16", "array.png");
        util.register("org.eclipse.statet.r.ui/image/obj/s4obj", "obj_16", "s4obj.png");
        util.register("org.eclipse.statet.r.ui/image/obj/s4obj.vector", "obj_16", "s4obj-vector.png");
        util.register("org.eclipse.statet.r.ui/image/obj/s4obj.dataframe_col", "obj_16", "s4obj-dataframe_col.png");
        util.register("org.eclipse.statet.r.ui/image/obj/null", "obj_16", "null.png");
        util.register("org.eclipse.statet.r.ui/image/obj/missing", "obj_16", "missing.png");
        util.register("org.eclipse.statet.r.ui/image/obj/promise", "obj_16", "promise.png");
        util.register("org.eclipse.statet.r.ui/image/obj/argument.assign", "obj_16", "arg-assign.png");
        util.register("org.eclipse.statet.r.ui/image/obj/col.logi", "obj_16", "col-logi.png");
        util.register("org.eclipse.statet.r.ui/image/obj/col.int", "obj_16", "col-int.png");
        util.register("org.eclipse.statet.r.ui/image/obj/col.num", "obj_16", "col-num.png");
        util.register("org.eclipse.statet.r.ui/image/obj/col.cplx", "obj_16", "col-cplx.png");
        util.register("org.eclipse.statet.r.ui/image/obj/col.char", "obj_16", "col-char.png");
        util.register("org.eclipse.statet.r.ui/image/obj/col.raw", "obj_16", "col-raw.png");
        util.register("org.eclipse.statet.r.ui/image/obj/col.factor", "obj_16", "col-factor.png");
        util.register("org.eclipse.statet.r.ui/image/obj/col.date", "obj_16", "col-date.png");
        util.register("org.eclipse.statet.r.ui/image/obj/col.datetime", "obj_16", "col-datetime.png");
        util.register("org.eclipse.statet.r.ui/image/obj/library.group", "obj_16", "library.png");
        util.register("org.eclipse.statet.r.ui/image/obj/library.location", "obj_16", "package_folder.png");
        util.register(IMG_LOCTOOL_FILTER_GENERAL, "loctool_16", "filter-general.png");
        util.register(IMG_LOCTOOL_FILTER_LOCAL, "loctool_16", "filter-local.png");
        util.register("org.eclipse.statet.r.ui/image/obj/sort.package", "loctool_16", "sort-package.png");
        util.register(IMG_LOCTOOL_REFRESH_RECOMMENDED, "loctool_16", "refresh-rec.png");
    }

    public synchronized ImageDescriptorRegistry getImageDescriptorRegistry() {
        if (this.imageDescriptorRegistry == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.imageDescriptorRegistry = new ImageDescriptorRegistry();
            this.registerPluginDisposable((Disposable)this.imageDescriptorRegistry);
        }
        return this.imageDescriptorRegistry;
    }

    public synchronized RDocumentProvider getRDocumentProvider() {
        if (this.rDocumentProvider == null) {
            this.rDocumentProvider = new RDocumentProvider();
            this.disposables.add(this.rDocumentProvider);
        }
        return this.rDocumentProvider;
    }

    public synchronized RFragmentDocumentProvider getRFragmentDocumentProvider() {
        if (this.rFragmentDocumentProvider == null) {
            this.rFragmentDocumentProvider = new RFragmentDocumentProvider();
        }
        return this.rFragmentDocumentProvider;
    }

    public synchronized RdDocumentProvider getRdDocumentProvider() {
        if (this.rdDocumentProvider == null) {
            this.rdDocumentProvider = new RdDocumentProvider();
        }
        return this.rdDocumentProvider;
    }

    public IPreferenceStore getEditorPreferenceStore() {
        if (this.editorPreferenceStore == null) {
            this.editorPreferenceStore = CombinedPreferenceStore.createStore((IPreferenceStore[])new IPreferenceStore[]{this.getPreferenceStore(), LTKUIPreferences.getPreferenceStore(), EditorsUI.getPreferenceStore()});
        }
        return this.editorPreferenceStore;
    }

    public synchronized RIdentifierGroups getRIdentifierGroups() {
        if (this.identifierGroups == null) {
            this.identifierGroups = new RIdentifierGroups();
            this.prefUpdaters.add(new PreferencesManageListener((AbstractPreferencesModelObject)this.identifierGroups, PreferenceUtils.getInstancePrefs(), "r.editor/identifiergroups"));
        }
        return this.identifierGroups;
    }

    public synchronized REditorOptions getREditorSettings(PreferenceAccess prefs) {
        ImList contexts = prefs.getPreferenceContexts();
        for (IScopeContext context : contexts) {
            if (context.getName().equals("nico.instance")) {
                if (this.consoleSettings == null) {
                    this.consoleSettings = new REditorOptions(1);
                    this.prefUpdaters.add(new PreferencesManageListener((AbstractPreferencesModelObject)this.consoleSettings, NicoCore.getInstanceConsolePreferences(), "r/r.editor/smartinsert"));
                }
                return this.consoleSettings;
            }
            if (!context.getName().equals("instance")) continue;
            if (this.editorSettings == null) {
                this.editorSettings = new REditorOptions(1);
                this.prefUpdaters.add(new PreferencesManageListener((AbstractPreferencesModelObject)this.editorSettings, PreferenceUtils.getInstancePrefs(), "r/r.editor/smartinsert"));
            }
            return this.editorSettings;
        }
        return null;
    }

    public synchronized TextStyleManager getRTextStyles() {
        if (this.rTextStyles == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.rTextStyles = new TextStyleManager(SharedUIResources.getColors(), this.getPreferenceStore(), "r.editor/textstyles");
            PreferencesUtil.getSettingsChangeNotifier().addManageListener((SettingsChangeNotifier.ManageListener)this.rTextStyles);
        }
        return this.rTextStyles;
    }

    public synchronized TextStyleManager getRdTextStyles() {
        if (this.rdTextStyles == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.rdTextStyles = new TextStyleManager(SharedUIResources.getColors(), this.getPreferenceStore(), "rd.editor/textstyles");
            PreferencesUtil.getSettingsChangeNotifier().addManageListener((SettingsChangeNotifier.ManageListener)this.rdTextStyles);
        }
        return this.rdTextStyles;
    }

    public synchronized ContextTypeRegistry getRCodeGenerationTemplateContextRegistry() {
        if (this.rCodeTemplatesContextTypeRegistry == null) {
            this.rCodeTemplatesContextTypeRegistry = new ContributionContextTypeRegistry();
            RCodeTemplateContextType.registerContextTypes((org.eclipse.text.templates.ContextTypeRegistry)this.rCodeTemplatesContextTypeRegistry);
        }
        return this.rCodeTemplatesContextTypeRegistry;
    }

    public synchronized TemplateStore getRCodeGenerationTemplateStore() {
        if (this.rCodeTemplatesStore == null) {
            this.rCodeTemplatesStore = new ContributionTemplateStore(this.getRCodeGenerationTemplateContextRegistry(), this.getPreferenceStore(), R_CODE_TEMPLATES_KEY);
            try {
                this.rCodeTemplatesStore.load();
            }
            catch (IOException e) {
                RUIPlugin.logError(101, "Error occured when loading 'R code generation' template store.", e);
            }
        }
        return this.rCodeTemplatesStore;
    }

    public synchronized ContextTypeRegistry getRdCodeGenerationTemplateContextRegistry() {
        if (this.rdCodeTemplatesContextTypeRegistry == null) {
            this.rdCodeTemplatesContextTypeRegistry = new ContributionContextTypeRegistry();
            RdCodeTemplateContextType.registerContextTypes((org.eclipse.text.templates.ContextTypeRegistry)this.rdCodeTemplatesContextTypeRegistry);
        }
        return this.rdCodeTemplatesContextTypeRegistry;
    }

    public synchronized TemplateStore getRdCodeGenerationTemplateStore() {
        if (this.rdCodeTemplatesStore == null) {
            this.rdCodeTemplatesStore = new ContributionTemplateStore(this.getRdCodeGenerationTemplateContextRegistry(), this.getPreferenceStore(), RD_CODE_TEMPLATES_KEY);
            try {
                this.rdCodeTemplatesStore.load();
            }
            catch (IOException e) {
                RUIPlugin.logError(101, "Error occured when loading 'Rd code generation' template store.", e);
            }
        }
        return this.rdCodeTemplatesStore;
    }

    public synchronized ContextTypeRegistry getRPkgCodeGenerationTemplateContextRegistry() {
        if (this.rPkgCodeTemplatesContextTypeRegistry == null) {
            this.rPkgCodeTemplatesContextTypeRegistry = new ContributionContextTypeRegistry();
            RPkgTemplateContextType.registerContextTypes((org.eclipse.text.templates.ContextTypeRegistry)this.rPkgCodeTemplatesContextTypeRegistry);
        }
        return this.rPkgCodeTemplatesContextTypeRegistry;
    }

    public synchronized TemplateStore getRPkgCodeGenerationTemplateStore() {
        if (this.rPkgCodeTemplatesStore == null) {
            this.rPkgCodeTemplatesStore = new ContributionTemplateStore(this.getRPkgCodeGenerationTemplateContextRegistry(), this.getPreferenceStore(), RPKG_CODE_TEMPLATES_KEY);
            try {
                this.rPkgCodeTemplatesStore.load();
            }
            catch (IOException e) {
                RUIPlugin.logError(101, "Error occured when loading 'R package code generation' template store.", e);
            }
        }
        return this.rPkgCodeTemplatesStore;
    }

    public synchronized ContextTypeRegistry getREditorTemplateContextRegistry() {
        if (this.rEditorContextTypeRegistry == null) {
            this.rEditorContextTypeRegistry = new ContributionContextTypeRegistry();
            REditorTemplateContextType.registerContextTypes((org.eclipse.text.templates.ContextTypeRegistry)this.rEditorContextTypeRegistry);
        }
        return this.rEditorContextTypeRegistry;
    }

    public synchronized EnhTemplateStore getREditorTemplateStore() {
        if (this.rEditorTemplatesStore == null) {
            this.rEditorTemplatesStore = new EnhTemplateStore(this.getREditorTemplateContextRegistry(), this.getPreferenceStore(), R_EDITOR_TEMPLATES_KEY);
            try {
                this.rEditorTemplatesStore.load();
            }
            catch (IOException e) {
                RUIPlugin.logError(101, "Error occured when loading 'R Editor' template store.", e);
            }
        }
        return this.rEditorTemplatesStore;
    }

    public synchronized ContentAssistComputerRegistry getREditorContentAssistRegistry() {
        if (this.rEditorContentAssistRegistry == null) {
            this.rEditorContentAssistRegistry = new ContentAssistComputerRegistry("org.eclipse.statet.r.contentTypes.R", "org.eclipse.statet.r.ui/editor.r/options");
            this.disposables.add((Disposable)this.rEditorContentAssistRegistry);
        }
        return this.rEditorContentAssistRegistry;
    }

    public synchronized ContentAssistComputerRegistry getRConsoleContentAssistRegistry() {
        if (this.rConsoleContentAssistRegistry == null) {
            this.rConsoleContentAssistRegistry = new ContentAssistComputerRegistry("org.eclipse.statet.r.contentTypes.RConsole", "org.eclipse.statet.r.ui/org.eclipse.statet.nico.scope/editor.r/options");
            this.disposables.add((Disposable)this.rConsoleContentAssistRegistry);
        }
        return this.rConsoleContentAssistRegistry;
    }

    public synchronized InfoHoverRegistry getREditorInfoHoverRegistry() {
        if (this.rEditorInfoHoverRegistry == null) {
            this.rEditorInfoHoverRegistry = new InfoHoverRegistry("org.eclipse.statet.r.contentTypes.R", "org.eclipse.statet.r.ui/editor.r/options", "r/r.editor/hover");
            this.disposables.add((Disposable)this.rEditorInfoHoverRegistry);
        }
        return this.rEditorInfoHoverRegistry;
    }

    public synchronized ERGraphicFactory getCommonRGraphicFactory() {
        if (this.commonRGraphicFactory == null) {
            ERGraphicFactory manager = this.commonRGraphicFactory = new ERGraphicFactory();
            manager.addListener((ERGraphicsManager.Listener)new ShowGraphicViewListener());
        }
        return this.commonRGraphicFactory;
    }

    public void registerPluginDisposable(Disposable d) {
        List<Disposable> disposables = this.disposables;
        if (disposables == null) {
            throw new IllegalStateException();
        }
        disposables.add(d);
    }
}

