/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.assist;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.statet.ecommons.text.ui.DefaultBrowserInformationInput;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ui.LTKUI;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.ITextEditToolSynchronizer;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposal;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

@NonNullByDefault
public abstract class LinkedNamesAssistProposal
implements AssistProposal,
ICompletionProposalExtension5 {
    private final AssistInvocationContext context;
    private String label;
    private @Nullable String description;
    private int relevance;
    private @Nullable String valueSuggestion;

    public LinkedNamesAssistProposal(AssistInvocationContext invocationContext) {
        this.context = (AssistInvocationContext)ObjectUtils.nonNullAssert((Object)invocationContext);
    }

    protected void init(String label, @Nullable String description, int relevance) {
        this.label = (String)ObjectUtils.nonNullAssert((Object)label);
        this.description = description;
        this.relevance = relevance;
    }

    public boolean validate(IDocument document, int offset, @Nullable DocumentEvent event) {
        return false;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        try {
            ITextEditToolSynchronizer synchronizer;
            Point seletion = viewer.getSelectedRange();
            IDocument document = viewer.getDocument();
            if (document == null) {
                return;
            }
            LinkedModeModel model = new LinkedModeModel();
            LinkedPositionGroup group = new LinkedPositionGroup();
            this.collectPositions(document, group);
            if (group.isEmpty()) {
                return;
            }
            model.addGroup(group);
            model.forceInstall();
            ISourceEditor editor = this.context.getEditor();
            if (editor != null && (synchronizer = editor.getTextEditToolSynchronizer()) != null) {
                synchronizer.install(model);
            }
            EditorLinkedModeUI ui = new EditorLinkedModeUI(model, viewer);
            ui.setExitPolicy((LinkedModeUI.IExitPolicy)new DeleteBlockingExitPolicy(document));
            ui.setExitPosition(viewer, offset, 0, -1);
            ui.enter();
            String valueSuggestion = this.valueSuggestion;
            if (valueSuggestion != null) {
                LinkedPosition position = group.getPositions()[0];
                document.replace(position.getOffset(), position.getLength(), valueSuggestion);
                seletion = new Point(position.getOffset(), valueSuggestion.length());
            }
            viewer.setSelectedRange(seletion.x, seletion.y);
        }
        catch (BadLocationException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ltk.ui", -1, "Error initializing linked rename.", (Throwable)e));
        }
    }

    protected abstract void collectPositions(IDocument var1, LinkedPositionGroup var2) throws BadLocationException;

    protected int addPosition(LinkedPositionGroup group, IDocument document, @Nullable Position position, int idx) throws BadLocationException {
        if (position != null) {
            group.addPosition(new LinkedPosition(document, position.getOffset(), position.getLength(), idx));
            return idx + 1;
        }
        return idx;
    }

    protected int addPosition(LinkedPositionGroup group, IDocument document, @Nullable TextRegion position, int idx) throws BadLocationException {
        if (position != null) {
            group.addPosition(new LinkedPosition(document, position.getStartOffset(), position.getLength(), idx));
            return idx + 1;
        }
        return idx;
    }

    @Override
    public void apply(IDocument document) {
        throw new UnsupportedOperationException();
    }

    public @Nullable Point getSelection(IDocument document) {
        return null;
    }

    @Override
    public int getRelevance() {
        return this.relevance;
    }

    @Override
    public String getSortingString() {
        return this.label;
    }

    public String getDisplayString() {
        return this.label;
    }

    public Image getImage() {
        return LTKUI.getImages().get("org.eclipse.statet.ltk.ui/image/obj/assist.linked_rename");
    }

    public @Nullable String getAdditionalProposalInfo() {
        return this.description;
    }

    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        return new DefaultBrowserInformationInput(null, this.getDisplayString(), this.description, 2);
    }

    public @Nullable IContextInformation getContextInformation() {
        return null;
    }

    public static class DeleteBlockingExitPolicy
    implements LinkedModeUI.IExitPolicy {
        private final IDocument document;

        public DeleteBlockingExitPolicy(IDocument document) {
            this.document = document;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable LinkedModeUI.ExitFlags doExit(LinkedModeModel model, VerifyEvent event, int offset, int length) {
            switch (event.character) {
                case '\b': {
                    LinkedPosition position = model.findPosition(new LinkedPosition(this.document, offset, 0, -1));
                    if (position != null && offset <= position.getOffset() && length == 0) {
                        event.doit = false;
                    }
                    return null;
                }
                case '\u007f': {
                    LinkedPosition position = model.findPosition(new LinkedPosition(this.document, offset, 0, -1));
                    if (position != null && offset >= position.getOffset() + position.getLength() && length == 0) {
                        event.doit = false;
                    }
                    return null;
                }
            }
            return null;
        }
    }
}

