/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.assist;

import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.preferences.ui.ManagedConfigurationBlock;
import org.eclipse.statet.ecommons.runtime.core.StatusChangeListener;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.MessageUtils;
import org.eclipse.statet.ecommons.ui.viewers.ViewerUtils;
import org.eclipse.statet.ltk.ui.sourceediting.assist.InfoHoverDescriptor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.InfoHoverRegistry;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AdvancedInfoHoverConfigurationBlock
extends ManagedConfigurationBlock {
    private final InfoHoverRegistry registry;
    private List<InfoHoverDescriptor> descriptors;
    private CheckboxTableViewer hoverTableViewer;
    private Text modifierEditor;

    public AdvancedInfoHoverConfigurationBlock(InfoHoverRegistry registry, StatusChangeListener statusListener) {
        super(null, statusListener);
        this.registry = registry;
    }

    protected void createBlockArea(Composite pageComposite) {
        HashMap<Preference.StringArrayPref, String> prefs = new HashMap<Preference.StringArrayPref, String>();
        prefs.put(this.registry.getPrefSeparateSettings(), this.registry.getSettingsGroupId());
        this.setupPreferenceManager(prefs);
        Composite composite = new Composite(pageComposite, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)2));
        ViewerUtils.CheckboxTableComposite tableComposite = new ViewerUtils.CheckboxTableComposite(composite, 67588);
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.hoverTableViewer = tableComposite.viewer;
        tableComposite.table.setHeaderVisible(true);
        tableComposite.table.setLinesVisible(true);
        TableViewerColumn column = tableComposite.addColumn("Hover Type", 16384, (ColumnLayoutData)new ColumnWeightData(1));
        column.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                InfoHoverDescriptor descriptor = (InfoHoverDescriptor)cell.getElement();
                cell.setText(descriptor.getName());
            }
        });
        column = tableComposite.addColumn("Modifier Keys", 16384, (ColumnLayoutData)new ColumnWeightData(1));
        column.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                InfoHoverDescriptor descriptor = (InfoHoverDescriptor)cell.getElement();
                cell.setText(MessageUtils.getModifierString((int)descriptor.getStateMask()));
            }
        });
        this.hoverTableViewer.setUseHashlookup(true);
        this.hoverTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.hoverTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AdvancedInfoHoverConfigurationBlock.this.handleHoverListSelection();
            }
        });
        CheckProvider checkProvider = new CheckProvider();
        this.hoverTableViewer.setCheckStateProvider((ICheckStateProvider)checkProvider);
        this.hoverTableViewer.addCheckStateListener((ICheckStateListener)checkProvider);
        Label label = new Label(composite, 16384);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label.setText("&Modifier keys:");
        this.modifierEditor = new Text(composite, 2048);
        this.modifierEditor.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.modifierEditor.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                e.doit = false;
                InfoHoverDescriptor descriptor = AdvancedInfoHoverConfigurationBlock.this.getSelecteddescriptor();
                if (descriptor == null) {
                    return;
                }
                if (e.keyCode > 0 && e.character == '\u0000') {
                    descriptor.stateMask = (e.stateMask | e.keyCode) & 0x470000;
                } else if (e.keyCode == 127 | e.keyCode == 8) {
                    descriptor.stateMask = 0;
                } else {
                    return;
                }
                AdvancedInfoHoverConfigurationBlock.this.modifierEditor.setText(MessageUtils.getModifierString((int)descriptor.getStateMask()));
                AdvancedInfoHoverConfigurationBlock.this.hoverTableViewer.refresh((Object)descriptor);
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        LayoutUtils.addSmallFiller((Composite)composite, (boolean)true);
        this.descriptors = this.registry.loadCurrent();
        this.hoverTableViewer.setInput(this.descriptors);
        this.hoverTableViewer.getTable().setSelection(0);
        this.handleHoverListSelection();
    }

    private InfoHoverDescriptor getSelecteddescriptor() {
        return (InfoHoverDescriptor)((IStructuredSelection)this.hoverTableViewer.getSelection()).getFirstElement();
    }

    private void handleHoverListSelection() {
        InfoHoverDescriptor descriptor = this.getSelecteddescriptor();
        if (descriptor == null) {
            this.modifierEditor.setText("");
            this.modifierEditor.setEditable(false);
        } else {
            this.modifierEditor.setText(MessageUtils.getModifierString((int)descriptor.stateMask));
            this.modifierEditor.setEnabled(descriptor.isEnabled);
        }
    }

    protected void updateControls() {
        super.updateControls();
        List<InfoHoverDescriptor> updated = this.registry.applyPreferences((PreferenceAccess)this, this.descriptors);
        this.descriptors.clear();
        this.descriptors.addAll(updated);
        this.hoverTableViewer.refresh();
    }

    protected void updatePreferences() {
        this.setPrefValues(this.registry.toPreferencesMap(this.descriptors));
        super.updatePreferences();
    }

    private class CheckProvider
    implements ICheckStateProvider,
    ICheckStateListener {
        private CheckProvider() {
        }

        public boolean isGrayed(Object element) {
            return false;
        }

        public boolean isChecked(Object element) {
            InfoHoverDescriptor descriptor = (InfoHoverDescriptor)element;
            return descriptor.isEnabled;
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            InfoHoverDescriptor descriptor = (InfoHoverDescriptor)event.getElement();
            descriptor.isEnabled = event.getChecked();
            AdvancedInfoHoverConfigurationBlock.this.handleHoverListSelection();
        }
    }
}

