/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting;

import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.core.SourceModelStamp;
import org.eclipse.statet.ltk.model.core.element.LtkModelElementFilter;
import org.eclipse.statet.ltk.model.core.element.SourceStructElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnitModelInfo;

@NonNullByDefault
public class OutlineContentProvider
implements ITreeContentProvider {
    private static final SourceStructElement[] NO_CHILDREN = new SourceStructElement[0];
    private final OutlineContent content;

    public OutlineContentProvider(OutlineContent content) {
        this.content = content;
    }

    protected final OutlineContent getContent() {
        return this.content;
    }

    public @Nullable SourceModelStamp getStamp(Object inputElement) {
        SourceUnitModelInfo modelInfo = this.getContent().getModelInfo(inputElement);
        return modelInfo != null ? modelInfo.getStamp() : null;
    }

    public void inputChanged(Viewer viewer, @Nullable Object oldInput, @Nullable Object newInput) {
    }

    public void dispose() {
    }

    protected SourceStructElement[] getElements(@Nullable SourceUnitModelInfo modelInfo) {
        if (modelInfo != null) {
            List children = modelInfo.getSourceElement().getSourceChildren(this.getContent().getContentFilter());
            return children.toArray(new SourceStructElement[children.size()]);
        }
        return NO_CHILDREN;
    }

    protected @Nullable SourceStructElement getParent(SourceStructElement<?, ?> element) {
        return element.getSourceParent();
    }

    protected boolean hasChildren(@Nullable SourceStructElement<?, ?> element) {
        return element != null && element.hasSourceChildren(this.getContent().getContentFilter());
    }

    protected SourceStructElement[] getChildren(@Nullable SourceStructElement<?, ?> element) {
        if (element != null) {
            List children = element.getSourceChildren(this.getContent().getContentFilter());
            return children.toArray(new SourceStructElement[children.size()]);
        }
        return NO_CHILDREN;
    }

    public Object[] getElements(Object inputElement) {
        return this.getElements(this.getContent().getModelInfo(inputElement));
    }

    public @Nullable Object getParent(Object element) {
        return this.getParent((SourceStructElement)element);
    }

    public boolean hasChildren(Object element) {
        return this.hasChildren((SourceStructElement)element);
    }

    public Object[] getChildren(Object element) {
        return this.getChildren((SourceStructElement)element);
    }

    public static interface OutlineContent {
        public @Nullable SourceUnitModelInfo getModelInfo(Object var1);

        public @Nullable LtkModelElementFilter<? super SourceStructElement<?, ?>> getContentFilter();
    }
}

