/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.model.core.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.statet.internal.ltk.core.LtkCorePlugin;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.ltk.core.WorkingContext;
import org.eclipse.statet.ltk.model.core.ElementChangedEvent;
import org.eclipse.statet.ltk.model.core.ElementChangedListener;
import org.eclipse.statet.ltk.model.core.LtkModelUtils;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.ltk.model.core.element.LtkModelElementDelta;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.model.core.element.SourceUnitModelInfo;
import org.eclipse.statet.ltk.model.core.impl.AbstractModelManager;

@NonNullByDefault
public abstract class AbstractModelEventJob<TModelElement extends LtkModelElement<?>, InfoType extends SourceUnitModelInfo>
extends Job {
    private final AbstractModelManager modelManager;
    private final Object tasksLock = new Object();
    private final LinkedList<TModelElement> taskQueue = new LinkedList();
    private final HashMap<TModelElement, Task> taskDetail = new HashMap();
    private boolean working = false;
    private boolean stop = false;

    public AbstractModelEventJob(AbstractModelManager manager) {
        super("Model Events for " + manager.getModelTypeId());
        this.setPriority(40);
        this.setSystem(true);
        this.setUser(false);
        this.modelManager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUpdate(TModelElement element, InfoType oldModel, InfoType newModel) {
        Object object = this.tasksLock;
        synchronized (object) {
            Task task = this.taskDetail.get(element);
            if (task == null) {
                task = new Task(this, element);
                task.oldInfo = oldModel;
                this.taskDetail.put(element, task);
            } else {
                this.taskQueue.remove(element);
            }
            task.newInfo = newModel;
            this.taskQueue.add(element);
            if (!this.working) {
                this.schedule();
            }
        }
    }

    protected abstract LtkModelElementDelta createDelta(Task var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        while (true) {
            Task task;
            Object object = this.tasksLock;
            synchronized (object) {
                LtkModelElement element;
                LtkModelElement ltkModelElement = element = !this.taskQueue.isEmpty() ? (LtkModelElement)this.taskQueue.removeFirst() : null;
                if (element == null || this.stop) {
                    this.working = false;
                    return Status.OK_STATUS;
                }
                this.working = true;
                task = this.taskDetail.remove(element);
            }
            try {
                task.run();
                continue;
            }
            catch (Throwable e) {
                LtkCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.ltk.core", -1, "An error occurred when firing model event for " + this.modelManager.getModelTypeId() + ".", e));
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose() {
        Object object = this.tasksLock;
        synchronized (object) {
            this.stop = true;
            this.taskQueue.clear();
            this.taskDetail.clear();
        }
    }

    private void fireDelta(LtkModelElementDelta delta) {
        SourceUnit su = LtkModelUtils.getSourceUnit(delta.getModelElement());
        if (su == null) {
            return;
        }
        WorkingContext context = su.getWorkingContext();
        ElementChangedEvent event = new ElementChangedEvent(delta, context);
        SafeRunnable runnable = new SafeRunnable(event);
        ImIdentityList<ElementChangedListener> listeners = this.modelManager.getElementChangedListeners(context);
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            ElementChangedListener listener;
            runnable.listener = listener = (ElementChangedListener)iterator.next();
            SafeRunner.run((ISafeRunnable)runnable);
        }
    }

    private static class SafeRunnable
    implements ISafeRunnable {
        final ElementChangedEvent event;
        ElementChangedListener listener;

        public SafeRunnable(ElementChangedEvent event) {
            this.event = event;
        }

        public void run() {
            this.listener.elementChanged(this.event);
        }

        public void handleException(Throwable e) {
            LtkCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.ltk.core", -1, "An error occured while notifying an ElementChangedListener.", e));
        }
    }

    protected static class Task {
        private final TModelElement element;
        private InfoType oldInfo;
        private InfoType newInfo;
        final /* synthetic */ AbstractModelEventJob this$0;

        public Task(TModelElement element) {
            this.this$0 = var1_1;
            this.element = element;
        }

        public TModelElement getElement() {
            return this.element;
        }

        public InfoType getOldInfo() {
            return this.oldInfo;
        }

        public InfoType getNewInfo() {
            return this.newInfo;
        }

        void run() {
            LtkModelElementDelta delta = this.this$0.createDelta(this);
            this.this$0.fireDelta(delta);
        }
    }
}

