/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.rtool;

import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.r.ui.rtool.CopyRElementHandler;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;

@NonNullByDefault
public class RElementViewerDragSourceListener
implements TransferDragSourceListener {
    private final CopyRElementHandler commandHandler;
    private final StructuredViewer viewer;
    private String text = "";

    public RElementViewerDragSourceListener(CopyRElementHandler commandHandler, StructuredViewer viewer) {
        this.commandHandler = commandHandler;
        this.viewer = viewer;
    }

    public Transfer getTransfer() {
        return TextTransfer.getInstance();
    }

    private ITreeSelection getSelection() {
        return (ITreeSelection)this.viewer.getSelection();
    }

    public void dragStart(DragSourceEvent event) {
        ITreeSelection selection = this.getSelection();
        if (!this.commandHandler.isValidSelection((IStructuredSelection)selection)) {
            event.doit = false;
            return;
        }
        String text = this.commandHandler.createData((IStructuredSelection)selection);
        if (text != null) {
            this.text = text;
        } else {
            event.doit = false;
        }
    }

    public void dragSetData(DragSourceEvent event) {
        event.data = this.text;
    }

    public void dragFinished(DragSourceEvent event) {
        this.text = "";
    }
}

