/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.graphics;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.statet.ecommons.ui.dialogs.ToolPopup;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class RFontFamilyChooser
extends ToolPopup {
    private static final String GENERIC = "Generic";
    private static final ImList<String> VALUES = ImCollections.newList((Object[])new String[]{"serif", "sansserif", "mono"});
    private String fInitialValue;
    private String fInitialFontName;
    private Font fInitialSWTFont;
    private String fCurrentFontName;
    private String fCurrentValue;
    private Font fCurrentSWTFont;
    private Composite fStatusControl;

    public static void drawPreview(GC gc, int x, int y, int width, int height, Font font) {
        if (font != null) {
            gc.setBackground(gc.getDevice().getSystemColor(1));
            gc.fillRectangle(x, y, width + 1, height + 1);
            gc.setForeground(gc.getDevice().getSystemColor(2));
            gc.setFont(font);
            FontMetrics fontMetrics = gc.getFontMetrics();
            gc.setClipping(x, y, width, height);
            gc.drawText("Abc 12.0", x + 2, y + 1 - fontMetrics.getLeading() + Math.max(1 + (height - fontMetrics.getHeight()) / 2, 0), 1);
            gc.setClipping(null);
        }
    }

    public static String getFontName(String value) {
        if (value != null) {
            if (value.equals("serif")) {
                return Platform.getPreferencesService().getString("org.eclipse.statet.rj.eclient.graphics/fonts", "serif.name", "", null);
            }
            if (value.equals("sansserif")) {
                return Platform.getPreferencesService().getString("org.eclipse.statet.rj.eclient.graphics/fonts", "sans.name", "", null);
            }
            if (value.equals("mono")) {
                return Platform.getPreferencesService().getString("org.eclipse.statet.rj.eclient.graphics/fonts", "mono.name", "", null);
            }
        }
        return value;
    }

    public static Font createFont(Device device, String fontName, int height) {
        FontData fontData = RFontFamilyChooser.getFontData(device, fontName);
        if (fontData == null) {
            return null;
        }
        if (height < 0) {
            height = JFaceResources.getDialogFont().getFontData()[0].getHeight();
        }
        if (fontData.getHeight() != height) {
            fontData = new FontData(fontData.getName(), height, fontData.getStyle());
        }
        return new Font(device, fontData);
    }

    private static FontData getFontData(Device device, String fontName) {
        if (fontName == null || fontName.isEmpty()) {
            return null;
        }
        FontData[] fontDatas = device.getFontList(fontName, true);
        if (fontDatas.length == 0) {
            fontDatas = device.getFontList(fontName, false);
        }
        if (fontDatas.length == 0) {
            return null;
        }
        int i = 0;
        while (i < fontDatas.length) {
            if (fontDatas[i].getStyle() == 0) {
                return fontDatas[i];
            }
            ++i;
        }
        i = 0;
        while (i < fontDatas.length) {
            if (fontDatas[i].getStyle() == 2) {
                return fontDatas[i];
            }
            ++i;
        }
        return fontDatas[0];
    }

    public void open(Shell parent, Rectangle position, String initialValue) {
        this.fInitialValue = initialValue;
        this.doSetValue(initialValue != null ? initialValue : "sansserif");
        super.open(parent, position);
    }

    protected void addTabs(CTabFolder tabFolder) {
        new GenericTab(this){

            @Override
            protected String getValue() {
                return RFontFamilyChooser.this.getValue();
            }

            @Override
            protected void setValue(String value) {
                RFontFamilyChooser.this.doSetValue(value);
            }
        };
    }

    protected ToolPopup.ToolTab getBestTab() {
        return this.getTab(GENERIC);
    }

    protected void addStatusControls(Composite composite) {
        this.fStatusControl = new ToolPopup.PreviewCanvas(composite){

            protected void drawPreview(GC gc, int idx, int x, int y, int width, int height) {
                Font font = null;
                switch (idx) {
                    case 0: {
                        if (RFontFamilyChooser.this.fInitialValue == null) break;
                        if (RFontFamilyChooser.this.fInitialSWTFont == null && RFontFamilyChooser.this.fInitialFontName != "") {
                            if (RFontFamilyChooser.this.fInitialFontName == null) {
                                RFontFamilyChooser.this.fInitialFontName = RFontFamilyChooser.getFontName(RFontFamilyChooser.this.fInitialValue);
                            }
                            RFontFamilyChooser.this.fInitialSWTFont = RFontFamilyChooser.createFont(gc.getDevice(), RFontFamilyChooser.this.fInitialFontName, -1);
                            if (RFontFamilyChooser.this.fInitialSWTFont == null) {
                                RFontFamilyChooser.this.fInitialFontName = "";
                            }
                        }
                        font = RFontFamilyChooser.this.fInitialSWTFont;
                        break;
                    }
                    case 1: {
                        if (RFontFamilyChooser.this.fCurrentValue == null) break;
                        if (RFontFamilyChooser.this.fCurrentSWTFont == null && RFontFamilyChooser.this.fCurrentFontName != "") {
                            if (RFontFamilyChooser.this.fCurrentFontName == null) {
                                RFontFamilyChooser.this.fCurrentFontName = RFontFamilyChooser.getFontName(RFontFamilyChooser.this.fCurrentValue);
                            }
                            RFontFamilyChooser.this.fCurrentSWTFont = RFontFamilyChooser.createFont(gc.getDevice(), RFontFamilyChooser.this.fCurrentFontName, -1);
                            if (RFontFamilyChooser.this.fCurrentSWTFont == null) {
                                RFontFamilyChooser.this.fCurrentFontName = "";
                            }
                        }
                        font = RFontFamilyChooser.this.fCurrentSWTFont;
                        break;
                    }
                }
                RFontFamilyChooser.drawPreview(gc, x, y, width, height, font);
            }
        };
        this.updateStatus();
    }

    protected void doSetValue(String value) {
        if (value == null || value.equals(this.fCurrentValue)) {
            return;
        }
        String fontName = RFontFamilyChooser.getFontName(value);
        if (!(this.fCurrentSWTFont == null || fontName != null && fontName.equals(this.fCurrentFontName))) {
            this.fCurrentSWTFont.dispose();
            this.fCurrentSWTFont = null;
        }
        this.fCurrentValue = value;
        this.fCurrentFontName = fontName;
        if (this.fStatusControl != null) {
            this.updateStatus();
        }
    }

    protected void updateStatus() {
        StringBuilder sb = new StringBuilder();
        sb.append("Previous: ");
        sb.append(this.fInitialValue != null ? this.fInitialValue : "-");
        sb.append("\n");
        sb.append("Current: ");
        sb.append(this.fCurrentValue);
        this.fStatusControl.setToolTipText(sb.toString());
        this.fStatusControl.redraw();
    }

    public String getValue() {
        return this.fCurrentValue;
    }

    protected void onDispose() {
        this.fStatusControl = null;
        super.onDispose();
        if (this.fInitialSWTFont != null) {
            this.fInitialSWTFont.dispose();
            this.fInitialFontName = null;
            this.fInitialSWTFont = null;
        }
        if (this.fCurrentSWTFont != null) {
            this.fCurrentSWTFont.dispose();
            this.fCurrentFontName = null;
            this.fCurrentSWTFont = null;
        }
    }

    protected static abstract class GenericTab
    extends ToolPopup.ToolTab {
        private Button[] fButtons;

        GenericTab(ToolPopup parent) {
            this(parent, "Standard", "Definition by generic R Standard Names");
        }

        GenericTab(ToolPopup parent, String name, String tooltip) {
            super(RFontFamilyChooser.GENERIC, parent, name, tooltip);
            Composite composite = this.create();
            composite.setLayout((Layout)LayoutUtils.newTabGrid((int)3));
            String[] labels = new String[]{"Serif", "Sans Serif", "Monospace"};
            Listener listener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 13: {
                            this.setValue((String)event.widget.getData());
                            return;
                        }
                        case 8: {
                            event.widget.getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    this.performOK();
                                }
                            });
                            return;
                        }
                    }
                }
            };
            this.fButtons = new Button[3];
            int i = 0;
            while (i < 3) {
                Button button = new Button(composite, 16);
                button.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
                button.setText(labels[i] + " ('" + (String)VALUES.get(i) + "')");
                button.setData(VALUES.get(i));
                button.addListener(13, listener);
                button.addListener(8, listener);
                this.fButtons[i] = button;
                ++i;
            }
            this.fButtons[0].setSelection(true);
            LayoutUtils.addGDDummy((Composite)composite, (boolean)true, (int)3);
            Link link = new Link(composite, 0);
            link.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
            link.setText("<a>Preferences for Standard Fonts in StatET...</a>");
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ToolPopup popup = this.getParent();
                    popup.beginIgnoreActivation();
                    try {
                        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)popup.getShell(), (String)"org.eclipse.statet.r.preferencePages.RGraphicsPage", (String[])new String[]{"org.eclipse.statet.r.preferencePages.RGraphicsPage"}, null);
                        dialog.open();
                    }
                    finally {
                        popup.endIgnoreActivation();
                    }
                }
            });
        }

        protected void activated() {
            String value = this.getValue();
            int idx = VALUES.indexOf((Object)value);
            int i = 0;
            while (i < 3) {
                this.fButtons[i].setSelection(i == idx);
                ++i;
            }
        }

        protected abstract String getValue();

        protected abstract void setValue(String var1);
    }
}

