/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.launching.ui;

import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.statet.ecommons.databinding.core.validation.UpdateableErrorValidator;
import org.eclipse.statet.ecommons.debug.ui.config.LaunchConfigTabWithDbc;
import org.eclipse.statet.ecommons.io.FileValidator;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.MessageUtils;
import org.eclipse.statet.internal.r.debug.ui.RLaunchingMessages;
import org.eclipse.statet.internal.r.ui.REnvSelectionComposite;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.ui.RUI;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.statet.rj.renv.core.REnvConfiguration;
import org.eclipse.statet.rj.renv.core.REnvManager;
import org.eclipse.statet.rj.renv.core.REnvUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class REnvTab
extends LaunchConfigTabWithDbc {
    private final boolean local;
    private final IObservableValue<String> rEnvSettingValue;
    private Binding rEnvBinding;
    private REnvSelectionComposite rEnvControl;

    public static String readWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        String wd = configuration.getAttribute("org.eclipse.statet.r/renv/WorkingDirectory", null);
        if (wd == null) {
            wd = "";
        }
        return wd;
    }

    public static void setWorkingDirectory(ILaunchConfigurationWorkingCopy configuration, String wd) {
        if (wd != null && wd.length() > 0) {
            configuration.setAttribute("org.eclipse.statet.r/renv/WorkingDirectory", wd);
        } else {
            configuration.removeAttribute("org.eclipse.statet.r/renv/WorkingDirectory");
        }
    }

    public static IFileStore getWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        return REnvTab.getWorkingDirectoryValidator(configuration, true).getFileStore();
    }

    public static FileValidator getWorkingDirectoryValidator(ILaunchConfiguration configuration, boolean validate) throws CoreException {
        String path = REnvTab.readWorkingDirectory(configuration);
        if (path == null || path.trim().isEmpty()) {
            path = System.getProperty("user.dir");
        }
        FileValidator validator = new FileValidator(true);
        validator.setOnDirectory(0);
        validator.setOnFile(4);
        validator.setResourceLabel(MessageUtils.removeMnemonics((String)RLaunchingMessages.REnv_Tab_WorkingDir_label));
        validator.setExplicit((Object)path);
        if (validate && validator.validate(null).getSeverity() == 4) {
            throw new CoreException(validator.getStatus());
        }
        return validator;
    }

    public REnvTab(boolean local) {
        this.local = local;
        Realm realm = this.getRealm();
        this.rEnvSettingValue = new WritableValue(realm, null, String.class);
    }

    public String getName() {
        return RLaunchingMessages.REnv_Tab_title;
    }

    public Image getImage() {
        return RUI.getImage("org.eclipse.statet.r/images/obj/r_environment");
    }

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        this.setControl((Control)mainComposite);
        mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        mainComposite.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        Group group = new Group(mainComposite, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setText(RLaunchingMessages.REnv_Tab_REnvConfig_label + ":");
        group.setLayout((Layout)LayoutUtils.newGroupGrid((int)1));
        this.rEnvControl = this.local ? new REnvSelectionComposite((Composite)group){

            @Override
            protected boolean isValid(REnvConfiguration rEnvConfig) {
                return super.isValid(rEnvConfig) && rEnvConfig.isLocal();
            }
        } : new REnvSelectionComposite((Composite)group, true);
        this.rEnvControl.setLayoutData(new GridData(4, 4, true, false));
        Dialog.applyDialogFont((Control)parent);
        this.initBindings();
    }

    protected void addBindings(DataBindingContext dbc) {
        this.rEnvBinding = dbc.bindValue(this.rEnvControl.createObservable(), this.rEnvSettingValue, new UpdateValueStrategy().setAfterGetValidator((IValidator)new UpdateableErrorValidator(this.rEnvControl.createValidator(dbc))), null);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        if (this.local) {
            configuration.setAttribute("org.eclipse.statet.r/renv/REnvCode", "default-workbench");
        }
    }

    protected void doInitialize(ILaunchConfiguration configuration) {
        try {
            String code = configuration.getAttribute("org.eclipse.statet.r/renv/REnvCode", null);
            this.rEnvSettingValue.setValue((Object)code);
        }
        catch (CoreException e) {
            this.rEnvSettingValue.setValue(null);
            this.logReadingError(e);
        }
    }

    protected void doSave(ILaunchConfigurationWorkingCopy configuration) {
        String code = (String)this.rEnvSettingValue.getValue();
        configuration.setAttribute("org.eclipse.statet.r/renv/REnvCode", code);
    }

    public REnv getSelectedEnv() {
        IStatus validationStatus;
        if (this.rEnvBinding != null && (validationStatus = (IStatus)this.rEnvBinding.getValidationStatus().getValue()) != null && validationStatus.getSeverity() < 2) {
            return REnvUtils.decode((String)((String)this.rEnvSettingValue.getValue()), (REnvManager)RCore.getREnvManager());
        }
        return null;
    }
}

