/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.jcommons.io;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.statet.internal.jcommons.io.AbstractNestedArchiveUriUrl;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public final class NestedJarUriUrl
extends AbstractNestedArchiveUriUrl {
    private final int nestSepIndex;
    private final int jarSepIndex;

    public NestedJarUriUrl(URI url, int jarSepIndex) throws URISyntaxException {
        super(url);
        String ssp = url.getSchemeSpecificPart();
        int nestSepIdx = ssp.indexOf("/!", 7);
        if (nestSepIdx == -1 || nestSepIdx >= jarSepIndex - 1) {
            throw new URISyntaxException(url.toString(), "Nested JAR separator '/!' is missing");
        }
        this.nestSepIndex = nestSepIdx;
        this.jarSepIndex = jarSepIndex;
    }

    @Override
    public String getOuterArchiveType() {
        return "jar";
    }

    @Override
    protected URI createOuterArchiveUrl(URI url) throws URISyntaxException {
        String ssp = url.getSchemeSpecificPart();
        return new URI("file", ssp.substring(7, this.nestSepIndex), url.getFragment());
    }

    @Override
    public String getInnerArchiveType() {
        return "jar";
    }

    @Override
    protected URI createInnerArchiveUrl(URI url) throws URISyntaxException {
        String ssp = url.getSchemeSpecificPart();
        StringBuilder sb = new StringBuilder(this.jarSepIndex - 2);
        sb.append("file:");
        sb.append(ssp, 7, this.jarSepIndex);
        sb.replace(this.nestSepIndex - 2, this.nestSepIndex, "!/");
        return new URI("jar", sb.toString(), null);
    }

    @Override
    protected String createEntryPath(URI url) {
        String ssp = url.getSchemeSpecificPart();
        return ssp.substring(this.jarSepIndex + 2, ssp.length());
    }
}

