/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.wikitext.core.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.statet.docmlet.wikitext.core.ast.ContainerNode;
import org.eclipse.statet.docmlet.wikitext.core.ast.NodeType;
import org.eclipse.statet.docmlet.wikitext.core.ast.WikitextAstNode;
import org.eclipse.statet.docmlet.wikitext.core.ast.WikitextAstVisitor;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextRegion;

@NonNullByDefault
public abstract class Block
extends ContainerNode {
    private final DocumentBuilder.BlockType blockType;
    private final @Nullable String label;

    private Block(WikitextAstNode parent, int offset, DocumentBuilder.BlockType blockType, @Nullable String label) {
        super(parent);
        this.doSetStartEndOffset(offset);
        this.blockType = blockType;
        this.label = label;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.BLOCK;
    }

    public DocumentBuilder.BlockType getBlockType() {
        return this.blockType;
    }

    @Override
    public @Nullable String getLabel() {
        return this.label;
    }

    public abstract @Nullable ImList<? extends TextRegion> getTextRegions();

    @Override
    public void acceptInWikitext(WikitextAstVisitor visitor) throws InvocationTargetException {
        visitor.visit(this);
    }

    static final class Common
    extends Block {
        Common(WikitextAstNode parent, int offset, DocumentBuilder.BlockType blockType, @Nullable String label) {
            super(parent, offset, blockType, label);
        }

        @Override
        public @Nullable ImList<? extends TextRegion> getTextRegions() {
            return null;
        }
    }

    static final class TextBlock
    extends Block {
        private final ImList<? extends TextRegion> textRegions;

        TextBlock(WikitextAstNode parent, int offset, DocumentBuilder.BlockType blockType, @Nullable String label, ImList<? extends TextRegion> textRegions) {
            super(parent, offset, blockType, label);
            this.textRegions = textRegions;
        }

        @Override
        public ImList<? extends TextRegion> getTextRegions() {
            return this.textRegions;
        }
    }
}

