/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines;

import java.util.Objects;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.statet.docmlet.wikitext.core.source.LabelInfo;
import org.eclipse.statet.docmlet.wikitext.core.source.LinkRefDefinitionAttributes;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.CommonmarkLocator;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Line;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.ProcessingContext;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.ToStringHelper;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.Inline;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;

@NonNullByDefault
public class ReferenceDefinition
extends Inline {
    private final String href;
    private final @Nullable String title;
    private final LabelInfo referenceLabel;

    public ReferenceDefinition(Line line, int offset, int length, String href, @Nullable String title, LabelInfo referenceLabel) {
        super(line, offset, length, -1);
        this.href = (String)ObjectUtils.nonNullAssert((Object)href);
        this.title = title;
        this.referenceLabel = (LabelInfo)ObjectUtils.nonNullAssert((Object)referenceLabel);
    }

    public String getHref() {
        return this.href;
    }

    @Override
    public void createContext(ProcessingContext context) {
        context.addUriDefinition(this.referenceLabel.getLabel(), this.href, this.title);
    }

    @Override
    public void emit(ProcessingContext context, CommonmarkLocator locator, DocumentBuilder builder) {
        if (context.getMode() == 3) {
            LinkRefDefinitionAttributes attributes = new LinkRefDefinitionAttributes(this.referenceLabel);
            attributes.setTitle(this.title);
            attributes.setHref(this.href);
            builder.link((Attributes)attributes, this.href, null);
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getStartOffset(), this.getLength(), this.referenceLabel, this.href, this.title);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (super.equals(obj)) {
            ReferenceDefinition other = (ReferenceDefinition)obj;
            return this.href.equals(other.href) && this.referenceLabel.equals((Object)other.referenceLabel) && Objects.equals(this.title, other.title);
        }
        return false;
    }

    @Override
    public String toString() {
        ObjectUtils.ToStringBuilder sb = new ObjectUtils.ToStringBuilder(ReferenceDefinition.class, this.getClass());
        sb.addProp("startOffset", this.getStartOffset());
        sb.addProp("length", this.getLength());
        sb.addProp("name", (Object)this.referenceLabel);
        sb.addProp("href", ToStringHelper.toStringValue(this.href));
        sb.addProp("title", this.title);
        return sb.build();
    }
}

