/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.yaml.core.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.statet.internal.yaml.core.model.YamlSourceElement;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.model.core.elements.IModelElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;
import org.eclipse.statet.yaml.core.model.IYamlCompositeSourceElement;
import org.eclipse.statet.yaml.core.model.IYamlSourceElement;

public class CompositeSourceElement
extends YamlSourceElement.SourceContainer
implements IYamlCompositeSourceElement {
    private final ImList<? extends IYamlSourceElement> compositeElements;
    private final TextRegion sourceRange;
    private volatile List<IYamlSourceElement> allSourceChildren;

    public CompositeSourceElement(List<? extends IYamlSourceElement> elements, ISourceUnit su, TextRegion sourceRange) {
        super(su, null);
        this.compositeElements = ImCollections.toList(elements);
        this.sourceRange = sourceRange;
    }

    @Override
    public ImList<? extends IYamlSourceElement> getCompositeElements() {
        return this.compositeElements;
    }

    @Override
    public TextRegion getSourceRange() {
        return this.sourceRange;
    }

    @Override
    public boolean hasSourceChildren(IModelElement.Filter filter) {
        for (IYamlSourceElement element : this.compositeElements) {
            if (!element.hasSourceChildren(filter)) continue;
            return true;
        }
        return false;
    }

    public List<IYamlSourceElement> getSourceChildren(IModelElement.Filter filter) {
        if (filter == null) {
            ImList children = this.allSourceChildren;
            if (children == null) {
                Collection[] compositeLists = new List[this.compositeElements.size()];
                int i = 0;
                while (i < compositeLists.length) {
                    compositeLists[i] = ((IYamlSourceElement)this.compositeElements.get(i)).getSourceChildren(null);
                    ++i;
                }
                children = this.allSourceChildren = ImCollections.concatList((Collection[])compositeLists);
            }
            return children;
        }
        ArrayList<IYamlSourceElement> children = new ArrayList<IYamlSourceElement>();
        for (IYamlSourceElement element : this.compositeElements) {
            List<? extends IYamlSourceElement> list = element.getSourceChildren(null);
            for (IYamlSourceElement child : list) {
                if (!filter.include((IModelElement)child)) continue;
                children.add(child);
            }
        }
        return children;
    }
}

