/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.data;

import java.util.Map;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RObjectFactory;
import org.eclipse.statet.rj.data.RStore;

public class RDataJConverter {
    private boolean keepArray1;
    private RObjectFactory rObjectFactory;

    public void setKeepArray1(boolean enable) {
        this.keepArray1 = enable;
    }

    public void setRObjectFactory(RObjectFactory factory) {
        this.rObjectFactory = factory;
    }

    public RObjectFactory getRObjectFactory() {
        return this.rObjectFactory;
    }

    public Object toJava(RObject rObject) {
        switch (rObject.getRObjectType()) {
            case 2: {
                return this.toJava(rObject.getData());
            }
        }
        return null;
    }

    public Object toJava(RStore<?> rData) {
        ?[] array = rData.toArray();
        if (!this.keepArray1 && array != null && array.length == 1) {
            return array[0];
        }
        return array;
    }

    public RObject toRJ(Object javaObj) {
        if (javaObj instanceof Boolean) {
            return this.rObjectFactory.createVector(this.rObjectFactory.createLogiData(new boolean[]{(Boolean)javaObj}));
        }
        if (javaObj instanceof String) {
            return this.rObjectFactory.createVector(this.rObjectFactory.createCharData(new String[]{(String)javaObj}));
        }
        if (javaObj instanceof String[]) {
            return this.rObjectFactory.createVector(this.rObjectFactory.createCharData((String[])javaObj));
        }
        if (javaObj instanceof Map) {
            Map map = (Map)javaObj;
            String[] names = new String[map.size()];
            RObject[] components = new RObject[map.size()];
            int i = 0;
            for (Map.Entry entry : map.entrySet()) {
                names[i] = (String)entry.getKey();
                components[i] = this.toRJ(entry.getValue());
                ++i;
            }
            return this.rObjectFactory.createList(components, names);
        }
        return null;
    }
}

