/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.core.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.statet.ecommons.debug.core.model.IIndexedValue;
import org.eclipse.statet.ecommons.debug.core.model.VariablePartitionFactory;
import org.eclipse.statet.internal.r.debug.core.model.IRIndexElementValue;
import org.eclipse.statet.internal.r.debug.core.model.IRIndexValueInternal;
import org.eclipse.statet.internal.r.debug.core.model.RDebugTarget;
import org.eclipse.statet.internal.r.debug.core.model.RElementValue;
import org.eclipse.statet.internal.r.debug.core.model.RElementVariable;
import org.eclipse.statet.internal.r.debug.core.model.RElementVariableStore;
import org.eclipse.statet.internal.r.debug.core.model.RElementVariableValue;
import org.eclipse.statet.internal.r.debug.core.model.RListValue;
import org.eclipse.statet.internal.r.debug.core.model.RMainThread;
import org.eclipse.statet.internal.r.debug.core.model.RVariableProxy;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.console.core.RProcessREnvironment;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.debug.core.IRVariable;
import org.eclipse.statet.rj.data.RCharacterStore;

@NonNullByDefault
public class REnvValue
extends RElementValue<RProcessREnvironment>
implements IRIndexValueInternal {
    private final RMainThread thread;
    private @Nullable RElementVariable variable;
    private final RElementVariableStore childVariables;
    private @Nullable RProcessREnvironment previousElement;
    private @Nullable RElementVariableStore previousChildVariables;

    public REnvValue(RProcessREnvironment element, RMainThread thread, int stamp, @Nullable REnvValue previousValue) {
        super((RDebugTarget)thread.getDebugTarget(), element, stamp);
        this.thread = thread;
        this.childVariables = new RElementVariableStore(((RProcessREnvironment)this.element).getLength());
        if (previousValue != null) {
            this.previousElement = (RProcessREnvironment)previousValue.element;
            this.previousChildVariables = previousValue.childVariables;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setVariable(RElementVariable variable) {
        if (variable.getParent() != null) {
            return false;
        }
        RElementVariableStore rElementVariableStore = this.childVariables;
        synchronized (rElementVariableStore) {
            block5: {
                if (this.variable == null) break block5;
                return false;
            }
            this.variable = variable;
            this.childVariables.forEachSet(childVariable -> childVariable.setParent(variable));
            return true;
        }
    }

    @Override
    public IRVariable getAssignedVariable() {
        return this.variable;
    }

    @Override
    public String getReferenceTypeName() throws DebugException {
        return ((RProcessREnvironment)this.element).getRClassName();
    }

    @Override
    public boolean isAllocated() throws DebugException {
        return true;
    }

    @Override
    public String getValueString() throws DebugException {
        return this.getValueString(this.variable);
    }

    public String getValueString(IRVariable variable) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(((RProcessREnvironment)this.element).getLength());
        sb.append(']');
        String envName = null;
        RElementName elementName = ((RProcessREnvironment)this.element).getElementName();
        if (elementName != null && elementName.getNextSegment() == null && RElementName.isPackageFacetScopeType((int)elementName.getType())) {
            envName = elementName.getDisplayName();
        }
        if (envName == null) {
            envName = ((RProcessREnvironment)this.element).getEnvironmentName();
        }
        if (envName == null) {
            if (((RProcessREnvironment)this.element).getHandle() != 0L) {
                envName = Long.toString(((RProcessREnvironment)this.element).getHandle());
            }
        } else if (variable != null && envName.equals(variable.getName())) {
            envName = null;
        }
        if (envName != null) {
            sb.append("\u2002(");
            sb.append(envName);
            sb.append(')');
        }
        return sb.toString();
    }

    @Override
    public String getDetailString() {
        return this.getDetailString(this.variable);
    }

    public String getDetailString(IRVariable variable) {
        String envName = null;
        RElementName elementName = ((RProcessREnvironment)this.element).getElementName();
        if (elementName != null && elementName.getNextSegment() == null && RElementName.isPackageFacetScopeType((int)elementName.getType())) {
            envName = elementName.getDisplayName();
        }
        if (envName == null) {
            envName = ((RProcessREnvironment)this.element).getEnvironmentName();
        }
        if (envName == null && ((RProcessREnvironment)this.element).getHandle() != 0L) {
            envName = Long.toString(((RProcessREnvironment)this.element).getHandle());
        }
        return envName != null ? envName : "";
    }

    @Override
    public boolean hasVariables() throws DebugException {
        return ((RProcessREnvironment)this.element).hasModelChildren(null);
    }

    @Override
    public IVariable[] getVariables() throws DebugException {
        return this.getPartitionFactory().getVariables((IIndexedValue)this);
    }

    @Override
    public final VariablePartitionFactory<IRIndexElementValue> getPartitionFactory() {
        return RListValue.LIST_PARTITION_FACTORY;
    }

    public long getSize() throws DebugException {
        return ((RProcessREnvironment)this.element).getLength();
    }

    public @NonNull IRVariable[] getVariables(long offset, int length) {
        return this.getVariables(offset, length, this.variable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull IRVariable[] getVariables(long offset, int length, IRVariable parent) {
        RElementVariableStore rElementVariableStore = this.childVariables;
        synchronized (rElementVariableStore) {
            if (this.stamp != this.thread.getCurrentStamp()) {
                return RElementVariableValue.NO_VARIABLES;
            }
            IRVariable[] variables = new IRVariable[length];
            boolean direct = parent == this.variable;
            int i = 0;
            while (i < length) {
                long idx = offset + (long)i;
                RElementVariable childVariable = this.childVariables.get(idx);
                if (childVariable == null) {
                    CombinedRElement childElement = ((RProcessREnvironment)this.element).get(idx);
                    if (this.previousElement != null) {
                        childVariable = this.checkPreviousVariable(idx, childElement);
                    }
                    if (childVariable == null) {
                        childVariable = new RElementVariable(childElement, this.thread, this.stamp, this.variable);
                    }
                    this.childVariables.set(idx, childVariable);
                }
                variables[i] = direct ? childVariable : RVariableProxy.create(childVariable, parent);
                ++i;
            }
            return variables;
        }
    }

    protected RElementVariable checkPreviousVariable(long idx, CombinedRElement element) {
        RElementVariable previousVariable;
        RCharacterStore names = this.previousElement.getNames();
        if (names != null && (idx = names.indexOf(((RProcessREnvironment)this.getElement()).getName(idx))) >= 0L && idx < this.previousElement.getLength() && (previousVariable = this.previousChildVariables.clear(idx)) != null && previousVariable.update(element, this.stamp)) {
            return previousVariable;
        }
        return null;
    }
}

