/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.status;

import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.Statuses;

@NonNullByDefault
public abstract class AbstractStatus
implements Status {
    private final String bundleId;
    private final int code;
    private final String message;
    private final @Nullable Throwable exception;

    public AbstractStatus(String bundleId, int code, String message, @Nullable Throwable exception) {
        if (bundleId.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.bundleId = bundleId;
        this.code = code;
        this.message = ObjectUtils.nonNullElse(message, "");
        this.exception = exception;
    }

    @Override
    public final String getBundleId() {
        return this.bundleId;
    }

    @Override
    public final int getCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public @Nullable Throwable getException() {
        return this.exception;
    }

    @Override
    public boolean isMultiStatus() {
        return false;
    }

    @Override
    public ImList<Status> getChildren() {
        return ImCollections.emptyList();
    }

    public String toString() {
        ObjectUtils.ToStringBuilder sb = new ObjectUtils.ToStringBuilder("Status");
        sb.append(' ');
        sb.append(Statuses.getSeverityString(this.getSeverity()));
        sb.append(" [");
        sb.append(this.bundleId);
        sb.append(':');
        sb.append(this.code);
        sb.append(']');
        sb.addProp("message", this.message);
        sb.addProp("exception", this.exception);
        if (this.isMultiStatus()) {
            sb.addProp("children", this.getChildren());
        }
        return sb.toString();
    }
}

