/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.graphics.core;

import org.eclipse.statet.ecommons.graphics.core.ColorDef;
import org.eclipse.statet.ecommons.graphics.core.ColorRefDef;

public class ColorAlphaDef
extends ColorRefDef {
    private float fAlpha;

    public ColorAlphaDef(ColorDef ref, float alpha) {
        super(ref);
        if (alpha < 0.0f || alpha > 1.0f) {
            throw new IllegalArgumentException("alpha");
        }
        this.setAlpha(alpha);
    }

    public ColorAlphaDef(ColorDef ref, int alpha255) {
        super(ref);
        if (alpha255 < 0 || alpha255 > 255) {
            throw new IllegalArgumentException("alpha");
        }
        this.setAlpha((float)alpha255 / 255.0f);
    }

    protected void setAlpha(float alpha) {
        this.fAlpha = (float)Math.round(alpha * 1000.0f) / 1000.0f;
    }

    public float getAlpha() {
        return this.fAlpha;
    }

    public int getAlpha255() {
        return Math.round(this.fAlpha * 255.0f);
    }

    public final void printRGBAHex(StringBuilder sb) {
        this.printRGBHex(sb);
        int alpha255 = this.getAlpha255();
        if (alpha255 < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(alpha255));
    }

    @Override
    public int hashCode() {
        return super.hashCode() * (int)(235.0f * (1.0f + this.fAlpha));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ColorAlphaDef)) {
            return false;
        }
        ColorAlphaDef other = (ColorAlphaDef)obj;
        return this.fAlpha == other.fAlpha && this.getRef().equals(other.getRef());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getRef().toString());
        sb.append(" \u00d7 \u03b1: ");
        sb.append(this.fAlpha);
        return sb.toString();
    }
}

