/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.ui.editors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.statet.docmlet.wikitext.core.ast.Link;
import org.eclipse.statet.docmlet.wikitext.core.model.IWikitextSourceUnit;
import org.eclipse.statet.docmlet.wikitext.core.model.WikitextModel;
import org.eclipse.statet.docmlet.wikitext.core.model.WikitextNameAccess;
import org.eclipse.statet.internal.docmlet.wikitext.ui.editors.MarkupOpenHyperlinkHandler;
import org.eclipse.statet.internal.docmlet.wikitext.ui.editors.OpenMarkupElementHyperlink;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.util.OpenWorkspaceFileHyperlink;

public class MarkupHyperlinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        ISourceEditor editor = (ISourceEditor)this.getAdapter(ISourceEditor.class);
        if (editor == null) {
            return null;
        }
        IWikitextSourceUnit sourceUnit = WikitextModel.asWikitextSourceUnit((ISourceUnit)editor.getSourceUnit());
        if (sourceUnit == null) {
            return null;
        }
        ArrayList<OpenMarkupElementHyperlink> hyperlinks = new ArrayList<OpenMarkupElementHyperlink>(4);
        Link link = MarkupOpenHyperlinkHandler.searchLink(sourceUnit, region);
        if (link != null) {
            if (link.getLinkType() == 2) {
                for (Object attachment : link.getAttachments()) {
                    if (!(attachment instanceof WikitextNameAccess)) continue;
                    hyperlinks.add(new OpenMarkupElementHyperlink(editor, sourceUnit, (WikitextNameAccess)attachment));
                    break;
                }
            } else if (link.getUri() != null && !link.getUri().isEmpty()) {
                if (link.getUri().charAt(0) == '#') {
                    if (link.getUri().length() > 1) {
                        hyperlinks.add(new OpenMarkupElementHyperlink(editor, sourceUnit, (TextRegion)link, link.getUri().substring(1)));
                    }
                } else {
                    List<IFile> files = MarkupOpenHyperlinkHandler.refLocalFile(editor, link);
                    for (IFile file : files) {
                        hyperlinks.add((OpenMarkupElementHyperlink)new OpenWorkspaceFileHyperlink((TextRegion)link, file));
                    }
                }
            }
        }
        if (!hyperlinks.isEmpty()) {
            return hyperlinks.toArray(new IHyperlink[hyperlinks.size()]);
        }
        return null;
    }
}

