/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.core.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.statet.internal.r.debug.core.model.RDebugTarget;
import org.eclipse.statet.internal.r.debug.core.model.RElementVariable;
import org.eclipse.statet.internal.r.debug.core.model.RElementVariableCompactStore;
import org.eclipse.statet.internal.r.debug.core.model.RElementVariableValue;
import org.eclipse.statet.internal.r.debug.core.model.RLanguageValue;
import org.eclipse.statet.internal.r.debug.core.model.RObjectAdapter;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.core.data.RValueFormatter;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.debug.core.IRVariable;
import org.eclipse.statet.r.nico.ICombinedRDataAdapter;
import org.eclipse.statet.rj.data.RLanguage;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.UnexpectedRDataException;
import org.eclipse.statet.rj.data.impl.RPromiseImpl;
import org.eclipse.statet.rj.services.FQRObject;
import org.eclipse.statet.rj.services.FQRObjectRef;
import org.eclipse.statet.rj.services.RService;
import org.eclipse.statet.rj.services.util.dataaccess.LazyRStore;
import org.eclipse.statet.rj.ts.core.RToolService;

@NonNullByDefault
public class RPromiseValue
extends RElementVariableValue<CombinedRElement> {
    private static final RObjectAdapter<RPromiseImpl> ADAPTER = new RObjectAdapter<RPromiseImpl>(18){

        @Override
        public RPromiseImpl loadObject(FQRObjectRef ref, RObject referenceObject, LazyRStore.Fragment<RPromiseImpl> fragment, RService r, ProgressMonitor m) throws StatusException, UnexpectedRDataException {
            FQRObject fqrObject = r.findData(((RLanguage)ref.getName()).getSource(), ref.getEnv(), false, null, this.getLoadOptions(), -1, m);
            RObject object = fqrObject != null ? fqrObject.getObject() : null;
            return this.validateObject(object, referenceObject, fragment);
        }
    };
    private @Nullable LazyRStore<RPromiseImpl> detailObjectStore;
    private boolean validationFailed;
    private final RElementVariableCompactStore detailVariables = new RElementVariableCompactStore(2);

    public RPromiseValue(RElementVariable variable) {
        super(variable);
    }

    public final RObject getRObject() {
        return this.element;
    }

    public final @Nullable RPromiseValue getVariablePreviousValue() {
        return (RPromiseValue)this.variable.getPreviousValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getValueString() throws DebugException {
        RLanguage exprObject;
        LazyRStore.Fragment<RPromiseImpl> fragment;
        RPromiseValue rPromiseValue = this;
        synchronized (rPromiseValue) {
            fragment = this.getDetailObjectFragment();
            if (fragment == null || fragment.getRObject() == null) {
                return "";
            }
        }
        RPromiseImpl rObject = (RPromiseImpl)fragment.getRObject();
        if (rObject.getExpression() instanceof RLanguage && (exprObject = (RLanguage)rObject.getExpression()).getSource() != null) {
            RValueFormatter valueFormatter;
            RValueFormatter rValueFormatter = valueFormatter = ((RDebugTarget)this.getDebugTarget()).getValueFormatter();
            synchronized (rValueFormatter) {
                valueFormatter.clear();
                valueFormatter.append("= ");
                RLanguageValue.appendValue(valueFormatter, exprObject);
                return valueFormatter.getString();
            }
        }
        return "";
    }

    @Override
    public String getDetailString() {
        return !this.validationFailed ? "<not yet evaluated>" : "";
    }

    @Override
    public boolean hasVariables() throws DebugException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IVariable[] getVariables() throws DebugException {
        LazyRStore.Fragment<RPromiseImpl> fragment;
        RPromiseValue previousValue;
        RElementVariable rElementVariable = this.variable;
        synchronized (rElementVariable) {
            if (this != this.variable.getCurrentValue()) {
                return NO_VARIABLES;
            }
            previousValue = this.getVariablePreviousValue();
        }
        @Nullable Object[] variables = new IRVariable[2];
        RElementVariableCompactStore rElementVariableCompactStore = this.detailVariables;
        synchronized (rElementVariableCompactStore) {
            this.detailVariables.toArray((IRVariable[])variables, 0);
            if (!ObjectUtils.isAnyNull((Object[])variables)) {
                return variables;
            }
        }
        Object object = this;
        synchronized (object) {
            fragment = this.getDetailObjectFragment();
            if (fragment == null || fragment.getRObject() == null) {
                if (this.validationFailed) {
                    return NO_VARIABLES;
                }
                throw this.newRequestLoadDataFailed();
            }
        }
        object = this.detailVariables;
        synchronized (object) {
            int idx = 0;
            while (idx < 2) {
                RElementVariable childVariable = this.detailVariables.get(idx);
                if (childVariable == null) {
                    String label;
                    RObject dataObject;
                    switch (idx) {
                        case 0: {
                            dataObject = (RObject)ObjectUtils.nonNullAssert((Object)((RPromiseImpl)fragment.getRObject()).getExpression());
                            label = "expression";
                            break;
                        }
                        case 1: {
                            dataObject = (RObject)ObjectUtils.nonNullAssert((Object)((RPromiseImpl)fragment.getRObject()).getEnvironment());
                            label = "environment";
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                    CombinedRElement childElement = ICombinedRDataAdapter.create((RObject)dataObject, (RElementName)RElementName.create((int)16, (String)label));
                    if (previousValue != null) {
                        childVariable = this.checkPreviousVariable(previousValue, idx, childElement);
                    }
                    if (childVariable == null) {
                        childVariable = new RElementVariable(childElement, this.variable.getThread(), this.stamp, this.variable);
                        if (dataObject instanceof RLanguage) {
                            RLanguageValue childValue = (RLanguageValue)childVariable.getValue();
                            childValue.setDataObject((RLanguage)dataObject);
                        }
                    }
                    this.detailVariables.set(idx, childVariable);
                }
                variables[idx] = childVariable;
                ++idx;
            }
            return variables;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected @Nullable RElementVariable checkPreviousVariable(RPromiseValue previousValue, int idx, CombinedRElement element) {
        if (idx >= 0 && (long)idx < previousValue.element.getLength()) {
            RElementVariable previousVariable;
            RPromiseValue rPromiseValue = previousValue;
            synchronized (rPromiseValue) {
                previousVariable = previousValue.detailVariables.clear(idx);
            }
            if (previousVariable != null && previousVariable.update(element, this.stamp)) {
                return previousVariable;
            }
        }
        return null;
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable LazyRStore.Fragment<RPromiseImpl> getDetailObjectFragment() {
        if (this.detailObjectStore == null) {
            this.detailObjectStore = new LazyRStore(1L, 1L, 1, (LazyRStore.Updater)new RElementVariableValue.RDataLoader<RPromiseImpl>((RElementVariableValue)this){

                @Override
                protected RPromiseImpl doLoad(FQRObjectRef ref, LazyRStore.Fragment<RPromiseImpl> fragment, RToolService r, ProgressMonitor m) throws StatusException, UnexpectedRDataException {
                    try {
                        return ADAPTER.loadObject(ref, RPromiseValue.this.getRObject(), fragment, (RService)r, m);
                    }
                    catch (UnexpectedRDataException e) {
                        RPromiseValue.this.validationFailed = true;
                        throw e;
                    }
                }
            });
        }
        return this.detailObjectStore.getFragment(0L, 0L, 0, null);
    }
}

