/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.statet.ecommons.runtime.core.util.StatusUtils;
import org.eclipse.statet.ecommons.ui.dialogs.DialogUtils;
import org.eclipse.statet.internal.nico.ui.NicoUIPlugin;
import org.eclipse.statet.internal.nico.ui.SaveHistoryPage;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.nico.core.runtime.History;
import org.eclipse.statet.nico.core.runtime.SubmitType;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.ui.NicoUIMessages;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.statushandlers.StatusManager;

public class SaveHistoryWizard
extends Wizard {
    private static final String STORE_SECTION = "tools/LoadSaveHistoryWizard";
    private final ToolProcess fProcess;
    private SaveHistoryPage fPage;

    public SaveHistoryWizard(ToolProcess process) {
        this.fProcess = process;
        this.setDialogSettings(DialogUtils.getDialogSettings((AbstractUIPlugin)NicoUIPlugin.getInstance(), (String)STORE_SECTION));
        this.setWindowTitle(NicoUIMessages.SaveHistory_title);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.fPage = new SaveHistoryPage(this.fProcess);
        this.addPage((IWizardPage)this.fPage);
    }

    public boolean performFinish() {
        this.fPage.saveSettings();
        try {
            final History history = this.fProcess.getHistory();
            final Object file = this.fPage.getFile();
            final String charset = this.fPage.fEncoding;
            int mode = 0;
            if (this.fPage.fOverwriteFile) {
                mode |= 2;
            }
            if (this.fPage.fAppendToFile) {
                mode |= 1;
            }
            final int fmode = mode;
            assert (history != null);
            assert (file != null);
            assert (charset != null);
            final Set<SubmitType> types = this.fPage.getContentSubmitTypes();
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    Status status = history.save(file, fmode, charset, false, types, StatusUtils.convert((IProgressMonitor)monitor));
                    if (status.getSeverity() == 4) {
                        throw new InvocationTargetException(new CoreException(StatusUtils.convert((Status)status)));
                    }
                }
            });
            return true;
        }
        catch (OperationCanceledException e) {
            return false;
        }
        catch (Exception e) {
            Throwable cause;
            if (e instanceof InvocationTargetException && (cause = ((InvocationTargetException)e).getTargetException()) instanceof CoreException) {
                StatusManager.getManager().handle(((CoreException)cause).getStatus(), 3);
                return false;
            }
            NicoUIPlugin.logError(100, "Error of unexpected type occured, when performing save history.", e);
            return false;
        }
    }
}

