/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.base.ext.ui.text;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.statet.base.core.preferences.TaskTagsPreferences;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.text.ui.presentation.AbstractRuleBasedScanner;
import org.eclipse.statet.ecommons.text.ui.settings.TextStyleManager;
import org.eclipse.statet.ecommons.ui.ISettingsChangedHandler;

public class CommentScanner
extends AbstractRuleBasedScanner
implements ISettingsChangedHandler {
    private TaskTagRule taskTagRule;
    private final String commentTokenKey;
    private final String taskTokenKey;

    public CommentScanner(TextStyleManager textStyles, String commentTokenKey, String taskTokenKey, PreferenceAccess corePrefs) {
        super(textStyles);
        this.commentTokenKey = commentTokenKey;
        this.taskTokenKey = taskTokenKey;
        this.initRules();
        this.loadTaskTags(corePrefs);
    }

    protected void createRules(List<IRule> rules) {
        IToken defaultToken = this.getToken(this.commentTokenKey);
        IToken taskToken = this.getToken(this.taskTokenKey);
        this.setDefaultReturnToken(defaultToken);
        this.taskTagRule = new TaskTagRule(taskToken, defaultToken);
        rules.add((IRule)this.taskTagRule);
    }

    public void handleSettingsChanged(Set<String> groupIds, Map<String, Object> options) {
        if (groupIds.contains("statet.task_tags")) {
            PreferenceAccess prefs = (PreferenceAccess)options.get("context.PrefAccess");
            this.loadTaskTags(prefs);
            options.put("affects.Presentation", Boolean.TRUE);
        }
    }

    public void loadTaskTags(PreferenceAccess prefs) {
        this.taskTagRule.clearTaskTags();
        String[] tags = TaskTagsPreferences.loadTagsOnly((PreferenceAccess)prefs);
        if (tags != null) {
            this.taskTagRule.addTaskTags(tags);
        }
    }

    private static class TaskTagDetector
    implements IWordDetector {
        private TaskTagDetector() {
        }

        public boolean isWordStart(char c) {
            return Character.isLetterOrDigit(c);
        }

        public boolean isWordPart(char c) {
            return Character.isLetterOrDigit(c);
        }
    }

    private static class TaskTagRule
    extends WordRule {
        private final IToken token;

        public TaskTagRule(IToken token, IToken defaultToken) {
            super((IWordDetector)new TaskTagDetector(), defaultToken);
            this.token = token;
        }

        public void clearTaskTags() {
            this.fWords.clear();
        }

        public void addTaskTags(String[] tags) {
            String[] stringArray = tags;
            int n = tags.length;
            int n2 = 0;
            while (n2 < n) {
                String tag = stringArray[n2];
                this.addWord(tag, this.token);
                ++n2;
            }
        }
    }
}

