/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.databinding;

import com.ibm.icu.text.NumberFormat;
import java.text.ParsePosition;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class LongValidator
implements IValidator {
    private final NumberFormat formatter;
    private final long min;
    private final long max;
    private final boolean allowEmpty;
    private final String message;

    public LongValidator(long min, long max, String message) {
        this(min, max, false, message);
    }

    public LongValidator(long min, long max, boolean allowEmpty, String message) {
        this.min = min;
        this.max = max;
        this.allowEmpty = allowEmpty;
        this.message = message;
        this.formatter = NumberFormat.getIntegerInstance();
        this.formatter.setParseIntegerOnly(true);
    }

    public IStatus validate(Object value) {
        if (value instanceof String) {
            long n;
            String s = ((String)value).trim();
            if (this.allowEmpty && s.length() == 0) {
                return Status.OK_STATUS;
            }
            ParsePosition result = new ParsePosition(0);
            Number number = this.formatter.parse(s, result);
            if (result.getIndex() == s.length() && result.getErrorIndex() < 0 && (n = number.longValue()) >= this.min && n <= this.max) {
                return Status.OK_STATUS;
            }
        }
        return ValidationStatus.error((String)this.message);
    }
}

